/*
 * Decompiled with CFR 0.152.
 */
package core.files.reader;

import core.files.FileHelper;
import core.files.validator.FileExtensionValidator;
import core.files.validator.FileStatusValidator;
import core.reports.TestReporter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ReadExcelFile {
    private static Workbook readExcelWorkbook(String excelFile) {
        if (!FileStatusValidator.isFileExist(excelFile).booleanValue()) {
            excelFile = FileHelper.getFileAbsolutePath(excelFile);
        }
        FileStatusValidator.verifyFileStatus(excelFile);
        FileExtensionValidator.verifyExcelFileType(excelFile);
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)new FileInputStream(excelFile));
        }
        catch (IOException e) {
            TestReporter.error("Unable to read provided excel sheet, Please check your excel path: " + excelFile, e, true);
        }
        return workbook;
    }

    private static Sheet getExcelSheetByName(String excelFile, String sheetName) {
        try {
            return ReadExcelFile.readExcelWorkbook(excelFile).getSheet(sheetName);
        }
        catch (Throwable throwable) {
            TestReporter.error("Please check if you provided existing sheet name, You provided sheet name: " + sheetName, throwable, true);
            return null;
        }
    }

    private static Sheet getExcelSheetByIndex(String excelFile, int sheetNo) {
        try {
            sheetNo = sheetNo > 0 ? sheetNo : 1;
            String sheetName = ReadExcelFile.readExcelWorkbook(excelFile).getSheetAt(sheetNo - 1).getSheetName();
            return ReadExcelFile.getExcelSheetByName(excelFile, sheetName);
        }
        catch (Throwable throwable) {
            TestReporter.error("Please check if you provided existing sheet number, You provided No: " + sheetNo, throwable, true);
            return null;
        }
    }

    private static String getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case _NONE: {
                return "";
            }
            case BLANK: {
                return "";
            }
            case ERROR: {
                return "";
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return "";
            }
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
        }
        return "";
    }

    private static Row getRowObject(Sheet sheet, int rowNo) {
        try {
            rowNo = rowNo > 0 ? rowNo : 1;
            return sheet.getRow(rowNo - 1);
        }
        catch (Throwable throwable) {
            TestReporter.error("Please check if you provided exist row number, You provided row No: " + rowNo, throwable, true);
            return null;
        }
    }

    private static ArrayList<String> getRowData(Row row) {
        if (row == null) {
            TestReporter.error("You provided Row Object with null value in getRowData method.", true);
        }
        ArrayList<String> rowData = new ArrayList<String>();
        for (Cell cell : row) {
            String cellValue = ReadExcelFile.getCellValue(cell) != null ? ReadExcelFile.getCellValue(cell) : "";
            rowData.add(cellValue);
        }
        rowData.removeAll(Arrays.asList(""));
        return rowData;
    }

    private static ArrayList<String> getColumnData(ArrayList<ArrayList<String>> rows, int columnNo) {
        ArrayList<String> columnValues = new ArrayList<String>();
        columnNo = columnNo > 0 ? columnNo : 1;
        for (ArrayList<String> row : rows) {
            String cellValue = row.size() >= columnNo ? row.get(columnNo - 1) : "";
            columnValues.add(cellValue);
        }
        columnValues.remove(0);
        return columnValues;
    }

    private static ArrayList<ArrayList<String>> getSheetData(Sheet sheet) {
        Iterator allRows = sheet.rowIterator();
        ArrayList<ArrayList<String>> rowsData = new ArrayList<ArrayList<String>>();
        while (allRows.hasNext()) {
            Row row = (Row)allRows.next();
            ArrayList<String> rowData = ReadExcelFile.getRowData(row);
            if (rowData.size() <= 0) continue;
            rowsData.add(rowData);
        }
        return rowsData;
    }

    public static boolean isRowExist(String excelFile, String sheetName, int rowNo) {
        rowNo = rowNo > 0 ? rowNo : 1;
        return ReadExcelFile.getExcelSheetByName(excelFile, sheetName).getRow(rowNo - 1) != null;
    }

    public static boolean isRowExist(String excelFile, int sheetNo, int rowNo) {
        rowNo = rowNo > 0 ? rowNo : 1;
        return ReadExcelFile.getExcelSheetByIndex(excelFile, sheetNo).getRow(rowNo - 1) != null;
    }

    public static boolean isRowExist(String excelFile, int rowNo) {
        rowNo = rowNo > 0 ? rowNo : 1;
        return ReadExcelFile.getExcelSheetByIndex(excelFile, 1).getRow(rowNo - 1) != null;
    }

    public static int getNumberOfSheets(String excelFile) {
        return ReadExcelFile.readExcelWorkbook(excelFile).getNumberOfSheets();
    }

    public static int getSheetNumber(String excelFile, String sheetName) {
        return ReadExcelFile.readExcelWorkbook(excelFile).getSheetIndex(sheetName) + 1;
    }

    public static String getSheetName(String excelFile, int sheetNo) {
        sheetNo = sheetNo > 0 ? sheetNo : 1;
        return ReadExcelFile.readExcelWorkbook(excelFile).getSheetName(sheetNo - 1);
    }

    public static ArrayList<ArrayList<String>> getSheetData(String excelFile, int sheetNo) {
        return ReadExcelFile.getSheetData(ReadExcelFile.getExcelSheetByIndex(excelFile, sheetNo));
    }

    public static ArrayList<ArrayList<String>> getSheetData(String excelFile, String sheetName) {
        return ReadExcelFile.getSheetData(ReadExcelFile.getExcelSheetByName(excelFile, sheetName));
    }

    public static ArrayList<ArrayList<String>> getSheetData(String excelFile) {
        return ReadExcelFile.getSheetData(excelFile, 1);
    }

    public static ArrayList<String> getRowData(String excelFile, String sheetName, int rowNo) {
        Row row = ReadExcelFile.getRowObject(ReadExcelFile.getExcelSheetByName(excelFile, sheetName), rowNo);
        return ReadExcelFile.getRowData(row);
    }

    public static ArrayList<String> getRowData(String excelFile, int sheetNo, int rowNo) {
        Row row = ReadExcelFile.getRowObject(ReadExcelFile.getExcelSheetByIndex(excelFile, sheetNo), rowNo);
        return ReadExcelFile.getRowData(row);
    }

    public static ArrayList<String> getRowData(String excelFile, int rowNo) {
        Row row = ReadExcelFile.getRowObject(ReadExcelFile.getExcelSheetByIndex(excelFile, 1), rowNo);
        if (row == null) {
            TestReporter.error("Please check Row number you provided isn't exist, Row No: " + rowNo, true);
        }
        return ReadExcelFile.getRowData(row);
    }

    public static ArrayList<String> getColumnData(String excelFile, String sheetName, int columnNo) {
        ArrayList<ArrayList<String>> rows = ReadExcelFile.getSheetData(excelFile, sheetName);
        return ReadExcelFile.getColumnData(rows, columnNo);
    }

    public static ArrayList<String> getColumnData(String excelFile, int sheetNo, int columnNo) {
        ArrayList<ArrayList<String>> rows = ReadExcelFile.getSheetData(excelFile, sheetNo);
        return ReadExcelFile.getColumnData(rows, columnNo);
    }

    public static ArrayList<String> getColumnData(String excelFile, String sheetName, String headerName) {
        ArrayList<ArrayList<String>> rows = ReadExcelFile.getSheetData(excelFile, sheetName);
        int columnNo = rows.get(0).indexOf(headerName) + 1;
        return ReadExcelFile.getColumnData(rows, columnNo);
    }

    public static ArrayList<String> getColumnData(String excelFile, int sheetNo, String headerName) {
        ArrayList<ArrayList<String>> rows = ReadExcelFile.getSheetData(excelFile, sheetNo);
        int columnNo = rows.get(0).indexOf(headerName) + 1;
        if (columnNo == 0) {
            TestReporter.error("Please check excel header name you provided isn't exist, You provided: " + headerName, true);
        }
        return ReadExcelFile.getColumnData(rows, columnNo);
    }

    public static ArrayList<String> getColumnData(String excelFile, int columnNo) {
        return ReadExcelFile.getColumnData(excelFile, 1, columnNo);
    }

    public static ArrayList<String> getColumnData(String excelFile, String headerName) {
        return ReadExcelFile.getColumnData(excelFile, 1, headerName);
    }

    public static ArrayList<ArrayList<String>> getRowsInclude(String excelFile, String sheetName, String containsString) {
        ArrayList<ArrayList<String>> rows = ReadExcelFile.getSheetData(excelFile, sheetName);
        ArrayList<ArrayList<String>> rowsContains = new ArrayList<ArrayList<String>>();
        for (ArrayList<String> row : rows) {
            for (String cell : row) {
                if (!cell.contains(containsString)) continue;
                rowsContains.add(row);
            }
        }
        return rowsContains;
    }

    public static ArrayList<ArrayList<String>> getRowsInclude(String excelFile, int sheetNo, String containsString) {
        ArrayList<ArrayList<String>> rows = ReadExcelFile.getSheetData(excelFile, sheetNo);
        ArrayList<ArrayList<String>> rowsContains = new ArrayList<ArrayList<String>>();
        for (ArrayList<String> row : rows) {
            for (String cell : row) {
                if (!cell.contains(containsString)) continue;
                rowsContains.add(row);
            }
        }
        return rowsContains;
    }

    public static ArrayList<ArrayList<String>> getColumnsData(String excelFile, int sheetNo, int ... columnsNo) {
        ArrayList<ArrayList<String>> columnsValues = new ArrayList<ArrayList<String>>();
        for (int columnNo : columnsNo) {
            columnsValues.add(ReadExcelFile.getColumnData(excelFile, sheetNo, columnNo));
        }
        return columnsValues;
    }

    public static ArrayList<ArrayList<String>> getColumnsData(String excelFile, String sheetName, int ... columnsNo) {
        ArrayList<ArrayList<String>> columnsValues = new ArrayList<ArrayList<String>>();
        for (int columnNo : columnsNo) {
            columnsValues.add(ReadExcelFile.getColumnData(excelFile, sheetName, columnNo));
        }
        return columnsValues;
    }

    public static ArrayList<ArrayList<String>> getColumnsData(String excelFile, int sheetNo, String ... headerNames) {
        ArrayList<ArrayList<String>> columnsValues = new ArrayList<ArrayList<String>>();
        for (String headerName : headerNames) {
            columnsValues.add(ReadExcelFile.getColumnData(excelFile, sheetNo, headerName));
        }
        return columnsValues;
    }

    public static ArrayList<ArrayList<String>> getColumnsData(String excelFile, String sheetName, String ... headerNames) {
        ArrayList<ArrayList<String>> columnsValues = new ArrayList<ArrayList<String>>();
        for (String headerName : headerNames) {
            columnsValues.add(ReadExcelFile.getColumnData(excelFile, sheetName, headerName));
        }
        return columnsValues;
    }
}

