/*
 * Decompiled with CFR 0.152.
 */
package core.files;

import core.files.validator.FileStatusValidator;
import core.files.writer.WriteTXTFile;
import core.internal.EnvironmentInterface;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileHelper {
    public static String getFileAbsolutePath(String fileName) {
        String filePath = fileName.replace(new File(fileName).getName(), "");
        fileName = new File(fileName).getName();
        Iterator iterator = FileUtils.iterateFiles((File)new File("src/"), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.getName().equalsIgnoreCase(fileName) || !file.getPath().contains(filePath)) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String createTempFile(String fileName, String content) {
        String filePath = EnvironmentInterface.TEMP_RESOURCES_PATH + fileName;
        if (FileStatusValidator.isFileExist(filePath).booleanValue()) {
            FileHelper.deleteFile(filePath);
        }
        WriteTXTFile.writeTxtFile(filePath, content);
        return filePath;
    }

    public static void createFolders(String filePath) {
        if (new File(filePath).getParentFile() != null) {
            new File(filePath).getParentFile().mkdirs();
        }
    }

    public static void deleteFile(String fileName) {
        if (!FileStatusValidator.isFileExist(fileName).booleanValue()) {
            fileName = FileHelper.getFileAbsolutePath(fileName);
        }
        if (FileStatusValidator.isFileExist(fileName).booleanValue()) {
            new File(fileName).delete();
        }
    }
}

