/*
 * Decompiled with CFR 0.152.
 */
package core.files.Conversion;

import core.files.reader.ReadTXTFile;
import core.files.writer.WriteExcelFile;
import core.reports.TestReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ConvertCSVToExcel {
    public static void convertCSVToExcel(String csvFilePath, String excelFilePath) {
        List<String> fileContent = ReadTXTFile.readTxtFile(csvFilePath);
        String sheetName = new File(csvFilePath).getName().replaceAll(".csv", "");
        int counter = 0;
        for (String line : fileContent) {
            ArrayList<String> lineList = new ArrayList<String>();
            lineList.add(line);
            if (counter == 0) {
                WriteExcelFile.writeHeaderToExcelSheet(excelFilePath, sheetName, lineList);
                ++counter;
                continue;
            }
            WriteExcelFile.writeRowToExcelSheet(excelFilePath, sheetName, counter, lineList);
            ++counter;
        }
    }

    public static void convertListCSVsToExcel(String csvFolderPath, String excelFilePath) {
        File[] files;
        if (!new File(csvFolderPath).isDirectory()) {
            TestReporter.error("CSV Folder Path Provided isn't directory or hasn't files, Please check: " + csvFolderPath, false);
        }
        for (File file : files = new File(csvFolderPath).listFiles()) {
            ConvertCSVToExcel.convertCSVToExcel(file.getPath(), excelFilePath);
        }
    }
}

