/*
 * Decompiled with CFR 0.152.
 */
package core.database.reader;

import core.database.DBConnection;
import core.files.reader.ReadPropFile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MySql {
    public static Statement getMySqlConnection(String dbInfoFile) {
        String driver = ReadPropFile.getProperty(dbInfoFile, "driver_name");
        String connectionURL = ReadPropFile.getProperty(dbInfoFile, "connection_url");
        String hostURL = ReadPropFile.getProperty(dbInfoFile, "host_url");
        String username = ReadPropFile.getProperty(dbInfoFile, "username");
        String password = ReadPropFile.getProperty(dbInfoFile, "password");
        String connectionString = connectionURL + hostURL + username + password;
        Statement statement = DBConnection.dbConnect(driver, connectionString);
        return statement;
    }

    public static ResultSet getQueryResult(String dbInfoFile) {
        String queryString = ReadPropFile.getProperty(dbInfoFile, "query");
        return MySql.getQueryResult(dbInfoFile, queryString);
    }

    public static ResultSet getQueryResult(String dbInfoFile, String query) {
        Statement statement = MySql.getMySqlConnection(dbInfoFile);
        ResultSet queryResult = null;
        try {
            queryResult = statement.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return queryResult;
    }

    public static List<String> getColumnResult(String dbInfoFile) {
        String query = ReadPropFile.getProperty(dbInfoFile, "query");
        String columnName = ReadPropFile.getProperty(dbInfoFile, "column");
        return MySql.getColumnResult(dbInfoFile, query, columnName);
    }

    public static List<String> getColumnResult(String dbInfoFile, String columnName) {
        String query = ReadPropFile.getProperty(dbInfoFile, "query");
        return MySql.getColumnResult(dbInfoFile, query, columnName);
    }

    public static List<String> getColumnResult(String dbInfoFile, String query, String columnName) {
        ResultSet resultSet = MySql.getQueryResult(dbInfoFile, query);
        ArrayList<String> columnResult = new ArrayList<String>();
        try {
            while (resultSet.next()) {
                columnResult.add(resultSet.getString(columnName));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnResult;
    }

    public static String getRowResult(String dbInfoFile) {
        String query = ReadPropFile.getProperty(dbInfoFile, "query");
        String rowNumber = ReadPropFile.getProperty(dbInfoFile, "row");
        return MySql.getRowResult(dbInfoFile, query, rowNumber);
    }

    public static String getRowResult(String dbInfoFile, String rowNumber) {
        String query = ReadPropFile.getProperty(dbInfoFile, "query");
        return MySql.getRowResult(dbInfoFile, query, rowNumber);
    }

    private static String getRowResult(String dbInfoFile, String query, String rowNumber) {
        ResultSet resultSet = MySql.getQueryResult(dbInfoFile, query);
        String rowResult = null;
        try {
            rowResult = resultSet.getRowId(rowNumber).toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowResult;
    }
}

