/*
 * Decompiled with CFR 0.152.
 */
package core.annotations;

import core.files.FileHelper;
import core.files.reader.ReadTXTFile;
import core.handlers.StringHandler;
import core.reports.TestReporter;
import java.util.HashMap;

public class AttributesHandler {
    private static String classDataFile = "";
    private static String classTestFile = "";
    private static String methodTestFile = "";
    private static String methodDataRow = "";

    public static void setClassDataFile(String dataFile) {
        classDataFile = dataFile == null ? "" : FileHelper.getFileAbsolutePath(dataFile);
    }

    public static String getClassDataFile() {
        return classDataFile;
    }

    public static void setClassTestFile(String testFile) {
        classTestFile = testFile == null ? "" : FileHelper.getFileAbsolutePath(testFile);
    }

    public static String getClassTestFile() {
        return classTestFile;
    }

    public static void setMethodDataRow(String dataRow) {
        if (dataRow == null) {
            methodDataRow = "";
        }
        methodDataRow = dataRow;
    }

    public static String getMethodDataRow() {
        return methodDataRow;
    }

    public static void setMethodTestFile(String testFile) {
        if (testFile == null) {
            methodTestFile = "";
        }
        methodTestFile = testFile;
    }

    public static String getMethodTestFile() {
        return methodTestFile;
    }

    public static String getDataRow(String fileType, int rowNumber) {
        if (StringHandler.isStringBlank(AttributesHandler.getClassDataFile())) {
            TestReporter.error("Test Data File Path is Empty.", true);
        }
        if (fileType.equalsIgnoreCase("csv")) {
            return AttributesHandler.getCSVDataRow(AttributesHandler.getClassDataFile(), rowNumber).toString();
        }
        return AttributesHandler.getTXTDataRow(AttributesHandler.getClassDataFile(), rowNumber);
    }

    private static String getTXTDataRow(String filePath, int rowNumber) {
        return ReadTXTFile.getRowOfTxtFile(filePath, rowNumber);
    }

    private static HashMap<String, String> getCSVDataRow(String filePath, int rowNumber) {
        String[] header = AttributesHandler.getTXTDataRow(filePath, 0).split(",");
        String[] row = AttributesHandler.getTXTDataRow(filePath, rowNumber).split(",");
        HashMap<String, String> rowData = new HashMap<String, String>();
        for (int counter = 0; counter < header.length; ++counter) {
            rowData.put(header[counter], row[counter]);
        }
        return rowData;
    }

    public static String getValueOfDataRow() {
        if (StringHandler.isStringBlank(methodDataRow)) {
            TestReporter.error("DataRow has no data, Please check if you provide method DataRow attribute or provided Row number has data", true);
        }
        String dataRowValue = AttributesHandler.getMethodDataRow().split(",")[0];
        String newDataRow = AttributesHandler.getMethodDataRow().replaceFirst(dataRowValue, "");
        if (newDataRow.startsWith(",")) {
            newDataRow = newDataRow.replaceFirst(",", "");
        }
        AttributesHandler.setMethodDataRow(newDataRow);
        return dataRowValue;
    }

    public static String getValueOfDataRow(String key) {
        return StringHandler.getHashMapFromString("=", AttributesHandler.getMethodDataRow()).get(key) + "";
    }

    public static void resetMethodAttributes() {
        AttributesHandler.setMethodTestFile(null);
        AttributesHandler.setMethodDataRow(null);
    }

    public static void resetClassAttributes() {
        AttributesHandler.setClassTestFile(null);
        AttributesHandler.setClassDataFile(null);
    }
}

