/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.annotations.AttributesConfig;
import core.annotations.AttributesHandler;
import core.annotations.ClassAttributes;
import core.annotations.MethodAttributes;
import core.handlers.StringHandler;
import core.internal.EnvironmentInterface;
import core.reports.TestReporter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class TestNGMethods {
    private static Class runningTestClass = null;
    private static Method runningTestMethod = null;
    AttributesConfig attributesConfig = new AttributesConfig();

    public static Class getRunningTestClass() {
        return runningTestClass;
    }

    public static void setRunningTestClass(Class runningTestClass) {
        TestNGMethods.runningTestClass = runningTestClass;
    }

    public static Method getRunningTestMethod() {
        return runningTestMethod;
    }

    public static void setRunningTestMethod(Method runningTestMethod) {
        TestNGMethods.runningTestMethod = runningTestMethod;
    }

    public void setUpSuite(ITestContext testContext) {
        TestReporter.prepareReport(testContext);
    }

    public void tearDownSuite() {
        TestReporter.generateFinalReport();
    }

    public void setUpTest(ITestContext testContext) {
        TestReporter.prepareTestReport(testContext);
    }

    public void tearDownTest() {
        TestReporter.generateTestReport();
        try {
            FileUtils.deleteDirectory((File)new File(EnvironmentInterface.TEMP_RESOURCES_PATH));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setUpClass() {
        String dataFile = "";
        String testFile = "";
        TestNGMethods.setRunningTestClass(this.getClass());
        ClassAttributes classAttributes = null;
        if (TestNGMethods.getRunningTestClass().getAnnotation(ClassAttributes.class) != null) {
            classAttributes = this.getClass().getAnnotation(ClassAttributes.class);
        }
        if (classAttributes != null) {
            testFile = this.attributesConfig.getTestFile(classAttributes);
            dataFile = this.attributesConfig.getDataFile(classAttributes);
        }
        if (!StringHandler.isStringBlank(testFile)) {
            AttributesHandler.setClassTestFile(testFile);
        }
        if (!StringHandler.isStringBlank(dataFile)) {
            AttributesHandler.setClassDataFile(dataFile);
        }
    }

    public void tearDownClass() {
        AttributesHandler.resetClassAttributes();
    }

    public void setUpMethod(ITestContext testContext, Method method) {
        String testFile = "";
        int dataRow = -1;
        int[] dataColumns = new int[]{};
        MethodAttributes methodAttributes = null;
        try {
            TestNGMethods.setRunningTestMethod(TestNGMethods.getRunningTestClass().getMethod(method.getName(), new Class[0]));
            if (TestNGMethods.getRunningTestMethod().getAnnotation(MethodAttributes.class) != null) {
                methodAttributes = TestNGMethods.getRunningTestMethod().getAnnotation(MethodAttributes.class);
            }
        }
        catch (NoSuchMethodException e) {
            TestReporter.error("Warning: Something went wrong while define method attributes", false);
        }
        if (methodAttributes != null) {
            testFile = this.attributesConfig.getTestFile(methodAttributes);
            dataRow = this.attributesConfig.getDataRow(methodAttributes);
            dataColumns = this.attributesConfig.getDataColumns(methodAttributes);
        }
        String fileType = FilenameUtils.getExtension((String)AttributesHandler.getClassDataFile());
        if (!StringHandler.isStringBlank(testFile)) {
            AttributesHandler.setMethodTestFile(testFile);
        }
        if (dataRow > 0) {
            AttributesHandler.setMethodDataRow(AttributesHandler.getDataRow(fileType, dataRow));
        }
        if (dataColumns.length != 0) {
            // empty if block
        }
        TestReporter.prepareMethodReport(method);
        TestReporter.addMethodCategories(testContext, method);
    }

    public void tearDownMethod(ITestResult testResult) {
        AttributesHandler.resetMethodAttributes();
        TestReporter.generateMethodReport();
        TestNGMethods.setRunningTestMethod(null);
        TestNGMethods.setRunningTestClass(null);
    }
}

