/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.ApiRequestHandler;
import core.annotations.AttributesHandler;
import core.files.reader.ReadPropFile;
import core.handlers.StringHandler;
import java.util.HashMap;

public class ApiRequestHelper {
    private static HashMap<String, String> requestData = new HashMap();

    public static void setRequestData() {
        String requestString = AttributesHandler.getMethodDataRow();
        if (!requestString.isEmpty()) {
            requestData = StringHandler.getHashMapFromString((String)"=", (String)requestString);
        }
    }

    public static void setRequestData(String fileName) {
        requestData.put("api_type", ReadPropFile.getProperty((String)fileName, (String)"api_type"));
        requestData.put("end_point", ReadPropFile.getProperty((String)fileName, (String)"end_point"));
        requestData.put("params", ReadPropFile.getProperty((String)fileName, (String)"params"));
        requestData.put("headers", ReadPropFile.getProperty((String)fileName, (String)"headers"));
        requestData.put("body", ReadPropFile.getProperty((String)fileName, (String)"body"));
        requestData.put("pre_request", ReadPropFile.getProperty((String)fileName, (String)"pre_request"));
        requestData.put("tests", ReadPropFile.getProperty((String)fileName, (String)"tests"));
        requestData.put("authorization", ReadPropFile.getProperty((String)fileName, (String)"authorization"));
    }

    public static HashMap<String, String> getRequestData() {
        return requestData;
    }

    public static Object getRequestData(String key) {
        if (requestData.containsKey(key)) {
            return requestData.get(key);
        }
        return "";
    }

    public static String getApiType() {
        return ApiRequestHelper.getRequestData("api_type").toString();
    }

    public static String getApiEndPoint() {
        return ApiRequestHelper.getRequestData("end_point").toString();
    }

    public static String getFullApiURL(boolean secureURL) {
        String http = "";
        String baseURL = ApiRequestHandler.getBaseUrl();
        String endPoint = ApiRequestHelper.getApiEndPoint();
        if (!(baseURL.startsWith("http") || baseURL.startsWith("https") || endPoint.startsWith("http") || endPoint.startsWith("https"))) {
            http = secureURL ? "https://" : "http://";
        }
        return http + baseURL + endPoint;
    }

    public static HashMap<String, String> getParamsRequest() {
        String params = ApiRequestHelper.getRequestData("params").toString();
        if (!params.isEmpty()) {
            return StringHandler.getHashMapFromString((String)":", (String)params);
        }
        return new HashMap<String, String>();
    }

    public static HashMap<String, String> getHeadersRequest() {
        String headers = ApiRequestHelper.getRequestData("headers").toString();
        if (!headers.isEmpty()) {
            return StringHandler.getHashMapFromString((String)":", (String)headers);
        }
        return new HashMap<String, String>();
    }

    public static String getBodyRequest() {
        return ApiRequestHelper.getRequestData("body").toString();
    }
}

