/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.ApiRequestHelper;
import api.ApiResponseHandler;
import core.TestNGMethods;
import core.annotations.AttributesHandler;
import core.reports.TestReporter;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.HashMap;

public class ApiRequestHandler {
    private static String baseUrl = "";
    private static HashMap<String, HashMap<String, String>> requests = new HashMap();
    public static final String baseUrlParam = "baseUrl";
    public static final String apiTypeParam = "api_type";
    public static final String endPointParam = "end_point";
    public static final String paramsParam = "params";
    public static final String headersParam = "headers";
    public static final String bodyParam = "body";
    public static final String testsParam = "tests";
    public static final String preRequestParam = "pre_request";
    public static final String authorizationParam = "authorization";

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static void setBaseUrl(String baseUrl) {
        ApiRequestHandler.baseUrl = baseUrl;
    }

    public static HashMap<String, HashMap<String, String>> getRequests() {
        return requests;
    }

    public static void setRequests(String key, HashMap<String, String> request) {
        requests.put(key, request);
    }

    public static void runApiTestCaseRequest() {
        ApiRequestHandler.runApiTestCaseRequest(false);
    }

    public static void runApiTestCaseRequest(boolean secureConnection) {
        ApiRequestHelper.setRequestData();
        ApiRequestHandler.executeApiRequest(secureConnection);
    }

    public static void runApiTestCaseRequest(String fileName) {
        ApiRequestHandler.runApiTestCaseRequest(fileName, false);
    }

    public static void runApiTestCaseRequest(String fileName, boolean secureConnection) {
        ApiRequestHelper.setRequestData(fileName);
        ApiRequestHandler.setRequests(TestNGMethods.getRunningTestMethod().getName(), ApiRequestHelper.getRequestData());
        ApiRequestHandler.executeApiRequest(secureConnection);
    }

    private static void executeApiRequest(boolean secureConnection) {
        switch (ApiRequestHelper.getApiType().toLowerCase()) {
            case "get": {
                ApiResponseHandler.setResponse(ApiRequestHandler.executeGetApiRequest(secureConnection));
                break;
            }
            case "post": {
                ApiResponseHandler.setResponse(ApiRequestHandler.executePostApiRequest(secureConnection));
                break;
            }
            case "put": {
                ApiResponseHandler.setResponse(ApiRequestHandler.executePutApiRequest(secureConnection));
                break;
            }
            case "delete": {
                ApiResponseHandler.setResponse(ApiRequestHandler.executeDeleteApiRequest(secureConnection));
                break;
            }
            default: {
                TestReporter.error((String)("UnSupported API Type, Please check details.</br>API Type: " + ApiRequestHelper.getApiType() + ".</br>API File Path: " + AttributesHandler.getClassDataFile() + ".</br>"), (Boolean)true);
            }
        }
    }

    private static Response executeGetApiRequest(boolean secureConnection) {
        return (Response)((Response)RestAssured.given().params(ApiRequestHelper.getParamsRequest()).headers(ApiRequestHelper.getHeadersRequest()).when().get(ApiRequestHelper.getFullApiURL(secureConnection), new Object[0])).thenReturn();
    }

    private static Response executePostApiRequest(boolean secureConnection) {
        return (Response)((Response)RestAssured.given().params(ApiRequestHelper.getParamsRequest()).headers(ApiRequestHelper.getHeadersRequest()).body(ApiRequestHelper.getBodyRequest()).when().post(ApiRequestHelper.getFullApiURL(secureConnection), new Object[0])).thenReturn();
    }

    private static Response executePutApiRequest(boolean secureConnection) {
        return (Response)((Response)RestAssured.given().params(ApiRequestHelper.getParamsRequest()).headers(ApiRequestHelper.getHeadersRequest()).body(ApiRequestHelper.getBodyRequest()).when().put(ApiRequestHelper.getFullApiURL(secureConnection), new Object[0])).thenReturn();
    }

    private static Response executeDeleteApiRequest(boolean secureConnection) {
        return (Response)((Response)RestAssured.given().params(ApiRequestHelper.getParamsRequest()).headers(ApiRequestHelper.getHeadersRequest()).body(ApiRequestHelper.getBodyRequest()).when().delete(ApiRequestHelper.getFullApiURL(secureConnection), new Object[0])).thenReturn();
    }
}

