/*
 * Decompiled with CFR 0.152.
 */
package api;

import core.files.validator.FileStatusValidator;
import core.files.writer.WriteTXTFile;
import core.handlers.StringHandler;
import core.internal.EnvironmentInterface;
import java.lang.reflect.Method;

public class ApiHelper {
    private static void createMethodResourcesFile(String fileType, String folderPath, String methodName) {
        methodName = StringHandler.convertUpperCaseToUnderScore((String)methodName);
        String filePath = EnvironmentInterface.RESOURCES_TEST_PATH + folderPath;
        if (fileType.equalsIgnoreCase("yaml") || fileType.equalsIgnoreCase("yml")) {
            ApiHelper.writeApiYmlFileContent(filePath + methodName + ".yml");
        } else {
            filePath = filePath.substring(0, filePath.lastIndexOf("/")) + ".csv";
            ApiHelper.writeApiCsvFileContent(filePath.substring(filePath.lastIndexOf(filePath)), methodName);
        }
    }

    public static void createClassMethodsResourcesFiles(String fileType, Class clazz) {
        Method[] methods;
        String className = StringHandler.convertUpperCaseToUnderScore((String)clazz.getSimpleName()) + "/";
        String classPath = ApiHelper.getClassPath(clazz.getName().replace(clazz.getSimpleName(), "")) + className;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            ApiHelper.createMethodResourcesFile(fileType, classPath, methodName);
        }
    }

    private static String getClassPath(String classPath) {
        return classPath.replaceAll("\\.", "/");
    }

    private static void writeApiYmlFileContent(String filePath) {
        String valueString = ": \n";
        String valuesString = ": {}\n";
        String content = "api_type" + valueString + "end_point" + valueString + "params" + valuesString + "headers" + valuesString + "body" + valueString + "pre_request" + valueString + "tests" + valuesString + "authorization" + valueString;
        if (!FileStatusValidator.isFileExist((String)filePath).booleanValue()) {
            WriteTXTFile.writeTxtFile((String)filePath, (String)content);
        }
    }

    private static void writeApiCsvFileContent(String filePath, String scenarioName) {
        String valueString = ",";
        String valuesString = "{},";
        String headerContent = "scenario_name,api_type" + valueString + "end_point" + valueString + "params" + valueString + "headers" + valueString + "body" + valueString + "pre_request" + valueString + "tests" + valueString + "authorization";
        if (!FileStatusValidator.isFileExist((String)filePath).booleanValue()) {
            WriteTXTFile.writeTxtFile((String)filePath, (String)headerContent);
        }
        String rowContent = scenarioName + valueString + valueString + valueString + valuesString + valuesString + valueString + valueString + valuesString;
        WriteTXTFile.writeTxtFile((String)filePath, (String)rowContent);
    }
}

