/*
 * Decompiled with CFR 0.152.
 */
package com.ismaeldivita.chipnavigation.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.util.Xml;
import androidx.annotation.MenuRes;
import androidx.core.content.ContextCompat;
import com.ismaeldivita.chipnavigation.R;
import com.ismaeldivita.chipnavigation.model.Menu;
import com.ismaeldivita.chipnavigation.model.MenuItem;
import com.ismaeldivita.chipnavigation.util.ContextKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/ismaeldivita/chipnavigation/model/MenuParser;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "parse", "Lcom/ismaeldivita/chipnavigation/model/Menu;", "menuRes", "", "parseMenu", "parser", "Landroid/content/res/XmlResourceParser;", "attrs", "Landroid/util/AttributeSet;", "parseMenuItem", "Lcom/ismaeldivita/chipnavigation/model/MenuItem;", "readBackgroundColor", "sAttr", "Landroid/content/res/TypedArray;", "readBadgeColor", "readDisabledColor", "readIconActiveColor", "readIconTintMode", "Landroid/graphics/PorterDuff$Mode;", "readTextActiveColor", "readUnselectedColor", "skipMenuTagStart", "", "Companion", "chip-navigation-bar_release"})
public final class MenuParser {
    private final Context context;
    @NotNull
    public static final String XML_MENU_TAG = "menu";
    @NotNull
    public static final String XML_MENU_ITEM_TAG = "item";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Menu parse(@MenuRes int menuRes) {
        XmlResourceParser parser = this.context.getResources().getLayout(menuRes);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)((XmlPullParser)parser));
        XmlResourceParser xmlResourceParser = parser;
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlResourceParser, (String)"parser");
        this.skipMenuTagStart(xmlResourceParser);
        AttributeSet attributeSet = attrs;
        Intrinsics.checkExpressionValueIsNotNull((Object)attributeSet, (String)"attrs");
        return this.parseMenu(parser, attributeSet);
    }

    private final void skipMenuTagStart(XmlResourceParser parser) {
        int currentEvent = parser.getEventType();
        do {
            if (currentEvent != 2) continue;
            String name = parser.getName();
            boolean bl = Intrinsics.areEqual((Object)name, (Object)XML_MENU_TAG);
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) break;
            boolean bl4 = false;
            String string = "Expecting menu, got " + name;
            throw (Throwable)new IllegalArgumentException(string.toString());
        } while ((currentEvent = parser.next()) != 1);
    }

    private final Menu parseMenu(XmlResourceParser parser, AttributeSet attrs) {
        boolean bl = false;
        List items = new ArrayList();
        int eventType = parser.getEventType();
        boolean isEndOfMenu = false;
        int badgeColor = 0;
        int disabledColor = 0;
        int unselectedColor = 0;
        while (!isEndOfMenu) {
            String name = parser.getName();
            if (eventType == 2 && Intrinsics.areEqual((Object)name, (Object)XML_MENU_TAG)) {
                TypedArray sAttr;
                TypedArray typedArray = sAttr = this.context.obtainStyledAttributes(attrs, R.styleable.ChipMenu);
                Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"sAttr");
                badgeColor = this.readBadgeColor(typedArray);
                disabledColor = this.readDisabledColor(sAttr);
                unselectedColor = this.readUnselectedColor(sAttr);
                sAttr.recycle();
            } else if (eventType == 2 && Intrinsics.areEqual((Object)name, (Object)XML_MENU_ITEM_TAG)) {
                MenuItem item = this.parseMenuItem(attrs);
                items.add(MenuItem.copy$default(item, 0, null, 0, false, null, 0, 0, 0, badgeColor, disabledColor, unselectedColor, 255, null));
            } else if (eventType == 3 && Intrinsics.areEqual((Object)name, (Object)XML_MENU_TAG)) {
                isEndOfMenu = true;
            } else if (eventType == 1) {
                throw (Throwable)new RuntimeException("Unexpected end of document");
            }
            eventType = parser.next();
        }
        return new Menu(items, badgeColor, disabledColor, unselectedColor);
    }

    private final MenuItem parseMenuItem(AttributeSet attrs) {
        TypedArray sAttr = this.context.obtainStyledAttributes(attrs, R.styleable.ChipMenuItem);
        int n = sAttr.getResourceId(R.styleable.ChipMenuItem_android_id, 0);
        CharSequence charSequence = sAttr.getText(R.styleable.ChipMenuItem_android_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"sAttr.getText(R.styleabl\u2026ipMenuItem_android_title)");
        int n2 = sAttr.getResourceId(R.styleable.ChipMenuItem_android_icon, 0);
        boolean bl = sAttr.getBoolean(R.styleable.ChipMenuItem_android_enabled, true);
        TypedArray typedArray = sAttr;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"sAttr");
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.readBackgroundColor(sAttr);
        int n7 = this.readTextActiveColor(sAttr);
        PorterDuff.Mode mode = this.readIconTintMode(sAttr);
        int n8 = this.readIconActiveColor(typedArray);
        MenuItem item = new MenuItem(n, charSequence, n2, bl, mode, n8, n7, n6, n5, n4, n3, 1792, null);
        sAttr.recycle();
        return item;
    }

    private final PorterDuff.Mode readIconTintMode(TypedArray sAttr) {
        PorterDuff.Mode mode;
        switch (sAttr.getInt(R.styleable.ChipMenuItem_cnb_iconTintMode, -1)) {
            case 3: {
                mode = PorterDuff.Mode.SRC_OVER;
                break;
            }
            case 5: {
                mode = PorterDuff.Mode.SRC_IN;
                break;
            }
            case 9: {
                mode = PorterDuff.Mode.SRC_ATOP;
                break;
            }
            case 14: {
                mode = PorterDuff.Mode.MULTIPLY;
                break;
            }
            case 15: {
                mode = PorterDuff.Mode.SCREEN;
                break;
            }
            case 16: {
                mode = PorterDuff.Mode.ADD;
                break;
            }
            default: {
                mode = null;
            }
        }
        return mode;
    }

    private final int readIconActiveColor(TypedArray sAttr) {
        return sAttr.getColor(R.styleable.ChipMenuItem_cnb_iconColor, ContextKt.getValueFromAttr(this.context, R.attr.colorAccent));
    }

    private final int readBadgeColor(TypedArray sAttr) {
        return sAttr.getColor(R.styleable.ChipMenu_cnb_badgeColor, ContextCompat.getColor((Context)this.context, (int)R.color.cnb_default_badge_tint_color));
    }

    private final int readDisabledColor(TypedArray sAttr) {
        return sAttr.getColor(R.styleable.ChipMenu_cnb_disabledColor, ContextKt.getValueFromAttr(this.context, R.attr.colorButtonNormal));
    }

    private final int readUnselectedColor(TypedArray sAttr) {
        return sAttr.getColor(R.styleable.ChipMenu_cnb_unselectedColor, ContextCompat.getColor((Context)this.context, (int)R.color.cnb_default_unselected_color));
    }

    private final int readTextActiveColor(TypedArray sAttr) {
        return sAttr.getColor(R.styleable.ChipMenuItem_cnb_textColor, this.readIconActiveColor(sAttr));
    }

    private final int readBackgroundColor(TypedArray sAttr) {
        int iconTintColor = this.readIconActiveColor(sAttr);
        int defaultColor = Color.argb((int)((int)((double)Color.alpha((int)iconTintColor) * 0.15)), (int)Color.red((int)iconTintColor), (int)Color.green((int)iconTintColor), (int)Color.blue((int)iconTintColor));
        return sAttr.getColor(R.styleable.ChipMenuItem_cnb_backgroundColor, defaultColor);
    }

    public MenuParser(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ismaeldivita/chipnavigation/model/MenuParser$Companion;", "", "()V", "XML_MENU_ITEM_TAG", "", "XML_MENU_TAG", "chip-navigation-bar_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

