/*
 * Decompiled with CFR 0.152.
 */
package com.ismaeldivita.chipnavigation.behavior;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.ismaeldivita.chipnavigation.ChipNavigationBar;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000267B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0016H\u0016J@\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u0016H\u0016J8\u00100\u001a\u00020\u00182\u0006\u0010)\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u00101\u001a\u00020+2\u0006\u0010*\u001a\u00020+2\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0016H\u0016J\u000e\u00104\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002J\u000e\u00105\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lcom/ismaeldivita/chipnavigation/behavior/HideOnScrollBehavior;", "Landroidx/coordinatorlayout/widget/CoordinatorLayout$Behavior;", "Lcom/ismaeldivita/chipnavigation/ChipNavigationBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currentAnimator", "Landroid/view/ViewPropertyAnimator;", "currentState", "Lcom/ismaeldivita/chipnavigation/behavior/HideOnScrollBehavior$State;", "enterAnimationDuration", "", "getEnterAnimationDuration", "()J", "setEnterAnimationDuration", "(J)V", "exitAnimationDuration", "getExitAnimationDuration", "setExitAnimationDuration", "height", "", "scrollEnabled", "", "getScrollEnabled", "()Z", "setScrollEnabled", "(Z)V", "animateChildTo", "", "child", "targetY", "duration", "interpolator", "Landroid/animation/TimeInterpolator;", "onLayoutChild", "parent", "Landroidx/coordinatorlayout/widget/CoordinatorLayout;", "layoutDirection", "onNestedScroll", "coordinatorLayout", "target", "Landroid/view/View;", "dxConsumed", "dyConsumed", "dxUnconsumed", "dyUnconsumed", "onStartNestedScroll", "directTargetChild", "axes", "type", "slideDown", "slideUp", "Companion", "State", "chip-navigation-bar_release"})
public final class HideOnScrollBehavior
extends CoordinatorLayout.Behavior<ChipNavigationBar> {
    private boolean scrollEnabled;
    private long enterAnimationDuration;
    private long exitAnimationDuration;
    private int height;
    private State currentState;
    private ViewPropertyAnimator currentAnimator;
    public static final long DEFAULT_ENTER_DURATION = 225L;
    public static final long DEFAULT_EXIT_DURATION = 175L;
    public static final Companion Companion = new Companion(null);

    public final boolean getScrollEnabled() {
        return this.scrollEnabled;
    }

    public final void setScrollEnabled(boolean bl) {
        this.scrollEnabled = bl;
    }

    public final long getEnterAnimationDuration() {
        return this.enterAnimationDuration;
    }

    public final void setEnterAnimationDuration(long l) {
        this.enterAnimationDuration = l;
    }

    public final long getExitAnimationDuration() {
        return this.exitAnimationDuration;
    }

    public final void setExitAnimationDuration(long l) {
        this.exitAnimationDuration = l;
    }

    public boolean onLayoutChild(@NotNull CoordinatorLayout parent, @NotNull ChipNavigationBar child, int layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)child), (String)"child");
        ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.MarginLayoutParams paramsCompat = (ViewGroup.MarginLayoutParams)layoutParams;
        this.height = child.getMeasuredHeight() + paramsCompat.bottomMargin + child.getPaddingBottom();
        return super.onLayoutChild(parent, (View)child, layoutDirection);
    }

    public boolean onStartNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull ChipNavigationBar child, @NotNull View directTargetChild, @NotNull View target, int axes, int type) {
        Intrinsics.checkParameterIsNotNull((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkParameterIsNotNull((Object)((Object)child), (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)directTargetChild, (String)"directTargetChild");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return this.scrollEnabled && axes == 2;
    }

    public void onNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull ChipNavigationBar child, @NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        Intrinsics.checkParameterIsNotNull((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkParameterIsNotNull((Object)((Object)child), (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (this.currentState != State.STATE_SCROLLED_DOWN && dyConsumed > 0) {
            this.slideDown(child);
        } else if (this.currentState != State.STATE_SCROLLED_UP && dyConsumed < 0) {
            this.slideUp(child);
        }
    }

    public final void slideUp(@NotNull ChipNavigationBar child) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)child), (String)"child");
        ViewPropertyAnimator viewPropertyAnimator = this.currentAnimator;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
        child.clearAnimation();
        this.currentState = State.STATE_SCROLLED_UP;
        this.animateChildTo(child, 0, this.enterAnimationDuration, (TimeInterpolator)new LinearOutSlowInInterpolator());
    }

    public final void slideDown(@NotNull ChipNavigationBar child) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)child), (String)"child");
        ViewPropertyAnimator viewPropertyAnimator = this.currentAnimator;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
        child.clearAnimation();
        this.currentState = State.STATE_SCROLLED_DOWN;
        this.animateChildTo(child, this.height, this.exitAnimationDuration, (TimeInterpolator)new FastOutLinearInInterpolator());
    }

    private final void animateChildTo(ChipNavigationBar child, int targetY, long duration, TimeInterpolator interpolator) {
        this.currentAnimator = child.animate().translationY((float)targetY).setInterpolator(interpolator).setDuration(duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ HideOnScrollBehavior this$0;

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                HideOnScrollBehavior.access$setCurrentAnimator$p(this.this$0, null);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public HideOnScrollBehavior(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.enterAnimationDuration = 225L;
        this.exitAnimationDuration = 175L;
        this.currentState = State.STATE_SCROLLED_UP;
    }

    public static final /* synthetic */ ViewPropertyAnimator access$getCurrentAnimator$p(HideOnScrollBehavior $this) {
        return $this.currentAnimator;
    }

    public static final /* synthetic */ void access$setCurrentAnimator$p(HideOnScrollBehavior $this, ViewPropertyAnimator viewPropertyAnimator) {
        $this.currentAnimator = viewPropertyAnimator;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/ismaeldivita/chipnavigation/behavior/HideOnScrollBehavior$State;", "", "(Ljava/lang/String;I)V", "STATE_SCROLLED_DOWN", "STATE_SCROLLED_UP", "chip-navigation-bar_release"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State STATE_SCROLLED_DOWN;
        public static final /* enum */ State STATE_SCROLLED_UP;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = STATE_SCROLLED_DOWN = new State();
            stateArray[1] = STATE_SCROLLED_UP = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ismaeldivita/chipnavigation/behavior/HideOnScrollBehavior$Companion;", "", "()V", "DEFAULT_ENTER_DURATION", "", "DEFAULT_EXIT_DURATION", "chip-navigation-bar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

