/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.analytics.omid;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.iab.omid.library.ironsrc.Omid;
import com.iab.omid.library.ironsrc.adsession.AdEvents;
import com.iab.omid.library.ironsrc.adsession.AdSession;
import com.iab.omid.library.ironsrc.adsession.AdSessionConfiguration;
import com.iab.omid.library.ironsrc.adsession.AdSessionContext;
import com.iab.omid.library.ironsrc.adsession.CreativeType;
import com.iab.omid.library.ironsrc.adsession.ImpressionType;
import com.iab.omid.library.ironsrc.adsession.Owner;
import com.iab.omid.library.ironsrc.adsession.Partner;
import com.ironsource.sdk.WPAD.AdViewsManager;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.utils.SDKUtils;
import org.json.JSONObject;

public class OMIDManager {
    public static final String OMID_PARTNER_NAME = "Ironsrc";
    public static final String OMID_PARTNER_VERSION = "7";
    public static final String OMID_VERSION_PROPERTY_NAME = "omidVersion";
    public static final String OMID_PARTNER_NAME_PROPERTY_NAME = "omidPartnerName";
    public static final String OMID_PARTNER_VERSION_PROPERTY_NAME = "omidPartnerVersion";
    private static final String INVALID_OMID_IMPRESSION_OWNER_MESSAGE = "%s | Invalid OMID impressionOwner";
    private static final String INVALID_OMID_VIDEO_EVENTS_TYPE_MESSAGE = "%s | Invalid OMID videoEventsOwner";
    private static final String MISSING_OMID_IMPRESSION_OWNER_MESSAGE = "Missing OMID impressionOwner";
    private static final String MISSING_OMID_VIDEO_EVENTS_OWNER_MESSAGE = "Missing OMID videoEventsOwner";
    private static final String OMID_HAS_NOT_BEEN_ACTIVATED_MESSAGE = "OMID has not been activated";
    private static final String OMID_SESSION_HAS_ALREADY_STARTED_MESSAGE = "OMID Session has already started";
    private static final String OMID_SESSION_HAS_NOT_STARTED_MESSAGE = "OMID Session has not started";
    private static final String MISSING_OMID_VIDEO_EVENTS_CREATIVE_TYPE_MESSAGE = "Missing OMID creativeType";
    private static final String MISSING_OMID_VIDEO_EVENTS_IMPRESSION_TYPE_MESSAGE = "Missing OMID impressionType";
    private static final String MISSING_OMID_WEBVIEW_MESSAGE = "Missing OMID webview id";
    private static final String OMID_WEBVIEW_NOT_FOUND_MESSAGE = "webview not found";
    private static final Partner mPartner = Partner.createPartner("Ironsrc", "7");
    private static AdSession mAdSession;
    private static boolean mIsActivated;

    public static void activate(Context context) throws IllegalArgumentException {
        if (!mIsActivated) {
            Omid.activate(context);
            mIsActivated = true;
        }
    }

    public static SSAObj getOMIDData() {
        SSAObj omidData = new SSAObj();
        omidData.put(SDKUtils.encodeString(OMID_VERSION_PROPERTY_NAME), SDKUtils.encodeString(Omid.getVersion()));
        omidData.put(SDKUtils.encodeString(OMID_PARTNER_NAME_PROPERTY_NAME), SDKUtils.encodeString(OMID_PARTNER_NAME));
        omidData.put(SDKUtils.encodeString(OMID_PARTNER_VERSION_PROPERTY_NAME), SDKUtils.encodeString(OMID_PARTNER_VERSION));
        return omidData;
    }

    public static void startSession(JSONObject options, WebView webView) throws IllegalStateException, IllegalArgumentException {
        OMIDOptions omidOptions = OMIDOptions.createFromJSON(options);
        OMIDManager.startSession(omidOptions, webView);
    }

    public static void startSession(OMIDOptions omidOptions, WebView webView) throws IllegalStateException, IllegalArgumentException {
        if (!mIsActivated) {
            throw new IllegalStateException(OMID_HAS_NOT_BEEN_ACTIVATED_MESSAGE);
        }
        if (mAdSession != null) {
            throw new IllegalStateException(OMID_SESSION_HAS_ALREADY_STARTED_MESSAGE);
        }
        if (!TextUtils.isEmpty((CharSequence)omidOptions.adViewId) && (webView = AdViewsManager.getInstance().getAdViewById(omidOptions.adViewId)) == null) {
            throw new IllegalStateException(OMID_WEBVIEW_NOT_FOUND_MESSAGE);
        }
        mAdSession = OMIDManager.createSession(omidOptions, webView);
        mAdSession.start();
    }

    private static AdSession createSession(OMIDOptions omidOptions, WebView webView) throws IllegalArgumentException {
        AdSessionConfiguration mySessionConfig = AdSessionConfiguration.createAdSessionConfiguration(omidOptions.creativeType, omidOptions.impressionType, omidOptions.impressionOwner, omidOptions.videoEventsOwner, omidOptions.isolateVerificationScripts);
        AdSessionContext adSessionContext = AdSessionContext.createHtmlAdSessionContext(mPartner, webView, null, omidOptions.customReferenceData);
        AdSession adSession = AdSession.createAdSession(mySessionConfig, adSessionContext);
        adSession.registerAdView((View)webView);
        return adSession;
    }

    public static void finishSession() throws IllegalStateException {
        OMIDManager.assertAdSession();
        mAdSession.finish();
        mAdSession = null;
    }

    public static void impressionOccurred(JSONObject options) throws IllegalArgumentException, IllegalStateException {
        OMIDManager.assertAdSession();
        AdEvents adEvents = AdEvents.createAdEvents(mAdSession);
        try {
            boolean isSignalLoaded = (Boolean)options.get("signalLoaded");
            if (isSignalLoaded) {
                adEvents.loaded();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        adEvents.impressionOccurred();
    }

    private static void assertAdSession() throws IllegalStateException {
        if (!mIsActivated) {
            throw new IllegalStateException(OMID_HAS_NOT_BEEN_ACTIVATED_MESSAGE);
        }
        if (mAdSession == null) {
            throw new IllegalStateException(OMID_SESSION_HAS_NOT_STARTED_MESSAGE);
        }
    }

    static {
        mIsActivated = false;
    }

    static class OMIDOptions {
        private static final String ISOLATE_VERIFICATION_SCRIPTS = "isolateVerificationScripts";
        private static final String IMPRESSION_OWNER = "impressionOwner";
        private static final String VIDEO_EVENTS_OWNER = "videoEventsOwner";
        private static final String CUSTOM_REFERENCE_DATA = "customReferenceData";
        private static final String CREATIVE_TYPE = "creativeType";
        private static final String IMPRESSION_TYPE = "impressionType";
        private static final String MEDIA_EVENTS_OWNER = "mediaEventsOwner";
        private static final String AD_VIEW_ID = "adViewId";
        private static final String SIGNAL_LOADED = "signalLoaded";
        public boolean isolateVerificationScripts;
        public Owner impressionOwner;
        public Owner videoEventsOwner;
        public String customReferenceData;
        public ImpressionType impressionType;
        public CreativeType creativeType;
        public String adViewId;
        public boolean signalLoaded;
        public Owner mediaEventsOwner;

        private static ImpressionType getImpressionType(JSONObject options) throws IllegalArgumentException {
            ImpressionType[] impressionTypes;
            String impressionTypeStr = options.optString(IMPRESSION_TYPE, "");
            if (TextUtils.isEmpty((CharSequence)impressionTypeStr)) {
                throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_VIDEO_EVENTS_CREATIVE_TYPE_MESSAGE, impressionTypeStr));
            }
            for (ImpressionType impressionType : impressionTypes = ImpressionType.values()) {
                if (!impressionTypeStr.equalsIgnoreCase(impressionType.toString())) continue;
                return impressionType;
            }
            throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_VIDEO_EVENTS_CREATIVE_TYPE_MESSAGE, impressionTypeStr));
        }

        private static boolean getSignalLoaded(JSONObject options) throws IllegalArgumentException {
            return options.optBoolean(SIGNAL_LOADED, false);
        }

        private static String getViewId(JSONObject options) throws IllegalArgumentException {
            String adViewIdStr = options.optString(AD_VIEW_ID, "");
            if (TextUtils.isEmpty((CharSequence)adViewIdStr)) {
                throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_WEBVIEW_MESSAGE, adViewIdStr));
            }
            return adViewIdStr;
        }

        private static CreativeType getCreativeType(JSONObject options) throws IllegalArgumentException {
            CreativeType[] creativeTypes;
            String creativeTypeStr = options.optString(CREATIVE_TYPE, "");
            if (TextUtils.isEmpty((CharSequence)creativeTypeStr)) {
                throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_VIDEO_EVENTS_CREATIVE_TYPE_MESSAGE, creativeTypeStr));
            }
            for (CreativeType creativeType : creativeTypes = CreativeType.values()) {
                if (!creativeTypeStr.equalsIgnoreCase(creativeType.toString())) continue;
                return creativeType;
            }
            throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_VIDEO_EVENTS_CREATIVE_TYPE_MESSAGE, creativeTypeStr));
        }

        private static Owner getVideoEventsOwner(JSONObject options) throws IllegalArgumentException {
            String mediaEventsOwnerStr = options.optString(VIDEO_EVENTS_OWNER, "");
            Owner mediaEventsOwner = Owner.NONE;
            try {
                mediaEventsOwner = Owner.valueOf(mediaEventsOwnerStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return mediaEventsOwner;
        }

        public static OMIDOptions createFromJSON(JSONObject options) throws IllegalArgumentException {
            OMIDOptions omidOptions = new OMIDOptions();
            omidOptions.isolateVerificationScripts = options.optBoolean(ISOLATE_VERIFICATION_SCRIPTS, false);
            String impressionOwnerStr = options.optString(IMPRESSION_OWNER, "");
            if (TextUtils.isEmpty((CharSequence)impressionOwnerStr)) {
                throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_IMPRESSION_OWNER_MESSAGE, impressionOwnerStr));
            }
            try {
                omidOptions.impressionOwner = Owner.valueOf(impressionOwnerStr.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException(String.format(OMIDManager.INVALID_OMID_IMPRESSION_OWNER_MESSAGE, impressionOwnerStr));
            }
            String videoEventsOwnerStr = options.optString(VIDEO_EVENTS_OWNER, "");
            if (TextUtils.isEmpty((CharSequence)impressionOwnerStr)) {
                throw new IllegalArgumentException(String.format(OMIDManager.MISSING_OMID_VIDEO_EVENTS_OWNER_MESSAGE, videoEventsOwnerStr));
            }
            try {
                omidOptions.videoEventsOwner = Owner.valueOf(videoEventsOwnerStr.toUpperCase());
            }
            catch (IllegalArgumentException e3) {
                throw new IllegalArgumentException(String.format(OMIDManager.INVALID_OMID_VIDEO_EVENTS_TYPE_MESSAGE, videoEventsOwnerStr));
            }
            omidOptions.customReferenceData = options.optString(CUSTOM_REFERENCE_DATA, "");
            omidOptions.creativeType = OMIDOptions.getCreativeType(options);
            omidOptions.impressionType = OMIDOptions.getImpressionType(options);
            omidOptions.adViewId = OMIDOptions.getViewId(options);
            boolean signalLoadedStr = OMIDOptions.getSignalLoaded(options);
            omidOptions.mediaEventsOwner = OMIDOptions.getVideoEventsOwner(options);
            return omidOptions;
        }
    }
}

