/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.ISNAdView;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdViewDelegate;
import com.ironsource.sdk.ISNAdView.ISNAdViewLogic;
import com.ironsource.sdk.ISNAdView.ISNAdViewWebClient;
import com.ironsource.sdk.ISNAdView.ISNAdViewWebViewJSInterface;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.WPAD.ISNAdViewProtocol;
import com.ironsource.sdk.agent.IronSourceAdsPublisherAgent;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ISNAdView
extends FrameLayout {
    private WebView mWebView;
    private Activity mActivity;
    private ISAdSize mAdViewSize;
    private String mContainerIdentifier;
    private ISNAdViewLogic mIsnAdViewLogic;
    private String TAG = ISNAdView.class.getSimpleName();

    public ISNAdView(Activity activity, String containerIdentifier, ISAdSize adSize) {
        super((Context)activity);
        this.mActivity = activity;
        this.mAdViewSize = adSize;
        this.mContainerIdentifier = containerIdentifier;
        this.mIsnAdViewLogic = new ISNAdViewLogic();
    }

    public void setControllerDelegate(ISNAdViewDelegate delegate) {
        this.mIsnAdViewLogic.setControllerDelegate(delegate);
    }

    public void loadAdForBidding(Map<String, String> loadParams) throws Exception {
        try {
            this.mIsnAdViewLogic.buildDataForLoadingAd(loadParams, this.mContainerIdentifier);
        }
        catch (Exception e2) {
            throw new Exception("ISNAdView | loadAd | Failed to build load parameters");
        }
        try {
            IronSourceAdsPublisherAgent.getInstance((Context)this.mActivity).loadBannerForBidding(loadParams, this.mActivity);
        }
        catch (Exception e3) {
            throw new Exception("ISNAdView | Failed to instantiate IronSourceAdsPublisherAgent");
        }
    }

    public void loadAd(JSONObject loadParams) throws Exception {
        JSONObject extendedLoadParams;
        try {
            extendedLoadParams = this.mIsnAdViewLogic.buildDataForLoadingAd(loadParams, this.mContainerIdentifier);
        }
        catch (Exception e2) {
            throw new Exception("ISNAdView | loadAd | Failed to build load parameters");
        }
        try {
            IronSourceAdsPublisherAgent.getInstance((Context)this.mActivity).loadBanner(extendedLoadParams);
        }
        catch (Exception e3) {
            throw new Exception("ISNAdView | Failed to instantiate IronSourceAdsPublisherAgent");
        }
    }

    public void load(JSONObject loadParams) throws Exception {
        JSONObject extendedLoadParams;
        try {
            extendedLoadParams = this.mIsnAdViewLogic.buildDataForLoadingAd(loadParams, this.mContainerIdentifier);
        }
        catch (Exception e2) {
            throw new Exception("ISNAdView | loadAd | Failed to build load parameters");
        }
        try {
            IronSourceNetwork.loadBanner(extendedLoadParams);
        }
        catch (Exception e3) {
            throw new Exception("ISNAdView | Failed to instantiate IronSourceAdsPublisherAgent");
        }
    }

    public void performCleanup() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ISNAdView.this.mIsnAdViewLogic.reportAdContainerWasRemoved();
                    if (ISNAdView.this.mWebView != null) {
                        ISNAdView.this.mWebView.destroy();
                    }
                    ISNAdView.this.mActivity = null;
                    ISNAdView.this.mAdViewSize = null;
                    ISNAdView.this.mContainerIdentifier = null;
                    ISNAdView.this.mIsnAdViewLogic.destroy();
                    ISNAdView.this.mIsnAdViewLogic = null;
                }
                catch (Exception e2) {
                    Log.e((String)ISNAdView.this.TAG, (String)"performCleanup | could not destroy ISNAdView");
                    e2.printStackTrace();
                }
            }
        });
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (this.mIsnAdViewLogic != null) {
            this.mIsnAdViewLogic.updateViewVisibilityParameters("isVisible", visibility, this.isShown());
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (this.mIsnAdViewLogic != null) {
            this.mIsnAdViewLogic.updateViewVisibilityParameters("isWindowVisible", visibility, this.isShown());
        }
    }

    public void loadUrlIntoWebView(final String url, final String successMethod, final String failureMethod) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ISNAdView.this.mWebView == null) {
                        ISNAdView.this.createWebView(successMethod, failureMethod);
                    }
                    ISNAdView.this.addView((View)ISNAdView.this.mWebView);
                    ISNAdView.this.mWebView.loadUrl(url);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    ISNAdView.this.mIsnAdViewLogic.sendErrorMessageToController(failureMethod, e2.getMessage());
                    ISNEventsTracker.logEvent(SDK5Events.adunitCouldNotLoadToWebViewBanners, new ISNEventParams().addPair("callfailreason", e2.getMessage()).getData());
                }
            }
        });
    }

    private void createWebView(String successMethod, final String failureMethod) throws JSONException {
        this.mWebView = new WebView((Context)this.mActivity);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.addJavascriptInterface((Object)new ISNAdViewWebViewJSInterface(this), "containerMsgHandler");
        this.mWebView.setWebViewClient((WebViewClient)new ISNAdViewWebClient(new ISNAdViewProtocol.IErrorReportDelegate(){

            @Override
            public void reportOnError(String errMessage) {
                ISNAdView.this.mIsnAdViewLogic.sendErrorMessageToController(failureMethod, errMessage);
            }
        }));
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mIsnAdViewLogic.setAdViewWebView(this.mWebView);
        JSONObject response = new JSONObject();
        response.put("adViewId", (Object)this.mIsnAdViewLogic.getAdViewId());
        this.mIsnAdViewLogic.sendMessageToController(successMethod, response);
    }

    void receiveMessageFromWebView(String data) {
        this.mIsnAdViewLogic.handleMessageFromWebView(data);
    }

    public void receiveMessageFromController(String functionName, JSONObject functionParams, String successMethod, String failureMethod) {
        block4: {
            if (this.mIsnAdViewLogic == null) {
                ISNEventParams eventParams = new ISNEventParams();
                String errorMessage = this.createErrorMessage("ISNAdViewLogic is NULL and method name %s and function parameters %s", functionName, functionParams);
                eventParams.addPair("generalmessage", errorMessage);
                ISNEventsTracker.logEvent(SDK5Events.bannerAlreadyDestroyed, eventParams.getData());
                return;
            }
            try {
                if (functionName.equalsIgnoreCase("loadWithUrl")) {
                    String adUnitUrl = functionParams.getString("urlForWebView");
                    String adViewId = functionParams.getString("adViewId");
                    this.mIsnAdViewLogic.setAdViewId(adViewId);
                    this.loadUrlIntoWebView(adUnitUrl, successMethod, failureMethod);
                    return;
                }
                this.mIsnAdViewLogic.handleMessageFromController(functionName, functionParams, successMethod, failureMethod);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                if (this.mIsnAdViewLogic == null) break block4;
                String errorMessage = this.createErrorMessage("Could not handle message from controller: %s  with params: %s", functionName, functionParams);
                this.mIsnAdViewLogic.sendErrorMessageToController(failureMethod, errorMessage);
            }
        }
    }

    public ISAdSize getAdViewSize() {
        return this.mAdViewSize;
    }

    private String createErrorMessage(String errorMessageTemplate, String functionName, JSONObject functionParameters) {
        return String.format(errorMessageTemplate, functionName, functionParameters != null ? functionParameters.toString() : " null");
    }
}

