/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.content.Context;
import android.text.TextUtils;
import com.ironsource.environment.StringUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ApplicationConfigurations;
import com.ironsource.mediationsdk.model.ApplicationCrashReporterSettings;
import com.ironsource.mediationsdk.model.ApplicationEvents;
import com.ironsource.mediationsdk.model.ApplicationLogger;
import com.ironsource.mediationsdk.model.BannerConfigurations;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.Configurations;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.model.OfferwallConfigurations;
import com.ironsource.mediationsdk.model.OfferwallPlacement;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.PlacementAvailabilitySettings;
import com.ironsource.mediationsdk.model.PlacementCappingType;
import com.ironsource.mediationsdk.model.ProviderOrder;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.ProviderSettingsHolder;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.model.ServerSegmetData;
import com.ironsource.mediationsdk.utils.ApplicationGeneralSettings;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.TokenSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerResponseWrapper {
    public static final String APP_KEY_FIELD = "appKey";
    public static final String USER_ID_FIELD = "userId";
    public static final String RESPONSE_FIELD = "response";
    private final String ERROR_KEY = "error";
    private final int DEFAULT_LOG_LEVEL = 3;
    private final int DEFAULT_ADAPTERS_SMARTLOAD_AMOUNT = 2;
    private final int DEFAULT_ADAPTERS_SMARTLOAD_TIMEOUT = 60;
    private final int DEFAULT_BANNER_SMARTLOAD_TIMEOUT = 10000;
    private final int DEFAULT_MAX_EVENTS_PER_BATCH = 5000;
    private final int DEFAULT_MANUAL_LOAD_INTERVAL_FIELD = 300;
    private final int DEFAULT_IS_DELAY_LOAD_FAILURE_TIMEOUT = 3;
    private final int DEFAULT_BN_DELAY_LOAD_FAILURE_TIMEOUT = 3;
    private final int DEFAULT_TRIALS = 2;
    private final int DEFAULT_AUCTION_SAVED_HISTORY_LIMIT = 15;
    private final long DEFAULT_TIMEOUT = 10000L;
    private final int DEFAULT_ADVANCED_LOADING_AMOUNT = 0;
    private final boolean DEFAULT_ADVANCED_LOADING = false;
    private final int DEFAULT_TIME_TO_DELETE_WATERFALL_AFTER_AUCTION = 30000;
    private final int DEFAULT_EXPIRED_DURATION_IN_MINUTES_FIELD = -1;
    private final int DEFAULT_ANR_TIME = 5000;
    private final String PROVIDER_ORDER_FIELD = "providerOrder";
    private final String PROVIDER_SETTINGS_FIELD = "providerSettings";
    private final String CONFIGURATIONS_FIELD = "configurations";
    private final String GENERIC_PARAMS_FIELD = "genericParams";
    private final String AD_UNITS_FIELD = "adUnits";
    private final String PROVIDER_LOAD_NAME_FIELD = "providerLoadName";
    private final String APPLICATION_FIELD = "application";
    private final String RV_FIELD = "rewardedVideo";
    private final String IS_FIELD = "interstitial";
    private final String OW_FIELD = "offerwall";
    private final String BN_FIELD = "banner";
    private final String INTEGRATION_FIELD = "integration";
    private final String LOGGERS_FIELD = "loggers";
    private final String SEGMENT_FIELD = "segment";
    private final String EVENTS_FIELD = "events";
    private final String CRASHREPORTER_FIELD = "crashReporter";
    private final String TOKEN_FIELD = "token";
    private final String EXTERNAL_FIELD = "external";
    private final String MEDIATION_TYPES_FIELD = "mediationTypes";
    private final String SETTINGS_FIELD = "settings";
    private final String SMART_LOAD_FIELD = "maxNumOfAdaptersToLoadOnStart";
    private final String ADVANCED_LOADING_FIELD = "advancedLoading";
    private final String ADAPTER_TIMEOUT_IN_SECS_FIELD = "adapterTimeOutInSeconds";
    private final String ADAPTER_TIMEOUT_IN_MILLIS_FIELD = "atim";
    private final String DEFAULT_BANNER_LOAD_REFRESH_INTERVAL = "bannerInterval";
    private final String MANUAL_LOAD_INTERVAL_FIELD = "loadRVInterval";
    private final String EXPIRED_DURATION_IN_MINUTES_FIELD = "expiredDurationInMinutes";
    private final String SERVER_FIELD = "server";
    private final String PUBLISHER_FIELD = "publisher";
    private final String CONSOLE_FIELD = "console";
    private final String SEND_ULTRA_EVENTS_FIELD = "sendUltraEvents";
    private final String SEND_EVENTS_TOGGLE_FIELD = "sendEventsToggle";
    private final String SERVER_EVENTS_URL_FIELD = "serverEventsURL";
    private final String SERVER_EVENTS_TYPE = "serverEventsType";
    private final String BACKUP_THRESHOLD_FIELD = "backupThreshold";
    private final String MAX_NUM_OF_EVENTS_FIELD = "maxNumberOfEvents";
    private final String MAX_EVENTS_PER_BATCH = "maxEventsPerBatch";
    private final String OPT_OUT_EVENTS_FIELD = "optOut";
    private final String OPT_IN_EVENTS_FIELD = "optIn";
    private final String TRIGGER_EVENTS_FIELD = "triggerEvents";
    private final String NON_CONNECTIVITY_EVENTS_FIELD = "nonConnectivityEvents";
    private final String PLACEMENTS_FIELD = "placements";
    private final String PLACEMENT_ID_FIELD = "placementId";
    private final String PLACEMENT_NAME_FIELD = "placementName";
    private final String PLACEMENT_SETTINGS_DELIVERY_FIELD = "delivery";
    private final String PLACEMENT_SETTINGS_IS_DEFAULT_FIELD = "isDefault";
    private final String PLACEMENT_SETTINGS_CAPPING_FIELD = "capping";
    private final String PLACEMENT_SETTINGS_PACING_FIELD = "pacing";
    private final String PLACEMENT_SETTINGS_ENABLED_FIELD = "enabled";
    private final String PLACEMENT_SETTINGS_CAPPING_VALUE_FIELD = "maxImpressions";
    private final String PLACEMENT_SETTINGS_PACING_VALUE_FIELD = "numOfSeconds";
    private final String PLACEMENT_SETTINGS_CAPPING_UNIT_FIELD = "unit";
    private final String VIRTUAL_ITEM_NAME_FIELD = "virtualItemName";
    private final String VIRTUAL_ITEM_COUNT_FIELD = "virtualItemCount";
    private final String BACKFILL_FIELD = "backFill";
    private final String PREMIUM_FIELD = "premium";
    private final String UUID_ENABLED_FIELD = "uuidEnabled";
    private final String AB_TESTING = "abt";
    private final String DELAY_LOAD_FAILURE = "delayLoadFailure";
    private final String CRASHREPORTER_INCLUDE_KEYS_FIELD = "keysToInclude";
    private final String CRASHREPORTER_URL_FIELD = "reporterURL";
    private final String CRASHREPORTER_KEYWORD_FIELD = "reporterKeyword";
    private final String CRASHREPORTER_INCLUDE_ANR_FIELD = "includeANR";
    private final String CRASHREPORTER_ANR_TIMEOUT_FIELD = "timeout";
    private final String AD_SOURCE_NAME_FIELD = "adSourceName";
    private final String SUB_PROVIDER_ID_FIELD = "spId";
    private final String IS_MULTIPLE_INSTANCES_FIELD = "mpis";
    private final String AUCTION_FIELD = "auction";
    private final String AUCTION_DATA_FIELD = "auctionData";
    private final String AUCTION_URL_FIELD = "auctioneerURL";
    private final String AUCTION_PROGRAMMATIC_FIELD = "programmatic";
    private final String MIN_TIME_BEFORE_FIRST_AUCTION_FIELD = "minTimeBeforeFirstAuction";
    private final String TIME_TO_WAIT_BEFORE_AUCTION_FIELD = "timeToWaitBeforeAuction";
    private final String TIME_TO_WAIT_BEFORE_LOAD_FIELD = "timeToWaitBeforeLoad";
    private final String AUCTION_RETRY_INTERVAL_FIELD = "auctionRetryInterval";
    private final String IS_AUCTION_ON_SHOW_START_FIELD = "isAuctionOnShowStart";
    private final String IS_LOAD_WHILE_SHOW_FIELD = "isLoadWhileShow";
    private final String AUCTION_TRIALS_FIELD = "auctionTrials";
    private final String AUCTION_TIMEOUT_FIELD = "auctionTimeout";
    private final String AUCTION_SAVED_HISTORY_LIMIT_FIELD = "auctionSavedHistory";
    private final String AUCTION_DISABLE_LOAD_WHILE_SHOW_SUPPORT_FIELD = "disableLoadWhileShowSupportFor";
    private final String RV_TIME_TO_DELETE_WATERFALL_AFTER_AUCTION = "timeToDeleteOldWaterfallAfterAuction";
    private final String COMPRESS_AUCTION_REQUEST = "compressAuctionRequest";
    private final String COMPRESS_AUCTION_RESPONSE = "compressAuctionResponse";
    private final String SDK_TOKEN_OPT_IN_KEYS_FIELD = "optInKeys";
    private final String SDK_TOKEN_GENERIC_PARAMS_FIELD = "tokenGenericParams";
    private final String IS_EXTERNAL_ARM_EVENTS_ENABLED_FIELD = "isExternalArmEventsEnabled";
    private final String EXTERNAL_ARM_EVENTS_URL_FIELD = "externalArmEventsUrl";
    private ProviderOrder mProviderOrder;
    private ProviderSettingsHolder mProviderSettingsHolder;
    private Configurations mConfigurations;
    private String mAppKey;
    private String mUserId;
    private JSONObject mResponse;
    private Context mContext;

    public ServerResponseWrapper(Context context, String appKey, String userId, String jsonData) {
        this.mContext = context;
        try {
            this.mResponse = TextUtils.isEmpty((CharSequence)jsonData) ? new JSONObject() : new JSONObject(jsonData);
            this.parseProviderSettings();
            this.parseConfigurations();
            this.parseProviderOrder();
            this.mAppKey = TextUtils.isEmpty((CharSequence)appKey) ? "" : appKey;
            this.mUserId = TextUtils.isEmpty((CharSequence)userId) ? "" : userId;
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            this.defaultInit();
        }
    }

    public ServerResponseWrapper(ServerResponseWrapper srw) {
        try {
            this.mContext = srw.getContext();
            this.mResponse = new JSONObject(srw.mResponse.toString());
            this.mAppKey = srw.mAppKey;
            this.mUserId = srw.mUserId;
            this.mProviderOrder = srw.getProviderOrder();
            this.mProviderSettingsHolder = srw.getProviderSettingsHolder();
            this.mConfigurations = srw.getConfigurations();
        }
        catch (Exception e2) {
            this.defaultInit();
        }
    }

    private void defaultInit() {
        this.mResponse = new JSONObject();
        this.mAppKey = "";
        this.mUserId = "";
        this.mProviderOrder = new ProviderOrder();
        this.mProviderSettingsHolder = ProviderSettingsHolder.getProviderSettingsHolder();
        this.mConfigurations = new Configurations();
    }

    public String toString() {
        JSONObject resultObject = new JSONObject();
        try {
            resultObject.put(APP_KEY_FIELD, (Object)this.mAppKey);
            resultObject.put(USER_ID_FIELD, (Object)this.mUserId);
            resultObject.put(RESPONSE_FIELD, (Object)this.mResponse);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return resultObject.toString();
    }

    public boolean isValidResponse() {
        boolean valid = this.mResponse != null;
        valid = valid && !this.mResponse.has("error");
        valid = valid && this.mProviderOrder != null;
        valid = valid && this.mProviderSettingsHolder != null;
        valid = valid && this.mConfigurations != null;
        return valid;
    }

    public List<IronSource.AD_UNIT> getInitiatedAdUnits() {
        if (this.mResponse == null || this.mConfigurations == null) {
            return null;
        }
        ArrayList<IronSource.AD_UNIT> adUnits = new ArrayList<IronSource.AD_UNIT>();
        if (this.mConfigurations.getRewardedVideoConfigurations() != null && this.mProviderOrder != null && this.mProviderOrder.getRewardedVideoProviderOrder().size() > 0) {
            adUnits.add(IronSource.AD_UNIT.REWARDED_VIDEO);
        }
        if (this.mConfigurations.getInterstitialConfigurations() != null && this.mProviderOrder != null && this.mProviderOrder.getInterstitialProviderOrder().size() > 0) {
            adUnits.add(IronSource.AD_UNIT.INTERSTITIAL);
        }
        if (this.mConfigurations.getOfferwallConfigurations() != null) {
            adUnits.add(IronSource.AD_UNIT.OFFERWALL);
        }
        if (this.mConfigurations.getBannerConfigurations() != null) {
            adUnits.add(IronSource.AD_UNIT.BANNER);
        }
        return adUnits;
    }

    private void parseProviderOrder() {
        try {
            ProviderSettings settings;
            String providerName;
            int i;
            String premiumProviderName;
            String backFillProviderName;
            JSONObject providerOrderSection = this.getSection(this.mResponse, "providerOrder");
            JSONArray rvOrderSection = providerOrderSection.optJSONArray("rewardedVideo");
            JSONArray isOrderSection = providerOrderSection.optJSONArray("interstitial");
            JSONArray bnOrderSection = providerOrderSection.optJSONArray("banner");
            this.mProviderOrder = new ProviderOrder();
            if (rvOrderSection != null && this.getConfigurations() != null && this.getConfigurations().getRewardedVideoConfigurations() != null) {
                backFillProviderName = this.getConfigurations().getRewardedVideoConfigurations().getBackFillProviderName();
                premiumProviderName = this.getConfigurations().getRewardedVideoConfigurations().getPremiumProviderName();
                for (i = 0; i < rvOrderSection.length(); ++i) {
                    providerName = rvOrderSection.optString(i);
                    if (providerName.equals(backFillProviderName)) {
                        this.mProviderOrder.setRVBackFillProvider(backFillProviderName);
                        continue;
                    }
                    if (providerName.equals(premiumProviderName)) {
                        this.mProviderOrder.setRVPremiumProvider(premiumProviderName);
                    }
                    this.mProviderOrder.addRewardedVideoProvider(providerName);
                    settings = ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(providerName);
                    if (settings == null) continue;
                    settings.setRewardedVideoPriority(i);
                }
            }
            if (isOrderSection != null && this.getConfigurations() != null && this.getConfigurations().getInterstitialConfigurations() != null) {
                backFillProviderName = this.getConfigurations().getInterstitialConfigurations().getBackFillProviderName();
                premiumProviderName = this.getConfigurations().getInterstitialConfigurations().getPremiumProviderName();
                for (i = 0; i < isOrderSection.length(); ++i) {
                    providerName = isOrderSection.optString(i);
                    if (providerName.equals(backFillProviderName)) {
                        this.mProviderOrder.setISBackFillProvider(backFillProviderName);
                        continue;
                    }
                    if (providerName.equals(premiumProviderName)) {
                        this.mProviderOrder.setISPremiumProvider(premiumProviderName);
                    }
                    this.mProviderOrder.addInterstitialProvider(providerName);
                    settings = ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(providerName);
                    if (settings == null) continue;
                    settings.setInterstitialPriority(i);
                }
            }
            if (bnOrderSection != null) {
                for (int i2 = 0; i2 < bnOrderSection.length(); ++i2) {
                    String providerName2 = bnOrderSection.optString(i2);
                    this.mProviderOrder.addBannerProvider(providerName2);
                    ProviderSettings settings2 = ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(providerName2);
                    if (settings2 == null) continue;
                    settings2.setBannerPriority(i2);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void parseProviderSettings() {
        try {
            this.mProviderSettingsHolder = ProviderSettingsHolder.getProviderSettingsHolder();
            JSONObject providerSettingsSection = this.getSection(this.mResponse, "providerSettings");
            Iterator keys = providerSettingsSection.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject concreteProviderSettingsSection = providerSettingsSection.optJSONObject(key);
                if (concreteProviderSettingsSection == null) continue;
                boolean isMultipleInstances = concreteProviderSettingsSection.optBoolean("mpis", false);
                String subProviderId = concreteProviderSettingsSection.optString("spId", "0");
                String adSourceName = concreteProviderSettingsSection.optString("adSourceName", null);
                String nameForReflection = concreteProviderSettingsSection.optString("providerLoadName", key);
                JSONObject adUnitSection = this.getSection(concreteProviderSettingsSection, "adUnits");
                JSONObject appSection = this.getSection(concreteProviderSettingsSection, "application");
                JSONObject rvSection = this.getSection(adUnitSection, "rewardedVideo");
                JSONObject isSection = this.getSection(adUnitSection, "interstitial");
                JSONObject bnSection = this.getSection(adUnitSection, "banner");
                JSONObject rewardedVideoSettings = IronSourceUtils.mergeJsons(rvSection, appSection);
                JSONObject interstitialSettings = IronSourceUtils.mergeJsons(isSection, appSection);
                JSONObject bannerSettings = IronSourceUtils.mergeJsons(bnSection, appSection);
                if (this.mProviderSettingsHolder.containsProviderSettings(key)) {
                    ProviderSettings providerLocalSettings = this.mProviderSettingsHolder.getProviderSettings(key);
                    JSONObject providerLocalRVSettings = providerLocalSettings.getRewardedVideoSettings();
                    JSONObject providerLocalISSettings = providerLocalSettings.getInterstitialSettings();
                    JSONObject providerLocalBNSettings = providerLocalSettings.getBannerSettings();
                    providerLocalSettings.setRewardedVideoSettings(IronSourceUtils.mergeJsons(providerLocalRVSettings, rewardedVideoSettings));
                    providerLocalSettings.setInterstitialSettings(IronSourceUtils.mergeJsons(providerLocalISSettings, interstitialSettings));
                    providerLocalSettings.setBannerSettings(IronSourceUtils.mergeJsons(providerLocalBNSettings, bannerSettings));
                    providerLocalSettings.setIsMultipleInstances(isMultipleInstances);
                    providerLocalSettings.setSubProviderId(subProviderId);
                    providerLocalSettings.setAdSourceNameForEvents(adSourceName);
                    continue;
                }
                if (this.shouldMergeWithDebugSettings(nameForReflection)) {
                    ProviderSettings mediationLocalSettings = this.mProviderSettingsHolder.getProviderSettings("Mediation");
                    JSONObject mediationLocalRVSettings = mediationLocalSettings.getRewardedVideoSettings();
                    JSONObject mediationLocalISSettings = mediationLocalSettings.getInterstitialSettings();
                    JSONObject mediationLocalBNSettings = mediationLocalSettings.getBannerSettings();
                    JSONObject mergedRVSettings = new JSONObject(mediationLocalRVSettings.toString());
                    JSONObject mergedISSettings = new JSONObject(mediationLocalISSettings.toString());
                    JSONObject mergedBNSettings = new JSONObject(mediationLocalBNSettings.toString());
                    rewardedVideoSettings = IronSourceUtils.mergeJsons(mergedRVSettings, rewardedVideoSettings);
                    interstitialSettings = IronSourceUtils.mergeJsons(mergedISSettings, interstitialSettings);
                    bannerSettings = IronSourceUtils.mergeJsons(mergedBNSettings, bannerSettings);
                    ProviderSettings settings = new ProviderSettings(key, nameForReflection, appSection, rewardedVideoSettings, interstitialSettings, bannerSettings);
                    settings.setIsMultipleInstances(isMultipleInstances);
                    settings.setSubProviderId(subProviderId);
                    settings.setAdSourceNameForEvents(adSourceName);
                    this.mProviderSettingsHolder.addProviderSettings(settings);
                    continue;
                }
                ProviderSettings settings = new ProviderSettings(key, nameForReflection, appSection, rewardedVideoSettings, interstitialSettings, bannerSettings);
                settings.setIsMultipleInstances(isMultipleInstances);
                settings.setSubProviderId(subProviderId);
                settings.setAdSourceNameForEvents(adSourceName);
                this.mProviderSettingsHolder.addProviderSettings(settings);
            }
            this.mProviderSettingsHolder.fillSubProvidersDetails();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private boolean shouldMergeWithDebugSettings(String nameForReflection) {
        String reflectionName = StringUtils.toLowerCase(nameForReflection);
        return this.mProviderSettingsHolder.containsProviderSettings("Mediation") && (StringUtils.toLowerCase("SupersonicAds").equals(reflectionName) || StringUtils.toLowerCase("IronSource").equals(reflectionName));
    }

    private void parseConfigurations() {
        try {
            JSONObject eventParamsSection;
            InterstitialPlacement placement;
            JSONObject singlePlacementJson;
            String auctioneerURL;
            String auctionData;
            JSONArray nonConnectivityEventsJsonArray;
            int[] nonConnectivityEvents;
            JSONArray triggerEventsJsonArray;
            int[] triggerEvents;
            JSONArray optInJsonArray;
            int[] optInEvents;
            boolean compressAuctionResponse;
            boolean compressAuctionRequest;
            String abt;
            JSONObject configurationsSection = this.getSection(this.mResponse, "configurations");
            JSONObject adUnitSection = this.getSection(configurationsSection, "adUnits");
            JSONObject appSection = this.getSection(configurationsSection, "application");
            JSONObject rvSection = this.getSection(adUnitSection, "rewardedVideo");
            JSONObject isSection = this.getSection(adUnitSection, "interstitial");
            JSONObject owSection = this.getSection(adUnitSection, "offerwall");
            JSONObject bnSection = this.getSection(adUnitSection, "banner");
            JSONObject appEventsSection = this.getSection(appSection, "events");
            JSONObject loggerSection = this.getSection(appSection, "loggers");
            JSONObject tokenSection = this.getSection(appSection, "token");
            JSONObject segmentSection = this.getSection(appSection, "segment");
            JSONObject auctionSection = this.getSection(appSection, "auction");
            JSONObject crashLogSection = this.getSection(appSection, "crashReporter");
            JSONObject settingsSection = this.getSection(appSection, "settings");
            JSONObject externalSection = this.getSection(appSection, "external");
            JSONObject mediationTypesSection = null;
            if (externalSection != null) {
                mediationTypesSection = externalSection.optJSONObject("mediationTypes");
            }
            RewardedVideoConfigurations rvConfig = null;
            InterstitialConfigurations isConfig = null;
            OfferwallConfigurations owConfig = null;
            BannerConfigurations bannerConfig = null;
            if (appSection != null) {
                boolean isUuidEnabled = appSection.optBoolean("uuidEnabled", true);
                IronSourceUtils.saveBooleanToSharedPrefs(this.mContext, "uuidEnabled", isUuidEnabled);
            }
            if (appEventsSection != null && !TextUtils.isEmpty((CharSequence)(abt = appEventsSection.optString("abt")))) {
                InterstitialEventsManager.getInstance().setABT(abt);
                RewardedVideoEventsManager.getInstance().setABT(abt);
            }
            if (rvSection != null) {
                String premiumProviderName;
                String backFillProviderName;
                AuctionSettings rvAuctionSettings;
                JSONArray rvPlacementsSection = rvSection.optJSONArray("placements");
                JSONObject rvEventsSection = this.getSection(rvSection, "events");
                int rvSmartLoadAmount = this.getIntConfigValue(rvSection, appSection, "maxNumOfAdaptersToLoadOnStart", 2);
                boolean rvAdvancedLoading = false;
                int rvAdvancedLoadingAmount = this.getIntConfigValue(rvSection, appSection, "advancedLoading", 0);
                if (rvAdvancedLoadingAmount > 0) {
                    rvSmartLoadAmount = rvAdvancedLoadingAmount;
                    rvAdvancedLoading = true;
                }
                int rvSmartLoadTimeout = this.getIntConfigValue(rvSection, appSection, "adapterTimeOutInSeconds", 60);
                int rvManualLoadInterval = this.getIntConfigValue(rvSection, appSection, "loadRVInterval", 300);
                int rvExpiredDurationInMinutes = this.getIntConfigValue(rvSection, appSection, "expiredDurationInMinutes", -1);
                JSONObject rewardedVideoCombinedEvents = IronSourceUtils.mergeJsons(rvEventsSection, appEventsSection);
                boolean rvUltraEvents = rewardedVideoCombinedEvents.optBoolean("sendUltraEvents", false);
                boolean rvEventsToggle = rewardedVideoCombinedEvents.optBoolean("sendEventsToggle", false);
                String rvEventsUrl = rewardedVideoCombinedEvents.optString("serverEventsURL", "");
                String rvEventsType = rewardedVideoCombinedEvents.optString("serverEventsType", "");
                int rvBackupThreshold = rewardedVideoCombinedEvents.optInt("backupThreshold", -1);
                int rvMaxNumOfEvents = rewardedVideoCombinedEvents.optInt("maxNumberOfEvents", -1);
                int rvMaxEventsPerBatch = rewardedVideoCombinedEvents.optInt("maxEventsPerBatch", 5000);
                int[] optOutEvents = null;
                JSONArray optOutJsonArray = rewardedVideoCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray != null) {
                    optOutEvents = new int[optOutJsonArray.length()];
                    for (int i = 0; i < optOutJsonArray.length(); ++i) {
                        optOutEvents[i] = optOutJsonArray.optInt(i);
                    }
                }
                int[] optInEvents2 = null;
                JSONArray optInJsonArray2 = rewardedVideoCombinedEvents.optJSONArray("optIn");
                if (optInJsonArray2 != null) {
                    optInEvents2 = new int[optInJsonArray2.length()];
                    for (int i = 0; i < optInJsonArray2.length(); ++i) {
                        optInEvents2[i] = optInJsonArray2.optInt(i);
                    }
                }
                int[] triggerEvents2 = null;
                JSONArray triggerEventsJsonArray2 = rewardedVideoCombinedEvents.optJSONArray("triggerEvents");
                if (triggerEventsJsonArray2 != null) {
                    triggerEvents2 = new int[triggerEventsJsonArray2.length()];
                    for (int i = 0; i < triggerEventsJsonArray2.length(); ++i) {
                        triggerEvents2[i] = triggerEventsJsonArray2.optInt(i);
                    }
                }
                int[] nonConnectivityEvents2 = null;
                JSONArray nonConnectivityEventsJsonArray2 = rewardedVideoCombinedEvents.optJSONArray("nonConnectivityEvents");
                if (nonConnectivityEventsJsonArray2 != null) {
                    nonConnectivityEvents2 = new int[nonConnectivityEventsJsonArray2.length()];
                    for (int i = 0; i < nonConnectivityEventsJsonArray2.length(); ++i) {
                        nonConnectivityEvents2[i] = nonConnectivityEventsJsonArray2.optInt(i);
                    }
                }
                ApplicationEvents rvEvents = new ApplicationEvents(rvUltraEvents, rvEventsToggle, rvEventsUrl, rvEventsType, rvBackupThreshold, rvMaxNumOfEvents, rvMaxEventsPerBatch, optOutEvents, optInEvents2, triggerEvents2, nonConnectivityEvents2);
                if (auctionSection != null) {
                    JSONObject rvAuctionSection = this.getSection(auctionSection, "rewardedVideo");
                    String auctionData2 = auctionSection.optString("auctionData", "");
                    String auctioneerURL2 = auctionSection.optString("auctioneerURL", "");
                    int auctionMaxTrials = auctionSection.optInt("auctionTrials", 2);
                    long auctionTimeout = auctionSection.optLong("auctionTimeout", 10000L);
                    int auctionSavedHistoryLimit = auctionSection.optInt("auctionSavedHistory", 15);
                    compressAuctionRequest = auctionSection.optBoolean("compressAuctionRequest", false);
                    compressAuctionResponse = auctionSection.optBoolean("compressAuctionResponse", false);
                    boolean isRvProgrammatic = rvAuctionSection.optBoolean("programmatic", false);
                    int rvTimeToWaitBeforeFirstAuction = rvAuctionSection.optInt("minTimeBeforeFirstAuction", 2000);
                    int rvAuctionRetryInterval = rvAuctionSection.optInt("auctionRetryInterval", 30000);
                    int rvTimeToWaitBeforeAuction = rvAuctionSection.optInt("timeToWaitBeforeAuction", 5000);
                    int rvTimeToWaitBeforeLOAD = rvAuctionSection.optInt("timeToWaitBeforeLoad", 50);
                    boolean rvIsAuctionOnShowStart = rvAuctionSection.optBoolean("isAuctionOnShowStart", false);
                    boolean rvIsLoadWhileShow = rvAuctionSection.optBoolean("isLoadWhileShow", false);
                    int rvTimeToDeleteOldWaterfallAfterAuction = rvAuctionSection.optInt("timeToDeleteOldWaterfallAfterAuction", 30000);
                    rvAuctionSettings = new AuctionSettings(auctionData2, auctioneerURL2, auctionMaxTrials, auctionSavedHistoryLimit, auctionTimeout, isRvProgrammatic, rvTimeToWaitBeforeFirstAuction, rvAuctionRetryInterval, rvTimeToWaitBeforeAuction, rvTimeToWaitBeforeLOAD, rvIsAuctionOnShowStart, rvIsLoadWhileShow, rvTimeToDeleteOldWaterfallAfterAuction, compressAuctionRequest, compressAuctionResponse);
                    JSONArray rvLWSSupportSection = rvAuctionSection.optJSONArray("disableLoadWhileShowSupportFor");
                    if (rvLWSSupportSection != null) {
                        for (int i = 0; i < rvLWSSupportSection.length(); ++i) {
                            String providerName = rvLWSSupportSection.optString(i);
                            rvAuctionSettings.addLoadWhileShowSupportProvider(providerName);
                        }
                    }
                } else {
                    rvAuctionSettings = new AuctionSettings();
                }
                rvConfig = new RewardedVideoConfigurations(rvSmartLoadAmount, rvAdvancedLoading, rvSmartLoadTimeout, rvManualLoadInterval, rvExpiredDurationInMinutes, rvEvents, rvAuctionSettings);
                if (rvPlacementsSection != null) {
                    for (int i = 0; i < rvPlacementsSection.length(); ++i) {
                        JSONObject singlePlacementJson2 = rvPlacementsSection.optJSONObject(i);
                        Placement placement2 = this.parseSingleRVPlacement(singlePlacementJson2);
                        if (placement2 == null) continue;
                        rvConfig.addRewardedVideoPlacement(placement2);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(backFillProviderName = rvSection.optString("backFill")))) {
                    rvConfig.setBackFillProviderName(backFillProviderName);
                }
                if (!TextUtils.isEmpty((CharSequence)(premiumProviderName = rvSection.optString("premium")))) {
                    rvConfig.setPremiumProviderName(premiumProviderName);
                }
            }
            if (isSection != null) {
                String premiumProviderName;
                String backFillProviderName;
                AuctionSettings isAuctionSettings;
                JSONArray isPlacementsSection = isSection.optJSONArray("placements");
                JSONObject isEventsSection = this.getSection(isSection, "events");
                int isSmartLoadAmount = this.getIntConfigValue(isSection, appSection, "maxNumOfAdaptersToLoadOnStart", 2);
                boolean isAdvancedLoading = false;
                int isAdvancedLoadingAmount = this.getIntConfigValue(isSection, appSection, "advancedLoading", 0);
                if (isAdvancedLoadingAmount > 0) {
                    isSmartLoadAmount = isAdvancedLoadingAmount;
                    isAdvancedLoading = true;
                }
                int isSmartLoadTimeout = this.getIntConfigValue(isSection, appSection, "adapterTimeOutInSeconds", 60);
                int isDelayLoadFailureTimeout = this.getIntConfigValue(isSection, appSection, "delayLoadFailure", 3);
                JSONObject interstitialCombinedEvents = IronSourceUtils.mergeJsons(isEventsSection, appEventsSection);
                boolean isEventsToggle = interstitialCombinedEvents.optBoolean("sendEventsToggle", false);
                String isEventsUrl = interstitialCombinedEvents.optString("serverEventsURL", "");
                String isEventsType = interstitialCombinedEvents.optString("serverEventsType", "");
                int isBackupThreshold = interstitialCombinedEvents.optInt("backupThreshold", -1);
                int isMaxNumOfEvents = interstitialCombinedEvents.optInt("maxNumberOfEvents", -1);
                int isMaxEventsPerBatch = interstitialCombinedEvents.optInt("maxEventsPerBatch", 5000);
                int[] optOutEvents = null;
                JSONArray optOutJsonArray = interstitialCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray != null) {
                    optOutEvents = new int[optOutJsonArray.length()];
                    for (int i = 0; i < optOutJsonArray.length(); ++i) {
                        optOutEvents[i] = optOutJsonArray.optInt(i);
                    }
                }
                optInEvents = null;
                optInJsonArray = interstitialCombinedEvents.optJSONArray("optIn");
                if (optInJsonArray != null) {
                    optInEvents = new int[optInJsonArray.length()];
                    for (int i = 0; i < optInJsonArray.length(); ++i) {
                        optInEvents[i] = optInJsonArray.optInt(i);
                    }
                }
                triggerEvents = null;
                triggerEventsJsonArray = interstitialCombinedEvents.optJSONArray("triggerEvents");
                if (triggerEventsJsonArray != null) {
                    triggerEvents = new int[triggerEventsJsonArray.length()];
                    for (int i = 0; i < triggerEventsJsonArray.length(); ++i) {
                        triggerEvents[i] = triggerEventsJsonArray.optInt(i);
                    }
                }
                nonConnectivityEvents = null;
                nonConnectivityEventsJsonArray = interstitialCombinedEvents.optJSONArray("nonConnectivityEvents");
                if (nonConnectivityEventsJsonArray != null) {
                    nonConnectivityEvents = new int[nonConnectivityEventsJsonArray.length()];
                    for (int i = 0; i < nonConnectivityEventsJsonArray.length(); ++i) {
                        nonConnectivityEvents[i] = nonConnectivityEventsJsonArray.optInt(i);
                    }
                }
                ApplicationEvents isEvents = new ApplicationEvents(false, isEventsToggle, isEventsUrl, isEventsType, isBackupThreshold, isMaxNumOfEvents, isMaxEventsPerBatch, optOutEvents, optInEvents, triggerEvents, nonConnectivityEvents);
                if (auctionSection != null) {
                    JSONObject isAuctionSection = this.getSection(auctionSection, "interstitial");
                    auctionData = auctionSection.optString("auctionData", "");
                    auctioneerURL = auctionSection.optString("auctioneerURL", "");
                    int auctionMaxTrials = auctionSection.optInt("auctionTrials", 2);
                    int auctionSavedHistoryLimit = auctionSection.optInt("auctionSavedHistory", 15);
                    long auctionTimeout = auctionSection.optLong("auctionTimeout", 10000L);
                    boolean isProgrammatic = isAuctionSection.optBoolean("programmatic", false);
                    int minTimeToWaitBeforeFirstAuction = isAuctionSection.optInt("minTimeBeforeFirstAuction", 2000);
                    compressAuctionRequest = auctionSection.optBoolean("compressAuctionRequest", false);
                    compressAuctionResponse = auctionSection.optBoolean("compressAuctionResponse", false);
                    isAuctionSettings = new AuctionSettings(auctionData, auctioneerURL, auctionMaxTrials, auctionSavedHistoryLimit, auctionTimeout, isProgrammatic, minTimeToWaitBeforeFirstAuction, 0L, 0L, 0L, true, true, 0, compressAuctionRequest, compressAuctionResponse);
                } else {
                    isAuctionSettings = new AuctionSettings();
                }
                isConfig = new InterstitialConfigurations(isSmartLoadAmount, isAdvancedLoading, isSmartLoadTimeout, isEvents, isAuctionSettings, isDelayLoadFailureTimeout);
                if (isPlacementsSection != null) {
                    for (int i = 0; i < isPlacementsSection.length(); ++i) {
                        singlePlacementJson = isPlacementsSection.optJSONObject(i);
                        placement = this.parseSingleISPlacement(singlePlacementJson);
                        if (placement == null) continue;
                        isConfig.addInterstitialPlacement(placement);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(backFillProviderName = isSection.optString("backFill")))) {
                    isConfig.setBackFillProviderName(backFillProviderName);
                }
                if (!TextUtils.isEmpty((CharSequence)(premiumProviderName = isSection.optString("premium")))) {
                    isConfig.setPremiumProviderName(premiumProviderName);
                }
            }
            if (bnSection != null) {
                AuctionSettings auctionSettings;
                JSONArray bnPlacementsSection = bnSection.optJSONArray("placements");
                JSONObject bnEventsSection = this.getSection(bnSection, "events");
                int bnSmartLoadAmount = this.getIntConfigValue(bnSection, appSection, "maxNumOfAdaptersToLoadOnStart", 1);
                long bnSmartLoadTimeout = this.getLongConfigValue(bnSection, appSection, "atim", 10000L);
                int bnDelayLoadFailureTimeout = this.getIntConfigValue(bnSection, appSection, "delayLoadFailure", 3);
                int bnIntervalTime = this.getIntConfigValue(bnSection, appSection, "bannerInterval", 60);
                JSONObject bannerCombinedEvents = IronSourceUtils.mergeJsons(bnEventsSection, appEventsSection);
                boolean bnEventsToggle = bannerCombinedEvents.optBoolean("sendEventsToggle", false);
                String bnEventsUrl = bannerCombinedEvents.optString("serverEventsURL", "");
                String bnEventsType = bannerCombinedEvents.optString("serverEventsType", "");
                int bnBackupThreshold = bannerCombinedEvents.optInt("backupThreshold", -1);
                int bnMaxNumOfEvents = bannerCombinedEvents.optInt("maxNumberOfEvents", -1);
                int bnMaxEventsPerBatch = bannerCombinedEvents.optInt("maxEventsPerBatch", 5000);
                int[] optOutEvents = null;
                JSONArray optOutJsonArray = bannerCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray != null) {
                    optOutEvents = new int[optOutJsonArray.length()];
                    for (int i = 0; i < optOutJsonArray.length(); ++i) {
                        optOutEvents[i] = optOutJsonArray.optInt(i);
                    }
                }
                optInEvents = null;
                optInJsonArray = bannerCombinedEvents.optJSONArray("optIn");
                if (optInJsonArray != null) {
                    optInEvents = new int[optInJsonArray.length()];
                    for (int i = 0; i < optInJsonArray.length(); ++i) {
                        optInEvents[i] = optInJsonArray.optInt(i);
                    }
                }
                triggerEvents = null;
                triggerEventsJsonArray = bannerCombinedEvents.optJSONArray("triggerEvents");
                if (triggerEventsJsonArray != null) {
                    triggerEvents = new int[triggerEventsJsonArray.length()];
                    for (int i = 0; i < triggerEventsJsonArray.length(); ++i) {
                        triggerEvents[i] = triggerEventsJsonArray.optInt(i);
                    }
                }
                nonConnectivityEvents = null;
                nonConnectivityEventsJsonArray = bannerCombinedEvents.optJSONArray("nonConnectivityEvents");
                if (nonConnectivityEventsJsonArray != null) {
                    nonConnectivityEvents = new int[nonConnectivityEventsJsonArray.length()];
                    for (int i = 0; i < nonConnectivityEventsJsonArray.length(); ++i) {
                        nonConnectivityEvents[i] = nonConnectivityEventsJsonArray.optInt(i);
                    }
                }
                ApplicationEvents bnEvents = new ApplicationEvents(false, bnEventsToggle, bnEventsUrl, bnEventsType, bnBackupThreshold, bnMaxNumOfEvents, bnMaxEventsPerBatch, optOutEvents, optInEvents, triggerEvents, nonConnectivityEvents);
                if (auctionSection != null) {
                    JSONObject bnAuctionSection = this.getSection(auctionSection, "banner");
                    if (bnAuctionSection != null) {
                        auctionData = auctionSection.optString("auctionData", "");
                        auctioneerURL = auctionSection.optString("auctioneerURL", "");
                        int auctionMaxTrials = auctionSection.optInt("auctionTrials", 2);
                        int auctionSavedHistoryLimit = auctionSection.optInt("auctionSavedHistory", 15);
                        long auctionTimeout = auctionSection.optLong("auctionTimeout", 10000L);
                        boolean compressAuctionRequest2 = auctionSection.optBoolean("compressAuctionRequest", false);
                        boolean compressAuctionResponse2 = auctionSection.optBoolean("compressAuctionResponse", false);
                        boolean isProgrammatic = bnAuctionSection.optBoolean("programmatic", false);
                        int minTimeToWaitBeforeFirstAuction = bnAuctionSection.optInt("minTimeBeforeFirstAuction", 2000);
                        auctionSettings = new AuctionSettings(auctionData, auctioneerURL, auctionMaxTrials, auctionSavedHistoryLimit, auctionTimeout, isProgrammatic, minTimeToWaitBeforeFirstAuction, 0L, 0L, 0L, true, true, 0, compressAuctionRequest2, compressAuctionResponse2);
                    } else {
                        auctionSettings = new AuctionSettings();
                    }
                } else {
                    auctionSettings = new AuctionSettings();
                }
                bannerConfig = new BannerConfigurations(bnSmartLoadAmount, bnSmartLoadTimeout, bnEvents, bnIntervalTime, auctionSettings, bnDelayLoadFailureTimeout);
                if (bnPlacementsSection != null) {
                    for (int i = 0; i < bnPlacementsSection.length(); ++i) {
                        singlePlacementJson = bnPlacementsSection.optJSONObject(i);
                        placement = this.parseSingleBNPlacement(singlePlacementJson);
                        if (placement == null) continue;
                        bannerConfig.addBannerPlacement((BannerPlacement)placement);
                    }
                }
            }
            if (owSection != null) {
                JSONObject owEventsSection = this.getSection(owSection, "events");
                JSONObject owCombinedEvents = IronSourceUtils.mergeJsons(owEventsSection, appEventsSection);
                boolean owEventsToggle = owCombinedEvents.optBoolean("sendEventsToggle", false);
                String owEventsUrl = owCombinedEvents.optString("serverEventsURL", "");
                String owEventsType = owCombinedEvents.optString("serverEventsType", "");
                int owBackupThreshold = owCombinedEvents.optInt("backupThreshold", -1);
                int owMaxNumOfEvents = owCombinedEvents.optInt("maxNumberOfEvents", -1);
                int owMaxEventsPerBatch = owCombinedEvents.optInt("maxEventsPerBatch", 5000);
                int[] optOutEvents = null;
                JSONArray optOutJsonArray = owCombinedEvents.optJSONArray("optOut");
                if (optOutJsonArray != null) {
                    optOutEvents = new int[optOutJsonArray.length()];
                    for (int i = 0; i < optOutJsonArray.length(); ++i) {
                        optOutEvents[i] = optOutJsonArray.optInt(i);
                    }
                }
                int[] optInEvents3 = null;
                JSONArray optInJsonArray3 = owCombinedEvents.optJSONArray("optIn");
                if (optInJsonArray3 != null) {
                    optInEvents3 = new int[optInJsonArray3.length()];
                    for (int i = 0; i < optInJsonArray3.length(); ++i) {
                        optInEvents3[i] = optInJsonArray3.optInt(i);
                    }
                }
                int[] triggerEvents3 = null;
                JSONArray triggerEventsJsonArray3 = owCombinedEvents.optJSONArray("triggerEvents");
                if (triggerEventsJsonArray3 != null) {
                    triggerEvents3 = new int[triggerEventsJsonArray3.length()];
                    for (int i = 0; i < triggerEventsJsonArray3.length(); ++i) {
                        triggerEvents3[i] = triggerEventsJsonArray3.optInt(i);
                    }
                }
                int[] nonConnectivityEvents3 = null;
                JSONArray nonConnectivityEventsJsonArray3 = owCombinedEvents.optJSONArray("nonConnectivityEvents");
                if (nonConnectivityEventsJsonArray3 != null) {
                    nonConnectivityEvents3 = new int[nonConnectivityEventsJsonArray3.length()];
                    for (int i = 0; i < nonConnectivityEventsJsonArray3.length(); ++i) {
                        nonConnectivityEvents3[i] = nonConnectivityEventsJsonArray3.optInt(i);
                    }
                }
                ApplicationEvents owEvents = new ApplicationEvents(false, owEventsToggle, owEventsUrl, owEventsType, owBackupThreshold, owMaxNumOfEvents, owMaxEventsPerBatch, optOutEvents, optInEvents3, triggerEvents3, nonConnectivityEvents3);
                owConfig = new OfferwallConfigurations(owEvents);
                owConfig.setOfferWallSection(owSection);
                JSONArray owPlacementsSection = owSection.optJSONArray("placements");
                if (owPlacementsSection != null) {
                    for (int i = 0; i < owPlacementsSection.length(); ++i) {
                        JSONObject singlePlacementJson3 = owPlacementsSection.optJSONObject(i);
                        OfferwallPlacement placement3 = this.parseSingleOWPlacement(singlePlacementJson3);
                        if (placement3 == null) continue;
                        owConfig.addOfferwallPlacement(placement3);
                    }
                }
            }
            TokenSettings tokenSettings = new TokenSettings();
            if (tokenSection != null) {
                JSONObject tokenGenericParams;
                JSONArray optInTokenKeyParamsArray = tokenSection.optJSONArray("optInKeys");
                if (optInTokenKeyParamsArray != null) {
                    for (int i = 0; i < optInTokenKeyParamsArray.length(); ++i) {
                        String keyParam = optInTokenKeyParamsArray.optString(i);
                        tokenSettings.addOptInKeyParam(keyParam);
                    }
                }
                if ((tokenGenericParams = tokenSection.optJSONObject("tokenGenericParams")) != null) {
                    tokenSettings.setGenericParams(tokenGenericParams);
                }
            }
            int serverLoggerLevel = loggerSection.optInt("server", 3);
            int publisherLoggerLevel = loggerSection.optInt("publisher", 3);
            int consoleLoggerLevel = loggerSection.optInt("console", 3);
            ApplicationLogger logger = new ApplicationLogger(serverLoggerLevel, publisherLoggerLevel, consoleLoggerLevel);
            ApplicationCrashReporterSettings crashReporterSettings = new ApplicationCrashReporterSettings();
            if (crashLogSection != null) {
                boolean isCrashReporter = crashLogSection.optBoolean("enabled", false);
                crashReporterSettings.setKeyParamsToIncludeInReporter(isCrashReporter);
                String crashReporterURL = crashLogSection.optString("reporterURL", "");
                crashReporterSettings.setReporterURL(crashReporterURL);
                String crashReporterKeyword = crashLogSection.optString("reporterKeyword", "");
                crashReporterSettings.setReporterKeyword(crashReporterKeyword);
                boolean shouldIncludeANR = crashLogSection.optBoolean("includeANR", false);
                crashReporterSettings.shouldIncludeANR(shouldIncludeANR);
                int anrTimeout = crashLogSection.optInt("timeout", 5000);
                crashReporterSettings.setDefaultAnrTimeout(anrTimeout);
                JSONArray crashReporterParamsToInclude = crashLogSection.optJSONArray("keysToInclude");
                if (crashReporterParamsToInclude != null) {
                    for (int i = 0; i < crashReporterParamsToInclude.length(); ++i) {
                        String keyParam = crashReporterParamsToInclude.optString(i);
                        crashReporterSettings.addKeyParamToInclude(keyParam);
                    }
                }
            }
            ServerSegmetData segmentData = null;
            if (segmentSection != null) {
                String segmentName = segmentSection.optString("name", "");
                String segmentId = segmentSection.optString("id", "-1");
                JSONObject customSegments = segmentSection.optJSONObject("custom");
                segmentData = new ServerSegmetData(segmentName, segmentId, customSegments);
            }
            ApplicationGeneralSettings generalSettings = new ApplicationGeneralSettings();
            if (settingsSection != null) {
                boolean isExternalArmEventsEnabled = settingsSection.optBoolean("isExternalArmEventsEnabled", true);
                String externalArmEventsUrl = settingsSection.optString("externalArmEventsUrl", "http://outcome-arm-ext-med-ext.sonic-us.supersonicads.com/aemData");
                generalSettings = new ApplicationGeneralSettings(isExternalArmEventsEnabled, externalArmEventsUrl);
            }
            Map<String, String> mediationTypesMap = null;
            if (mediationTypesSection != null) {
                mediationTypesMap = IronSourceUtils.parseJsonToStringMap(mediationTypesSection);
            }
            boolean isIntegration = appSection.optBoolean("integration", false);
            ApplicationConfigurations appConfig = new ApplicationConfigurations(logger, segmentData, tokenSettings, isIntegration, crashReporterSettings, generalSettings, mediationTypesMap);
            this.mConfigurations = new Configurations(rvConfig, isConfig, owConfig, bannerConfig, appConfig);
            JSONObject batchParamsSection = this.getSection(appEventsSection, "genericParams");
            JSONObject copyOfBatchParams = batchParamsSection;
            if (copyOfBatchParams != null && (eventParamsSection = this.getSection(copyOfBatchParams, "events")) != null) {
                copyOfBatchParams.remove("events");
                Map<String, String> genericParamsEventsMap = IronSourceUtils.parseJsonToStringMap(eventParamsSection);
                RewardedVideoEventsManager.getInstance().setEventGenericParams(genericParamsEventsMap);
                InterstitialEventsManager.getInstance().setEventGenericParams(genericParamsEventsMap);
            }
            if (batchParamsSection != null) {
                Map<String, String> genericParamsBatchMap = IronSourceUtils.parseJsonToStringMap(copyOfBatchParams);
                RewardedVideoEventsManager.getInstance().setBatchParams(genericParamsBatchMap);
                InterstitialEventsManager.getInstance().setBatchParams(genericParamsBatchMap);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private boolean getBooleanConfigValue(JSONObject mainJson, JSONObject secondaryJson, String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (mainJson.has(key)) {
            result = mainJson.optBoolean(key, defaultValue);
        } else if (secondaryJson.has(key)) {
            result = secondaryJson.optBoolean(key, defaultValue);
        }
        return result;
    }

    private int getIntConfigValue(JSONObject mainJson, JSONObject secondaryJson, String key, int defaultValue) {
        int result = 0;
        if (mainJson.has(key)) {
            result = mainJson.optInt(key, 0);
        } else if (secondaryJson.has(key)) {
            result = secondaryJson.optInt(key, 0);
        }
        if (result == 0) {
            result = defaultValue;
        }
        return result;
    }

    private long getLongConfigValue(JSONObject mainJson, JSONObject secondaryJson, String key, long defaultValue) {
        long result = 0L;
        if (mainJson.has(key)) {
            result = mainJson.optLong(key, 0L);
        } else if (secondaryJson.has(key)) {
            result = secondaryJson.optLong(key, 0L);
        }
        if (result == 0L) {
            result = defaultValue;
        }
        return result;
    }

    private Placement parseSingleRVPlacement(JSONObject placementJson) {
        Placement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            boolean isDefault = placementJson.optBoolean("isDefault", false);
            String virtualItemName = placementJson.optString("virtualItemName", "");
            int virtualItemCount = placementJson.optInt("virtualItemCount", -1);
            PlacementAvailabilitySettings settings = this.getPlacementAvailabilitySettings(placementJson);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName) && !TextUtils.isEmpty((CharSequence)virtualItemName) && virtualItemCount > 0) {
                result = new Placement(placementId, placementName, isDefault, virtualItemName, virtualItemCount, settings);
                if (settings != null) {
                    CappingManager.addCappingInfo(this.mContext, result);
                }
            }
        }
        return result;
    }

    private InterstitialPlacement parseSingleISPlacement(JSONObject placementJson) {
        InterstitialPlacement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            boolean isDefault = placementJson.optBoolean("isDefault", false);
            PlacementAvailabilitySettings settings = this.getPlacementAvailabilitySettings(placementJson);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName)) {
                result = new InterstitialPlacement(placementId, placementName, isDefault, settings);
                if (settings != null) {
                    CappingManager.addCappingInfo(this.mContext, result);
                }
            }
        }
        return result;
    }

    private OfferwallPlacement parseSingleOWPlacement(JSONObject placementJson) {
        OfferwallPlacement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            boolean isDefault = placementJson.optBoolean("isDefault", false);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName)) {
                result = new OfferwallPlacement(placementId, placementName, isDefault);
            }
        }
        return result;
    }

    private BannerPlacement parseSingleBNPlacement(JSONObject placementJson) {
        BannerPlacement result = null;
        if (placementJson != null) {
            int placementId = placementJson.optInt("placementId", -1);
            String placementName = placementJson.optString("placementName", "");
            boolean isDefault = placementJson.optBoolean("isDefault", false);
            PlacementAvailabilitySettings settings = this.getPlacementAvailabilitySettings(placementJson);
            if (placementId >= 0 && !TextUtils.isEmpty((CharSequence)placementName)) {
                result = new BannerPlacement(placementId, placementName, isDefault, settings);
                if (settings != null) {
                    CappingManager.addCappingInfo(this.mContext, result);
                }
            }
        }
        return result;
    }

    private PlacementAvailabilitySettings getPlacementAvailabilitySettings(JSONObject placementJson) {
        JSONObject pacingJson;
        if (placementJson == null) {
            return null;
        }
        PlacementAvailabilitySettings.PlacementAvailabilitySettingsBuilder settingsBuilder = new PlacementAvailabilitySettings.PlacementAvailabilitySettingsBuilder();
        boolean delivery = placementJson.optBoolean("delivery", true);
        settingsBuilder.delivery(delivery);
        JSONObject cappingJson = placementJson.optJSONObject("capping");
        if (cappingJson != null) {
            PlacementCappingType cappingType = null;
            String cappingUnitString = cappingJson.optString("unit");
            if (!TextUtils.isEmpty((CharSequence)cappingUnitString)) {
                if (PlacementCappingType.PER_DAY.toString().equals(cappingUnitString)) {
                    cappingType = PlacementCappingType.PER_DAY;
                } else if (PlacementCappingType.PER_HOUR.toString().equals(cappingUnitString)) {
                    cappingType = PlacementCappingType.PER_HOUR;
                }
            }
            int cappingValue = cappingJson.optInt("maxImpressions", 0);
            boolean isCappingEnabled = cappingJson.optBoolean("enabled", false) && cappingValue > 0;
            settingsBuilder.capping(isCappingEnabled, cappingType, cappingValue);
        }
        if ((pacingJson = placementJson.optJSONObject("pacing")) != null) {
            int pacingValue = pacingJson.optInt("numOfSeconds", 0);
            boolean isPacingEnabled = pacingJson.optBoolean("enabled", false) && pacingValue > 0;
            settingsBuilder.pacing(isPacingEnabled, pacingValue);
        }
        return settingsBuilder.build();
    }

    private JSONObject getSection(JSONObject json, String sectionName) {
        JSONObject result = null;
        if (json != null) {
            result = json.optJSONObject(sectionName);
        }
        return result;
    }

    public String getRVBackFillProvider() {
        try {
            return this.mProviderOrder.getRVBackFillProvider();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.INTERNAL, "getRVBackFillProvider", e2);
            return null;
        }
    }

    public String getRVPremiumProvider() {
        try {
            return this.mProviderOrder.getRVPremiumProvider();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.INTERNAL, "getRVPremiumProvider", e2);
            return null;
        }
    }

    public ProviderSettingsHolder getProviderSettingsHolder() {
        return this.mProviderSettingsHolder;
    }

    public ProviderOrder getProviderOrder() {
        return this.mProviderOrder;
    }

    public Configurations getConfigurations() {
        return this.mConfigurations;
    }

    private Context getContext() {
        return this.mContext;
    }
}

