/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ConcurrentHashMap;

public class ContextProvider {
    private Activity mCurrentActiveActivity;
    private Context mApplicationContext;
    private ConcurrentHashMap<String, ContextLifeCycleListener> mLifeCycleListenerUniqueByClassNameMap;
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private static volatile ContextProvider mInstance;

    private ContextProvider() {
        this.mLifeCycleListenerUniqueByClassNameMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextProvider getInstance() {
        if (mInstance != null) return mInstance;
        Class<ContextProvider> clazz = ContextProvider.class;
        synchronized (ContextProvider.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ContextProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void updateActivity(Activity activity) {
        if (activity != null) {
            this.mCurrentActiveActivity = activity;
        }
    }

    public void onResume(Activity activity) {
        if (activity != null) {
            this.mCurrentActiveActivity = activity;
            for (ContextLifeCycleListener lifeCycleListener : this.mLifeCycleListenerUniqueByClassNameMap.values()) {
                lifeCycleListener.onResume(this.mCurrentActiveActivity);
            }
        }
    }

    public void onPause(Activity activity) {
        if (activity != null) {
            for (ContextLifeCycleListener lifeCycleListener : this.mLifeCycleListenerUniqueByClassNameMap.values()) {
                lifeCycleListener.onPause(activity);
            }
        }
    }

    public void updateAppContext(Context applicationContext) {
        if (applicationContext != null) {
            this.mApplicationContext = applicationContext;
        }
    }

    public Activity getCurrentActiveActivity() {
        return this.mCurrentActiveActivity;
    }

    public Context getApplicationContext() {
        if (this.mApplicationContext == null && this.mCurrentActiveActivity != null) {
            return this.mCurrentActiveActivity.getApplicationContext();
        }
        return this.mApplicationContext;
    }

    public void registerLifeCycleListener(ContextLifeCycleListener lifeCycleListener) {
        this.mLifeCycleListenerUniqueByClassNameMap.put(lifeCycleListener.getClass().getSimpleName(), lifeCycleListener);
    }

    public void postOnUIThread(Runnable action) {
        if (this.mainThreadHandler != null) {
            this.mainThreadHandler.post(action);
        }
    }

    public void runOnUIThread(Runnable action) {
        if (this.mCurrentActiveActivity != null) {
            this.mCurrentActiveActivity.runOnUiThread(action);
        }
    }

    public static interface ContextLifeCycleListener {
        public void onResume(Activity var1);

        public void onPause(Activity var1);
    }
}

