/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.text.TextUtils;
import java.util.ArrayList;

public class AuctionSettings {
    private boolean mIsProgrammatic;
    private String mAuctionData;
    private String mUrl;
    private int mMaxTrials;
    private int mAuctionSavedHistoryLimit;
    private int timeToDeleteOldWaterfallAfterAuction;
    private long mAuctionTimeout;
    private long mMinTimeToWaitBeforeFirstAuction;
    private long mAuctionRetryInterval;
    private long mTimeToWaitBeforeAuction;
    private long mTimeToWaitBeforeLoad;
    private boolean mIsAuctionOnShowStart;
    private boolean mIsLoadWhileShow;
    private ArrayList<String> disableLoadWhileShowSupportFor;
    private boolean mCompressAuctionRequest;
    private boolean mCompressAuctionResponse;

    AuctionSettings() {
        this.mAuctionData = "";
        this.mUrl = "";
        this.mIsProgrammatic = false;
        this.mMinTimeToWaitBeforeFirstAuction = 0L;
        this.mAuctionRetryInterval = 0L;
        this.mTimeToWaitBeforeAuction = 0L;
        this.mTimeToWaitBeforeLoad = 0L;
        this.mIsAuctionOnShowStart = true;
        this.mIsLoadWhileShow = true;
        this.disableLoadWhileShowSupportFor = new ArrayList();
        this.timeToDeleteOldWaterfallAfterAuction = 0;
        this.mCompressAuctionRequest = false;
        this.mCompressAuctionResponse = false;
    }

    AuctionSettings(String auctionData, String url, int maxTrials, int auctionSavedHistoryLimit, long auctionTimeout, boolean isProgrammatic, long minTimeToWaitBeforeFirstAuction, long auctionRetryInterval, long timeToWaitBeforeAuction, long timeToWaitBeforeLoad, boolean isAuctionOnShowStart, boolean isLoadWhileShow, int timeToDeleteOldWaterfallAfterAuction, boolean compressAuctionRequest, boolean compressAuctionResponse) {
        this.mAuctionData = auctionData;
        this.mUrl = url;
        this.mMaxTrials = maxTrials;
        this.mAuctionSavedHistoryLimit = auctionSavedHistoryLimit;
        this.mAuctionTimeout = auctionTimeout;
        this.mIsProgrammatic = isProgrammatic;
        this.mMinTimeToWaitBeforeFirstAuction = minTimeToWaitBeforeFirstAuction;
        this.mAuctionRetryInterval = auctionRetryInterval;
        this.mTimeToWaitBeforeAuction = timeToWaitBeforeAuction;
        this.mTimeToWaitBeforeLoad = timeToWaitBeforeLoad;
        this.mIsAuctionOnShowStart = isAuctionOnShowStart;
        this.mIsLoadWhileShow = isLoadWhileShow;
        this.timeToDeleteOldWaterfallAfterAuction = timeToDeleteOldWaterfallAfterAuction;
        this.disableLoadWhileShowSupportFor = new ArrayList();
        this.mCompressAuctionRequest = compressAuctionRequest;
        this.mCompressAuctionResponse = compressAuctionResponse;
    }

    public boolean getIsProgrammatic() {
        return this.mIsProgrammatic;
    }

    public String getAuctionData() {
        return this.mAuctionData;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public long getTimeToWaitBeforeFirstAuctionMs() {
        return this.mMinTimeToWaitBeforeFirstAuction;
    }

    public long getAuctionRetryInterval() {
        return this.mAuctionRetryInterval;
    }

    public long getTimeToWaitBeforeAuctionMs() {
        return this.mTimeToWaitBeforeAuction;
    }

    public long getTimeToWaitBeforeLoadMs() {
        return this.mTimeToWaitBeforeLoad;
    }

    public boolean getIsAuctionOnShowStart() {
        return this.mIsAuctionOnShowStart;
    }

    public boolean getIsLoadWhileShow() {
        return this.mIsLoadWhileShow;
    }

    public int getNumOfMaxTrials() {
        return this.mMaxTrials;
    }

    public long getTrialsInterval() {
        return this.mAuctionTimeout;
    }

    public int getAuctionSavedHistoryLimit() {
        return this.mAuctionSavedHistoryLimit;
    }

    public ArrayList<String> getLoadWhileShowSupportArray() {
        return this.disableLoadWhileShowSupportFor;
    }

    public void addLoadWhileShowSupportProvider(String providerName) {
        if (!TextUtils.isEmpty((CharSequence)providerName)) {
            this.disableLoadWhileShowSupportFor.add(providerName);
        }
    }

    public int getTimeToDeleteOldWaterfallAfterAuction() {
        return this.timeToDeleteOldWaterfallAfterAuction;
    }

    public boolean isCompressAuctionRequest() {
        return this.mCompressAuctionRequest;
    }

    public boolean isCompressAuctionResponse() {
        return this.mCompressAuctionResponse;
    }
}

