/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.server;

import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpFunctions {
    private static final int SERVER_REQUEST_TIMEOUT = 15000;
    private static final String SERVER_REQUEST_GET_METHOD = "GET";
    private static final String SERVER_REQUEST_POST_METHOD = "POST";
    private static final String SERVER_REQUEST_ENCODING = "UTF-8";
    public static final String ERROR_PREFIX = "ERROR:";
    private static final String SERVER_BAD_REQUEST_ERROR = "Bad Request - 400";

    public static String getStringFromURL(String link) throws Exception {
        return HttpFunctions.getStringFromURL(link, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromURL(String link, IronSourceObject.IResponseListener listener) throws Exception {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            String line;
            URL requestURL = new URL(link);
            conn = (HttpURLConnection)requestURL.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod(SERVER_REQUEST_GET_METHOD);
            conn.setDoInput(true);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode == 400) {
                if (listener != null) {
                    listener.onUnrecoverableError(SERVER_BAD_REQUEST_ERROR);
                }
                String string = null;
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String result = stringBuilder.toString();
            if (TextUtils.isEmpty((CharSequence)result)) {
                String string = null;
                return string;
            }
            String string = result;
            return string;
        }
        catch (Exception e2) {
            String string = null;
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static boolean sendPostRequest(String url, String json) {
        return HttpFunctions.sendPostRequestWithAutho(url, json, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendPostRequestWithAutho(String url, String json, String userName, String password) {
        OutputStream os = null;
        HttpURLConnection conn = null;
        try {
            boolean isResponseValid;
            URL requestURL = new URL(url);
            String authorizationString = null;
            if (userName != null && password != null) {
                authorizationString = IronSourceUtils.getBase64Auth(userName, password);
                conn.setRequestProperty("Authorization", authorizationString);
            }
            conn = (HttpURLConnection)requestURL.openConnection();
            conn.setReadTimeout(15000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod(SERVER_REQUEST_POST_METHOD);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, SERVER_REQUEST_ENCODING));
            writer.write(json);
            writer.flush();
            writer.close();
            int responseCode = conn.getResponseCode();
            boolean bl = isResponseValid = responseCode == 200;
            if (!isResponseValid) {
                IronLog.INTERNAL.error("invalid response code " + responseCode + " sending request");
            }
            boolean bl2 = isResponseValid;
            return bl2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            IronLog.INTERNAL.error("exception while sending request " + e2.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

