/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.os.Handler;
import android.os.Looper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;

public class RVListenerWrapper {
    private static final RVListenerWrapper sInstance = new RVListenerWrapper();
    private RewardedVideoListener mListener = null;

    public static synchronized RVListenerWrapper getInstance() {
        return sInstance;
    }

    private RVListenerWrapper() {
    }

    private String getPlacementName(Placement placement) {
        if (placement == null) {
            return "";
        }
        return placement.getPlacementName();
    }

    public synchronized void setListener(RewardedVideoListener listener) {
        this.mListener = listener;
    }

    public synchronized void onRewardedVideoAdOpened() {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdOpened();
                        RVListenerWrapper.this.log("onRewardedVideoAdOpened()");
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAdClosed() {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdClosed();
                        RVListenerWrapper.this.log("onRewardedVideoAdClosed()");
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAvailabilityChanged(final boolean available) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAvailabilityChanged(available);
                        RVListenerWrapper.this.log("onRewardedVideoAvailabilityChanged() available=" + available);
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAdStarted() {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    4 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdStarted();
                        RVListenerWrapper.this.log("onRewardedVideoAdStarted()");
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAdEnded() {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    5 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdEnded();
                        RVListenerWrapper.this.log("onRewardedVideoAdEnded()");
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAdRewarded(final Placement placement) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    6 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdRewarded(placement);
                        RVListenerWrapper.this.log("onRewardedVideoAdRewarded(" + placement + ")");
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAdShowFailed(final IronSourceError error) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    7 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdShowFailed(error);
                        RVListenerWrapper.this.log("onRewardedVideoAdShowFailed() error=" + error.getErrorMessage());
                    }
                }
            });
        }
    }

    public synchronized void onRewardedVideoAdClicked(final Placement placement) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    8 var1_1 = this;
                    synchronized (var1_1) {
                        RVListenerWrapper.this.mListener.onRewardedVideoAdClicked(placement);
                        RVListenerWrapper.this.log("onRewardedVideoAdClicked(" + placement + ")");
                    }
                }
            });
        }
    }

    private void log(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, text, 1);
    }
}

