/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.environment.TokenConstants;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AuctionHistory;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.IronsourceObjectPublisherDataHolder;
import com.ironsource.mediationsdk.TokenDataService;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuctionDataUtils {
    private static final String TAG = "AuctionDataUtils";
    public static final String AUCTION_RESPONSE_KEY_AD_MARKUP = "adMarkup";
    public static final String AUCTION_RESPONSE_KEY_AUCTION_ID = "auctionId";
    public static final String AUCTION_RESPONSE_KEY_BURL = "burl";
    public static final String AUCTION_RESPONSE_KEY_INSTANCE = "instance";
    public static final String AUCTION_RESPONSE_KEY_IMPRESSION_DATA = "armData";
    public static final String AUCTION_RESPONSE_KEY_LURL = "lurl";
    public static final String AUCTION_RESPONSE_KEY_NOTIFICATIONS = "notifications";
    public static final String AUCTION_RESPONSE_KEY_NURL = "nurl";
    public static final String AUCTION_RESPONSE_KEY_PRICE = "price";
    public static final String AUCTION_RESPONSE_KEY_SERVER_DATA = "serverData";
    public static final String AUCTION_RESPONSE_KEY_SETTINGS = "settings";
    public static final String AUCTION_RESPONSE_KEY_WATERFALL = "waterfall";
    public static final String AUCTION_RESPONSE_KEY_GENERIC_PARAMS = "genericParams";
    public static final String AUCTION_LOSS_MACRO = "${AUCTION_LOSS}";
    public static final String AUCTION_MBR_MACRO = "${AUCTION_MBR}";
    public static final String AUCTION_PRICE_MACRO = "${AUCTION_PRICE}";
    public static final String DYNAMIC_DEMAND_SOURCE_MACRO = "${DYNAMIC_DEMAND_SOURCE}";
    public static final String INSTANCE_NAME_MACRO = "${INSTANCE}";
    public static final String INSTANCE_TYPE_MACRO = "${INSTANCE_TYPE}";
    public static final String PLACEMENT_NAME_MACRO = "${PLACEMENT_NAME}";
    private static final String AUCTION_RESPONSE_SERVER_DATA_ADM_KEY = "adMarkup";
    private static final String AUCTION_RESPONSE_SERVER_DATA_MARKET_PLACE_DEMAND_TYPE_KEY = "dynamicDemandSource";
    private static final String AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY = "params";
    private static final String ADVERTISING_ID = "advId";
    private static final String ADVERTISING_ID_TYPE = "advIdType";
    private static final String APPLICATION_KEY = "applicationKey";
    private static final String APPLICATION_USER_ID = "applicationUserId";
    private static final String APPLICATION_VERSION_NAME = "appVersion";
    private static final String AUCTION_DATA = "auctionData";
    private static final String BANNER_HEIGHT = "bannerHeight";
    private static final String BANNER_SIZE = "bannerSize";
    private static final String BANNER_WIDTH = "bannerWidth";
    private static final String BIDDING_ADDITIONAL_DATA = "biddingAdditionalData";
    private static final String BROWSER_UER_AGENT = "browserUserAgent";
    private static final String BUNDLE_ID = "bundleId";
    private static final String CLIENT_PARAMS = "clientParams";
    private static final String CLIENT_TIMESTAMP = "clientTimestamp";
    private static final String CONSENT = "consent";
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String DEVICE_HEIGHT = "deviceHeight";
    private static final String DEVICE_LANG = "deviceLang";
    private static final String DEVICE_MAKE = "deviceMake";
    private static final String DEVICE_MODEL = "deviceModel";
    private static final String DEVICE_OS = "deviceOS";
    private static final String DEVICE_OS_VERSION = "deviceOSVersion";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String DEVICE_WIDTH = "deviceWidth";
    private static final String FIRST_SESSION = "fs";
    private static final String INSTANCES = "instances";
    private static final String INSTANCE_TYPE = "instanceType";
    private static final String LIMITED_AD_TRACKING = "isLimitAdTrackingEnabled";
    private static final String META_DATA = "metaData";
    private static final String MOBILE_CARRIER = "mobileCarrier";
    private static final String PERFORMANCE = "performance";
    private static final String SDK_VERSION = "SDKVersion";
    private static final String SECURE = "secure";
    private static final String SESSION_DEPTH = "sessionDepth";
    private static final String SESSION_ID = "sessionId";
    private static final String AUID = "auid";
    private static AuctionDataUtils sInstance = new AuctionDataUtils();

    public static AuctionDataUtils getInstance() {
        return sInstance;
    }

    AuctionData getAuctionDataFromResponse(JSONObject jsonResponseObj) throws JSONException {
        AuctionData auctionDataObj = new AuctionData();
        auctionDataObj.mAuctionId = jsonResponseObj.getString(AUCTION_RESPONSE_KEY_AUCTION_ID);
        JSONObject auctionImpressionData = null;
        if (jsonResponseObj.has(AUCTION_RESPONSE_KEY_SETTINGS)) {
            JSONObject settingsJsonObject = jsonResponseObj.getJSONObject(AUCTION_RESPONSE_KEY_SETTINGS);
            auctionDataObj.mGenericNotifications = new AuctionResponseItem(settingsJsonObject);
            if (settingsJsonObject.has(AUCTION_RESPONSE_KEY_IMPRESSION_DATA)) {
                auctionImpressionData = settingsJsonObject.optJSONObject(AUCTION_RESPONSE_KEY_IMPRESSION_DATA);
            }
            if (settingsJsonObject.has(AUCTION_RESPONSE_KEY_GENERIC_PARAMS)) {
                auctionDataObj.mGenericParams = settingsJsonObject.optJSONObject(AUCTION_RESPONSE_KEY_GENERIC_PARAMS);
            }
        }
        auctionDataObj.mWaterfall = new ArrayList();
        JSONArray waterfall = jsonResponseObj.getJSONArray(AUCTION_RESPONSE_KEY_WATERFALL);
        for (int i = 0; i < waterfall.length(); ++i) {
            AuctionResponseItem item = new AuctionResponseItem(waterfall.getJSONObject(i), auctionImpressionData);
            if (!item.isValid()) {
                auctionDataObj.mErrorCode = 1002;
                auctionDataObj.mErrorMessage = "waterfall " + i;
                throw new JSONException("invalid response");
            }
            auctionDataObj.mWaterfall.add(item);
        }
        return auctionDataObj;
    }

    private String getDeviceLang() {
        String lang = Locale.getDefault().getLanguage();
        IronLog.INTERNAL.verbose("lang = " + lang);
        return lang;
    }

    private SecureFlag getAuctionSecureFlag() {
        SecureFlag secureFlag = SecureFlag.SECURE;
        if (Build.VERSION.SDK_INT >= 28) {
            secureFlag = NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() ? SecureFlag.NOT_SECURE : SecureFlag.SECURE;
        } else if (Build.VERSION.SDK_INT >= 23) {
            ApplicationInfo applicationInfo = ContextProvider.getInstance().getApplicationContext().getApplicationInfo();
            boolean usesClearTextTraffic = (applicationInfo.flags & 0x8000000) != 0;
            secureFlag = usesClearTextTraffic ? SecureFlag.NOT_SECURE : SecureFlag.SECURE;
        } else {
            secureFlag = SecureFlag.NOT_SECURE;
        }
        IronLog.INTERNAL.verbose("secureFlag = " + (Object)((Object)secureFlag));
        return secureFlag;
    }

    public AuctionResponseItem getAuctionResponseItem(String instanceName, List<AuctionResponseItem> waterfall) {
        for (int i = 0; i < waterfall.size(); ++i) {
            if (!waterfall.get(i).getInstanceName().equals(instanceName)) continue;
            return waterfall.get(i);
        }
        return null;
    }

    JSONObject enrichToken(Context context, Map<String, Object> bidders, List<String> nonBidders, AuctionHistory auctionHistory, int sessionDepth, String sessionId, AuctionSettings auctionSettings, ISBannerSize bannerSize) throws JSONException {
        JSONObject instances = new JSONObject();
        for (String instance : bidders.keySet()) {
            JSONObject bidderObject = new JSONObject();
            bidderObject.put(INSTANCE_TYPE, 2);
            bidderObject.put(BIDDING_ADDITIONAL_DATA, (Object)new JSONObject((Map)bidders.get(instance)));
            String string = auctionHistory != null ? auctionHistory.getStoredPerformanceForInstance(instance) : "";
            bidderObject.put(PERFORMANCE, (Object)string);
            instances.put(instance, (Object)bidderObject);
        }
        if (nonBidders != null) {
            for (String instance : nonBidders) {
                JSONObject nonbBidderObject = new JSONObject();
                nonbBidderObject.put(INSTANCE_TYPE, 1);
                String string = auctionHistory != null ? auctionHistory.getStoredPerformanceForInstance(instance) : "";
                nonbBidderObject.put(PERFORMANCE, (Object)string);
                instances.put(instance, (Object)nonbBidderObject);
            }
        }
        ConcurrentHashMap<String, List<String>> metaDataMap = AdapterRepository.getInstance().getMetaData();
        metaDataMap.putAll(IronsourceObjectPublisherDataHolder.getInstance().getMediationMetaData());
        JSONObject metaDataJson = new JSONObject();
        for (Map.Entry entry : metaDataMap.entrySet()) {
            String value = TextUtils.join((CharSequence)",", (Iterable)((Iterable)entry.getValue()));
            metaDataJson.put((String)entry.getKey(), (Object)value);
        }
        JSONObject clientParams = new JSONObject();
        clientParams.put(APPLICATION_USER_ID, (Object)IronSourceObject.getInstance().getIronSourceUserId());
        Boolean bl = IronSourceObject.getInstance().getConsent();
        if (bl != null) {
            clientParams.put(CONSENT, bl != false ? 1 : 0);
        }
        clientParams.put(MOBILE_CARRIER, (Object)DeviceStatus.getMobileCarrier(context));
        clientParams.put(CONNECTION_TYPE, (Object)IronSourceUtils.getConnectionType(context));
        clientParams.put(DEVICE_OS, (Object)"android");
        clientParams.put(DEVICE_WIDTH, context.getResources().getConfiguration().screenWidthDp);
        clientParams.put(DEVICE_HEIGHT, context.getResources().getConfiguration().screenHeightDp);
        clientParams.put(DEVICE_OS_VERSION, (Object)(Build.VERSION.SDK_INT + "(" + Build.VERSION.RELEASE + ")"));
        clientParams.put(DEVICE_MODEL, (Object)Build.MODEL);
        clientParams.put(DEVICE_MAKE, (Object)Build.MANUFACTURER);
        clientParams.put(BUNDLE_ID, (Object)context.getPackageName());
        clientParams.put(APPLICATION_VERSION_NAME, (Object)ApplicationContext.getPublisherApplicationVersion(context, context.getPackageName()));
        clientParams.put(CLIENT_TIMESTAMP, new Date().getTime());
        clientParams.put(FIRST_SESSION, IronSourceUtils.getFirstSession(context) ? 1 : 0);
        clientParams.put(BROWSER_UER_AGENT, (Object)IronSourceUtils.getInstance().getBrowserUserAgent());
        clientParams.put(DEVICE_TYPE, (Object)IronSourceUtils.getDeviceType(context));
        clientParams.put(DEVICE_LANG, (Object)this.getDeviceLang());
        clientParams.put(SECURE, this.getAuctionSecureFlag().ordinal());
        if (bannerSize != null) {
            clientParams.put(BANNER_SIZE, (Object)bannerSize.getDescription());
            clientParams.put(BANNER_WIDTH, bannerSize.getWidth());
            clientParams.put(BANNER_HEIGHT, bannerSize.getHeight());
        }
        String advertisingId = "";
        String advertisingIdType = "";
        String appUserId = "";
        boolean isLimitAdTrackingEnabled = false;
        try {
            String[] advertisingIdInfo = DeviceStatus.getAdvertisingIdInfo(context);
            if (advertisingIdInfo != null && advertisingIdInfo.length == 2) {
                if (!TextUtils.isEmpty((CharSequence)advertisingIdInfo[0])) {
                    advertisingId = advertisingIdInfo[0];
                }
                isLimitAdTrackingEnabled = Boolean.valueOf(advertisingIdInfo[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
            advertisingIdType = "GAID";
        } else {
            advertisingId = DeviceStatus.getOrGenerateOnceUniqueIdentifier(context);
            if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
                advertisingIdType = "UUID";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
            clientParams.put(ADVERTISING_ID, (Object)advertisingId);
            clientParams.put(ADVERTISING_ID_TYPE, (Object)advertisingIdType);
            clientParams.put(LIMITED_AD_TRACKING, (Object)(isLimitAdTrackingEnabled ? "true" : "false"));
        }
        if (!TextUtils.isEmpty((CharSequence)(appUserId = DeviceStatus.getAppUserID(context)))) {
            clientParams.put(AUID, (Object)appUserId);
        }
        JSONObject ret = new JSONObject();
        ret.put(APPLICATION_KEY, (Object)IronSourceObject.getInstance().getIronSourceAppKey());
        ret.put(SDK_VERSION, (Object)IronSourceUtils.getSDKVersion());
        ret.put(CLIENT_PARAMS, (Object)clientParams);
        ret.put(SESSION_DEPTH, sessionDepth);
        ret.put(SESSION_ID, (Object)sessionId);
        ret.put(INSTANCES, (Object)instances);
        ret.put(AUCTION_DATA, (Object)auctionSettings.getAuctionData());
        ret.put(META_DATA, (Object)metaDataJson);
        return ret;
    }

    String getModifiedKeyForToken(JSONObject token, String originalKey) {
        String modifiedKey = originalKey;
        if (token.has(originalKey)) {
            int keySuffix = 0;
            while (token.has(modifiedKey)) {
                modifiedKey = originalKey + "_" + ++keySuffix;
            }
        }
        return modifiedKey;
    }

    void mergeNewParametersToToken(JSONObject token, JSONObject newParams) {
        if (newParams == null) {
            return;
        }
        Iterator keys = newParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String keyParam = this.getModifiedKeyForToken(token, key);
            try {
                token.put(keyParam, newParams.opt(key));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    JSONObject createToken(JSONObject playerToken, JSONObject genericTokenParams, List<String> minimizedKeyParamsToInclude) {
        JSONObject ret = this.fetchNativeKeysListFromMinimizedToken(TokenDataService.getInstance().getTokenData(), minimizedKeyParamsToInclude);
        JSONObject playerMinimizedToken = this.getPlayerTokenWithMinimizedKeyParams(playerToken, minimizedKeyParamsToInclude);
        this.mergeNewParametersToToken(ret, playerMinimizedToken);
        JSONObject genericMinimizedToken = this.getGenericTokenWithMinimizedKeyParams(genericTokenParams, minimizedKeyParamsToInclude);
        this.mergeNewParametersToToken(ret, genericMinimizedToken);
        return ret;
    }

    String getMinimizedKeyParamFromMap(HashMap<String, String> keyToMinimizedKeyMap, String keyParam) {
        String uniqueKeyParam = keyParam;
        if (keyToMinimizedKeyMap.containsKey(keyParam)) {
            uniqueKeyParam = keyToMinimizedKeyMap.get(keyParam);
        }
        return uniqueKeyParam;
    }

    private JSONObject getTokenParamsAccordingToKeysList(JSONObject jsonObject, List<String> keyToInclude) {
        JSONObject ret = new JSONObject();
        if (jsonObject != null) {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    if (!keyToInclude.contains(key)) continue;
                    ret.put(key, jsonObject.opt(key));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return ret;
    }

    private JSONObject getPlayerTokenWithMinimizedKeyParams(JSONObject jsonObject, List<String> keyParamsToInclude) {
        JSONObject ret = new JSONObject();
        if (jsonObject != null) {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    String keyParam = this.getMinimizedKeyParamFromMap(TokenConstants.minimizedTokenKeyNames, key);
                    if ((!keyParamsToInclude.isEmpty() || TokenConstants.defaultNativeTokenKeysToInclude.contains(keyParam) || keyParam.startsWith("metadata_")) && !keyParamsToInclude.contains(keyParam)) continue;
                    ret.put(keyParam, jsonObject.opt(key));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return ret;
    }

    private JSONObject getGenericTokenWithMinimizedKeyParams(JSONObject jsonObject, List<String> keyParamsToInclude) {
        if (keyParamsToInclude.isEmpty()) {
            return jsonObject;
        }
        return this.getTokenParamsAccordingToKeysList(jsonObject, keyParamsToInclude);
    }

    private JSONObject fetchNativeKeysListFromMinimizedToken(JSONObject jsonObject, List<String> minimizedKeyParamsToInclude) {
        List<String> keyToInclude = minimizedKeyParamsToInclude.isEmpty() ? TokenConstants.defaultNativeTokenKeysToInclude : minimizedKeyParamsToInclude;
        return this.getTokenParamsAccordingToKeysList(jsonObject, keyToInclude);
    }

    String encryptToken(JSONObject token) {
        String body = token.toString();
        body = IronSourceAES.encode("C38FB23A402222A0C17D34A92F971D1F", body);
        return body;
    }

    JSONObject decodeAdmResponse(String adm) {
        try {
            String decryptedAdm = IronSourceAES.decode("C38FB23A402222A0C17D34A92F971D1F", adm);
            JSONObject jsonObj = new JSONObject(decryptedAdm);
            return jsonObj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String enrichNotificationURL(String url, String instanceName, int instanceType, String dynamicDemandSource, String clearancePrice, String bidRatio, String errorCode, String placementName) {
        String modifiedURL = url.replace(AUCTION_PRICE_MACRO, clearancePrice);
        modifiedURL = modifiedURL.replace(AUCTION_LOSS_MACRO, errorCode);
        modifiedURL = modifiedURL.replace(AUCTION_MBR_MACRO, bidRatio);
        modifiedURL = modifiedURL.replace(INSTANCE_NAME_MACRO, instanceName);
        modifiedURL = modifiedURL.replace(INSTANCE_TYPE_MACRO, Integer.toString(instanceType));
        modifiedURL = modifiedURL.replace(DYNAMIC_DEMAND_SOURCE_MACRO, dynamicDemandSource);
        modifiedURL = modifiedURL.replace(PLACEMENT_NAME_MACRO, placementName);
        return modifiedURL;
    }

    public String enrichNotificationURL(String url, int instanceType, AuctionResponseItem winnerInstance, String bidPrice, String errorCode, String placementName) {
        String clearancePrice = winnerInstance.getPrice();
        String bidRatio = AuctionDataUtils.getInstance().getBidRatio(clearancePrice, bidPrice);
        String instanceName = winnerInstance.getInstanceName();
        String dynamicDemandSource = AuctionDataUtils.getInstance().getDynamicDemandSourceIdFromServerData(winnerInstance.getServerData());
        return this.enrichNotificationURL(url, instanceName, instanceType, dynamicDemandSource, clearancePrice, bidRatio, errorCode, placementName);
    }

    void sendResponse(String methodName, String instanceName, String url) {
        new ImpressionHttpTask(methodName, instanceName, url).execute(new String[]{url});
    }

    public Map<String, String> getAuctionResponseServerDataParams(String serverData) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            JSONObject serverDataJson = new JSONObject(serverData);
            if (serverDataJson.has(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY)) {
                JSONObject paramsJson = serverDataJson.getJSONObject(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY);
                Iterator keys = paramsJson.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = paramsJson.get(key);
                    if (!(value instanceof String)) continue;
                    params.put(key, (String)value);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return params;
    }

    public String getAdmFromServerData(String serverData) {
        String adm = serverData;
        try {
            JSONObject serverDataJson = new JSONObject(serverData);
            if (serverDataJson.has("adMarkup")) {
                adm = serverDataJson.getString("adMarkup");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return adm;
    }

    public String getDynamicDemandSourceIdFromServerData(String serverData) {
        String dynamicDemandSourceId = "";
        try {
            JSONObject paramsJson;
            JSONObject serverDataJson = new JSONObject(serverData);
            if (serverDataJson.has(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY) && (paramsJson = serverDataJson.getJSONObject(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY)).has(AUCTION_RESPONSE_SERVER_DATA_MARKET_PLACE_DEMAND_TYPE_KEY)) {
                dynamicDemandSourceId = paramsJson.getString(AUCTION_RESPONSE_SERVER_DATA_MARKET_PLACE_DEMAND_TYPE_KEY);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return dynamicDemandSourceId;
    }

    private String getBidRatio(String clearancePrice, String bidPrice) {
        if (TextUtils.isEmpty((CharSequence)clearancePrice) || TextUtils.isEmpty((CharSequence)bidPrice)) {
            return "";
        }
        double clearancePriceDouble = Double.parseDouble(clearancePrice);
        double bidPriceDouble = Double.parseDouble(bidPrice);
        if (bidPriceDouble == 0.0) {
            return "";
        }
        double ratioPriceDouble = clearancePriceDouble / bidPriceDouble;
        double ratioPriceRounded = (double)Math.round(ratioPriceDouble * 1000.0) / 1000.0;
        return String.valueOf(ratioPriceRounded);
    }

    static class ImpressionHttpTask
    extends AsyncTask<String, Void, Boolean> {
        private static final int SERVER_REQUEST_TIMEOUT = 15000;
        private String mMethodName;
        private String mInstanceName;
        private String mURL;

        public ImpressionHttpTask(String methodName, String instanceName, String url) {
            this.mMethodName = methodName;
            this.mInstanceName = instanceName;
            this.mURL = url;
        }

        protected Boolean doInBackground(String ... objects) {
            try {
                URL url = new URL(objects[0]);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setReadTimeout(15000);
                urlConnection.setConnectTimeout(15000);
                urlConnection.connect();
                int httpResponseCode = urlConnection.getResponseCode();
                urlConnection.disconnect();
                return httpResponseCode == 200;
            }
            catch (Exception e2) {
                return false;
            }
        }

        protected void onPostExecute(Boolean isSuccess) {
            if (!isSuccess.booleanValue()) {
                JSONObject data = new JSONObject();
                try {
                    String message = this.mMethodName + ";" + this.mInstanceName + ";" + this.mURL;
                    data.put("provider", (Object)"Mediation");
                    data.put("programmatic", 1);
                    data.put("ext1", (Object)message);
                }
                catch (JSONException exception) {
                    exception.printStackTrace();
                }
                EventData event = new EventData(81320, data);
                RewardedVideoEventsManager.getInstance().log(event);
            }
        }
    }

    public static class AuctionData {
        private String mAuctionId;
        private List<AuctionResponseItem> mWaterfall;
        private AuctionResponseItem mGenericNotifications;
        private JSONObject mGenericParams;
        private int mErrorCode;
        private String mErrorMessage;

        public String getAuctionId() {
            return this.mAuctionId;
        }

        public List<AuctionResponseItem> getWaterfall() {
            return this.mWaterfall;
        }

        public AuctionResponseItem getGenericNotifications() {
            return this.mGenericNotifications;
        }

        public JSONObject getGenericParams() {
            return this.mGenericParams;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }

    private static enum SecureFlag {
        NOT_SECURE,
        SECURE;

    }
}

