/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.ironsource.environment.ANRError;
import com.ironsource.environment.ANRListener;
import com.ironsource.environment.ExceptionLog;
import com.ironsource.environment.InterruptionListener;

public class ANRHandler
extends Thread {
    private static final int DEFAULT_NUM_TRIES = 1;
    private static final ANRListener DEFAULT_ANR_LISTENER = new ANRListener(){

        @Override
        public void onAppNotResponding(ANRError error) {
            throw error;
        }

        @Override
        public void onANRHandlerDogGivingUp() {
            throw new RuntimeException("ANRHandler has given up");
        }
    };
    private static final InterruptionListener DEFAULT_INTERRUPTION_LISTENER = new InterruptionListener(){

        @Override
        public void onInterrupted(InterruptedException exception) {
            Log.w((String)"ANRHandler", (String)("Interrupted: " + exception.getMessage()));
        }
    };
    private ANRListener _anrListener = DEFAULT_ANR_LISTENER;
    private InterruptionListener _interruptionListener = DEFAULT_INTERRUPTION_LISTENER;
    private final Handler _uiHandler = new Handler(Looper.getMainLooper());
    private final int _timeoutInterval;
    private String _namePrefix = "";
    private boolean _logThreadsWithoutStackTrace = false;
    private boolean _ignoreDebugger = false;
    private volatile int _tick = 0;
    private int tries = 1;
    private int triedCount = 0;
    private final Runnable _ticker = new Runnable(){

        @Override
        public void run() {
            ANRHandler.this._tick = (ANRHandler.this._tick + 1) % Integer.MAX_VALUE;
        }
    };

    public void setTries(int tries) {
        this.tries = tries;
    }

    public int getTries() {
        return this.tries;
    }

    public int getTriedCount() {
        return this.triedCount;
    }

    public ANRHandler(int timeoutInterval) {
        this._timeoutInterval = timeoutInterval;
    }

    public ANRHandler setANRListener(ANRListener listener) {
        this._anrListener = listener == null ? DEFAULT_ANR_LISTENER : listener;
        return this;
    }

    public ANRHandler setInterruptionListener(InterruptionListener listener) {
        this._interruptionListener = listener == null ? DEFAULT_INTERRUPTION_LISTENER : listener;
        return this;
    }

    public ANRHandler setReportThreadNamePrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this._namePrefix = prefix;
        return this;
    }

    public ANRHandler setReportMainThreadOnly() {
        this._namePrefix = null;
        return this;
    }

    public ANRHandler setLogThreadsWithoutStackTrace(boolean logThreadsWithoutStackTrace) {
        this._logThreadsWithoutStackTrace = logThreadsWithoutStackTrace;
        return this;
    }

    public ANRHandler setIgnoreDebugger(boolean ignoreDebugger) {
        this._ignoreDebugger = ignoreDebugger;
        return this;
    }

    @Override
    public void run() {
        this.setName("|ANR-ANRHandler|");
        int lastIgnored = -1;
        while (!this.isInterrupted() && this.triedCount < this.tries) {
            int lastTick = this._tick;
            this._uiHandler.post(this._ticker);
            try {
                Thread.sleep(this._timeoutInterval);
            }
            catch (InterruptedException e2) {
                this._interruptionListener.onInterrupted(e2);
                return;
            }
            if (this._tick == lastTick) {
                if (!this._ignoreDebugger && Debug.isDebuggerConnected()) {
                    if (this._tick != lastIgnored) {
                        Log.w((String)"ANRHandler", (String)"An ANR was detected but ignored because the debugger is connected (you can prevent this with setIgnoreDebugger(true))");
                    }
                    lastIgnored = this._tick;
                    continue;
                }
                ANRError error = this._namePrefix != null ? ANRError.New(this._namePrefix, this._logThreadsWithoutStackTrace) : ANRError.NewMainOnly();
                ++this.triedCount;
                this._anrListener.onAppNotResponding(error);
                ExceptionLog ex = new ExceptionLog(error.toString(), String.valueOf(System.currentTimeMillis()));
                ex.Save();
                continue;
            }
            this.triedCount = 0;
        }
        if (this.triedCount >= this.tries) {
            this._anrListener.onANRHandlerDogGivingUp();
        }
    }
}

