/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.service.Connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.ironsource.network.ConnectivityUtils;
import com.ironsource.sdk.service.Connectivity.IConnectivity;
import com.ironsource.sdk.service.Connectivity.IConnectivityStatus;
import org.json.JSONObject;

public class BroadcastReceiverStrategy
implements IConnectivity {
    private final IConnectivityStatus mNetworkState;
    private BroadcastReceiver mConnectionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String networkType = ConnectivityUtils.getConnectionType(context);
            if (networkType.equals("none")) {
                BroadcastReceiverStrategy.this.mNetworkState.onDisconnected();
            } else {
                BroadcastReceiverStrategy.this.mNetworkState.onConnected(networkType, new JSONObject());
            }
        }
    };

    public BroadcastReceiverStrategy(IConnectivityStatus networkState) {
        this.mNetworkState = networkState;
    }

    @Override
    public void startListenToNetworkChanges(Context context) {
        try {
            context.registerReceiver(this.mConnectionReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void stopListenToNetworkChanges(Context context) {
        try {
            context.unregisterReceiver(this.mConnectionReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e1) {
            Log.e((String)"ContentValues", (String)("unregisterConnectionReceiver - " + e1));
        }
    }

    @Override
    public JSONObject getConnectivityInfo(Context context) {
        return new JSONObject();
    }

    @Override
    public void release() {
        this.mConnectionReceiver = null;
    }
}

