/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.text.TextUtils;
import com.ironsource.network.ConnectivityService;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectivityUtils {
    public static String getConnectionType(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ConnectivityUtils.getConnectionType(ConnectivityUtils.getActiveNetwork(context), context);
        }
        return ConnectivityUtils.getConnectionTypePreMOSVersion(context);
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getConnectionType(Network network, Context context) {
        if (context == null) {
            return "none";
        }
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        String networkType = "none";
        try {
            if (network != null && manager != null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                    if (capabilities == null) {
                        return ConnectivityUtils.getConnectionTypePreMOSVersion(context);
                    }
                    networkType = capabilities.hasTransport(1) ? "wifi" : (capabilities.hasTransport(0) ? "3g" : ConnectivityUtils.getConnectionTypePreMOSVersion(context));
                } else {
                    networkType = ConnectivityUtils.getConnectionTypePreMOSVersion(context);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return networkType;
    }

    @SuppressLint(value={"MissingPermission"})
    public static Network getActiveNetwork(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT < 23 || cm == null) {
            return null;
        }
        return cm.getActiveNetwork();
    }

    @SuppressLint(value={"MissingPermission"})
    public static JSONObject getNetworkData(Context context, Network network) {
        if (context == null) {
            return new JSONObject();
        }
        JSONObject data = new JSONObject();
        if (Build.VERSION.SDK_INT >= 23 && network != null) {
            try {
                NetworkCapabilities capabilities;
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                if (cm != null && (capabilities = cm.getNetworkCapabilities(network)) != null) {
                    data.put("networkCapabilities", (Object)capabilities.toString());
                    data.put("downloadSpeed", capabilities.getLinkDownstreamBandwidthKbps());
                    data.put("uploadSpeed", capabilities.getLinkUpstreamBandwidthKbps());
                    data.put("hasVPN", ConnectivityUtils.hasVPN(context));
                }
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        return data;
    }

    private static String getConnectionTypePreMOSVersion(Context context) {
        String networkType = ConnectivityService.getConnectionType(context);
        if (TextUtils.isEmpty((CharSequence)networkType)) {
            networkType = "none";
        }
        return networkType;
    }

    public static boolean hasVPN(Context context) {
        return ConnectivityUtils.getNetworkTransport(context, ConnectivityUtils.getActiveNetwork(context)).equals("vpn");
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getNetworkTransport(Context context, Network network) {
        String emptyTransport = "";
        if (Build.VERSION.SDK_INT < 23 || network == null || context == null) {
            return emptyTransport;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm != null) {
                NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
                if (capabilities == null) {
                    return emptyTransport;
                }
                if (capabilities.hasTransport(1)) {
                    return "wifi";
                }
                if (capabilities.hasTransport(0)) {
                    return "cellular";
                }
                if (capabilities.hasTransport(4)) {
                    return "vpn";
                }
                if (capabilities.hasTransport(3)) {
                    return "ethernet";
                }
                if (capabilities.hasTransport(5)) {
                    return "wifiAware";
                }
                if (capabilities.hasTransport(6)) {
                    return "lowpan";
                }
                if (capabilities.hasTransport(2)) {
                    return "bluetooth";
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return emptyTransport;
    }
}

