/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.impressionData;

import android.content.Context;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceAdvId;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.model.ApplicationConfigurations;
import com.ironsource.mediationsdk.model.Configurations;
import com.ironsource.mediationsdk.server.HttpFunctions;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.OnMediationInitializationListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0016J*\u0010\f\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ironsource/mediationsdk/impressionData/ExternalImpressionDataHandler;", "Lcom/ironsource/mediationsdk/utils/OnMediationInitializationListener;", "()V", "externalArmEventsUrl", "", "isExternalArmEventsEnabled", "", "buildClientParamsForRequest", "Lorg/json/JSONObject;", "onInitFailed", "", "reason", "onInitSuccess", "adUnits", "", "Lcom/ironsource/mediationsdk/IronSource$AD_UNIT;", "revived", "configurations", "Lcom/ironsource/mediationsdk/model/Configurations;", "onStillInProgressAfter15Secs", "setAdRevenueData", "dataSource", "impressionData", "mediationsdk_release"})
public final class ExternalImpressionDataHandler
implements OnMediationInitializationListener {
    private boolean isExternalArmEventsEnabled = true;
    private String externalArmEventsUrl = "http://outcome-arm-ext-med-ext.sonic-us.supersonicads.com/aemData";

    public final void setAdRevenueData(@NotNull String dataSource, @NotNull JSONObject impressionData) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)impressionData, (String)"impressionData");
        if (!this.isExternalArmEventsEnabled) {
            IronLog.INTERNAL.info("disabled from server");
            return;
        }
        try {
            JSONObject sdkDataJson = this.buildClientParamsForRequest();
            JSONObject externalImpressionData = new JSONObject();
            externalImpressionData.putOpt("externalMediationSource", (Object)dataSource);
            externalImpressionData.putOpt("externalMediationData", (Object)impressionData);
            externalImpressionData.putOpt("clientParams", (Object)sdkDataJson);
            IronLog.API.info("impressionData: " + externalImpressionData);
            boolean requestSucceeded = HttpFunctions.sendPostRequest(this.externalArmEventsUrl, externalImpressionData.toString());
            if (!requestSucceeded) {
                IronLog.API.error("failed to send impression data");
                return;
            }
        }
        catch (Exception e2) {
            IronLog.API.error("exception " + e2.getMessage() + " sending impression data");
            e2.printStackTrace();
        }
    }

    @Override
    public void onInitSuccess(@Nullable List<IronSource.AD_UNIT> adUnits, boolean revived, @Nullable Configurations configurations) {
        block0: {
            Configurations configurations2 = configurations;
            if (configurations2 == null) break block0;
            Configurations configurations3 = configurations2;
            boolean bl = false;
            boolean bl2 = false;
            Configurations $this$run = configurations3;
            boolean bl3 = false;
            ApplicationConfigurations applicationConfigurations = $this$run.getApplicationConfigurations();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationConfigurations, (String)"applicationConfigurations");
            this.isExternalArmEventsEnabled = applicationConfigurations.getGeneralSettings().isExternalArmEventsEnabled();
            ApplicationConfigurations applicationConfigurations2 = $this$run.getApplicationConfigurations();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationConfigurations2, (String)"applicationConfigurations");
            this.externalArmEventsUrl = applicationConfigurations2.getGeneralSettings().getExternalArmEventsUrl();
        }
    }

    @Override
    public void onInitFailed(@Nullable String reason) {
    }

    @Override
    public void onStillInProgressAfter15Secs() {
    }

    private final JSONObject buildClientParamsForRequest() {
        JSONObject clientParams = new JSONObject();
        clientParams.put("deviceOS", (Object)"android");
        ContextProvider contextProvider = ContextProvider.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)contextProvider, (String)"ContextProvider.getInstance()");
        Context context = contextProvider.getApplicationContext();
        if (context != null) {
            clientParams.put("deviceType", (Object)IronSourceUtils.getDeviceType(context));
            IronSourceAdvId ironSourceAdvId = IronSourceUtils.getIronSourceAdvId(context);
            if (ironSourceAdvId != null) {
                clientParams.put("advId", (Object)ironSourceAdvId.getAdvId());
                clientParams.put("advIdType", (Object)ironSourceAdvId.getAdvIdType());
            }
        }
        IronSourceObject ironSourceObject = IronSourceObject.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)ironSourceObject, (String)"IronSourceObject.getInstance()");
        String applicationKey = ironSourceObject.getIronSourceAppKey();
        if (applicationKey != null) {
            clientParams.put("applicationKey", (Object)applicationKey);
        }
        return clientParams;
    }
}

