/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.IronSourceSegment;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.logger.LogListener;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.OfferwallListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.ironsource.mediationsdk.sdk.SegmentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public abstract class IronSource {
    public static final String DataSource_MOPUB = "MoPub";

    public static void setUserId(String userId) {
        IronSourceObject.getInstance().setIronSourceUserId(userId, true);
    }

    public static void init(Activity activity, String appKey) {
        IronSource.init(activity, appKey, null);
    }

    public static void init(Activity activity, String appKey, AD_UNIT ... adUnits) {
        IronSourceObject.getInstance().init((Context)activity, appKey, false, null, adUnits);
    }

    @Deprecated
    public static void initISDemandOnly(Activity activity, String appKey, AD_UNIT ... adUnits) {
        IronSourceObject.getInstance().initISDemandOnly((Context)activity, appKey, null, adUnits);
    }

    public static void initISDemandOnly(@NotNull Context context, String appKey, AD_UNIT ... adUnits) {
        IronSourceObject.getInstance().initISDemandOnly(context, appKey, null, adUnits);
    }

    public static void onResume(Activity activity) {
        IronSourceObject.getInstance().onResume(activity);
    }

    public static void onPause(Activity activity) {
        IronSourceObject.getInstance().onPause(activity);
    }

    public static void setMediationSegment(String segment) {
        IronSourceObject.getInstance().setMediationSegment(segment);
    }

    public static void setSegment(IronSourceSegment segment) {
        IronSourceObject.getInstance().setSegment(segment);
    }

    public static boolean setDynamicUserId(String dynamicUserId) {
        return IronSourceObject.getInstance().setDynamicUserId(dynamicUserId);
    }

    public static void setMediationType(String mediationType) {
        IronSourceObject.getInstance().setMediationType(mediationType);
    }

    public static void removeRewardedVideoListener() {
        IronSourceObject.getInstance().removeRewardedVideoListener();
    }

    public static void removeInterstitialListener() {
        IronSourceObject.getInstance().removeInterstitialListener();
    }

    public static void removeOfferwallListener() {
        IronSourceObject.getInstance().removeOfferwallListener();
    }

    public static InterstitialPlacement getInterstitialPlacementInfo(String placementName) {
        return IronSourceObject.getInstance().getInterstitialPlacementInfo(placementName);
    }

    public static Placement getRewardedVideoPlacementInfo(String placementName) {
        return IronSourceObject.getInstance().getRewardedVideoPlacementInfo(placementName);
    }

    public static String getAdvertiserId(Context context) {
        return IronSourceObject.getInstance().getAdvertiserId(context);
    }

    public static void shouldTrackNetworkState(Context context, boolean track) {
        IronSourceObject.getInstance().shouldTrackNetworkState(context, track);
    }

    public static void setLogListener(LogListener listener) {
        IronSourceObject.getInstance().setLogListener(listener);
    }

    public static void setAdaptersDebug(boolean enabled) {
        IronSourceObject.getInstance().setAdaptersDebug(enabled);
    }

    public static synchronized String getISDemandOnlyBiddingData() {
        return IronSourceObject.getInstance().getISDemandOnlyBiddingData();
    }

    public static void showRewardedVideo() {
        IronSourceObject.getInstance().showRewardedVideo();
    }

    public static void showRewardedVideo(String placementName) {
        IronSourceObject.getInstance().showRewardedVideo(placementName);
    }

    public static boolean isRewardedVideoAvailable() {
        return IronSourceObject.getInstance().isRewardedVideoAvailable();
    }

    public static void setRewardedVideoListener(RewardedVideoListener listener) {
        IronSourceObject.getInstance().setRewardedVideoListener(listener);
    }

    public static boolean isRewardedVideoPlacementCapped(String placementName) {
        return IronSourceObject.getInstance().isRewardedVideoPlacementCapped(placementName);
    }

    public static void setRewardedVideoServerParameters(Map<String, String> params) {
        IronSourceObject.getInstance().setRewardedVideoServerParameters(params);
    }

    public static void clearRewardedVideoServerParameters() {
        IronSourceObject.getInstance().clearRewardedVideoServerParameters();
    }

    @Deprecated
    public static void loadISDemandOnlyRewardedVideo(String instanceId) {
        IronSourceObject.getInstance().loadISDemandOnlyRewardedVideo(null, instanceId, null);
    }

    @Deprecated
    public static void loadISDemandOnlyRewardedVideoWithAdm(String instanceId, String adm) {
        IronSourceObject.getInstance().loadISDemandOnlyRewardedVideoWithAdm(null, instanceId, adm);
    }

    public static void loadISDemandOnlyRewardedVideo(@NotNull Activity activity, String instanceId) {
        IronSourceObject.getInstance().loadISDemandOnlyRewardedVideo(activity, instanceId, null);
    }

    public static void loadISDemandOnlyRewardedVideoWithAdm(@NotNull Activity activity, String instanceId, String adm) {
        IronSourceObject.getInstance().loadISDemandOnlyRewardedVideoWithAdm(activity, instanceId, adm);
    }

    public static void showISDemandOnlyRewardedVideo(String instanceId) {
        IronSourceObject.getInstance().showDemandOnlyRewardedVideo(instanceId);
    }

    public static boolean isISDemandOnlyRewardedVideoAvailable(String instanceId) {
        return IronSourceObject.getInstance().isDemandOnlyRewardedVideoAvailable(instanceId);
    }

    public static void setISDemandOnlyRewardedVideoListener(ISDemandOnlyRewardedVideoListener listener) {
        IronSourceObject.getInstance().setISDemandOnlyRewardedVideoListener(listener);
    }

    public static void loadInterstitial() {
        IronSourceObject.getInstance().loadInterstitial();
    }

    public static void showInterstitial() {
        IronSourceObject.getInstance().showInterstitial();
    }

    public static void showInterstitial(String placementName) {
        IronSourceObject.getInstance().showInterstitial(placementName);
    }

    public static boolean isInterstitialReady() {
        return IronSourceObject.getInstance().isInterstitialReady();
    }

    public static void setInterstitialListener(InterstitialListener listener) {
        IronSourceObject.getInstance().setInterstitialListener(listener);
    }

    public static boolean isInterstitialPlacementCapped(String placementName) {
        return IronSourceObject.getInstance().isInterstitialPlacementCapped(placementName);
    }

    @Deprecated
    public static void loadISDemandOnlyInterstitial(String instanceId) {
        IronSourceObject.getInstance().loadDemandOnlyInterstitial(null, instanceId, null);
    }

    @Deprecated
    public static void loadISDemandOnlyInterstitialWithAdm(String instanceId, String adm) {
        IronSourceObject.getInstance().loadISDemandOnlyInterstitialWithAdm(null, instanceId, adm);
    }

    public static void loadISDemandOnlyInterstitial(@NotNull Activity activity, String instanceId) {
        IronSourceObject.getInstance().loadDemandOnlyInterstitial(activity, instanceId, null);
    }

    public static void loadISDemandOnlyInterstitialWithAdm(@NotNull Activity activity, String instanceId, String adm) {
        IronSourceObject.getInstance().loadISDemandOnlyInterstitialWithAdm(activity, instanceId, adm);
    }

    public static void showISDemandOnlyInterstitial(String instanceId) {
        IronSourceObject.getInstance().showDemandOnlyInterstitial(instanceId);
    }

    public static boolean isISDemandOnlyInterstitialReady(String instanceId) {
        return IronSourceObject.getInstance().isDemandOnlyInterstitialReady(instanceId);
    }

    public static void setISDemandOnlyInterstitialListener(ISDemandOnlyInterstitialListener listener) {
        IronSourceObject.getInstance().setISDemandOnlyInterstitialListener(listener);
    }

    public static void showOfferwall() {
        IronSourceObject.getInstance().showOfferwall();
    }

    public static void showOfferwall(String placementName) {
        IronSourceObject.getInstance().showOfferwall(placementName);
    }

    public static boolean isOfferwallAvailable() {
        return IronSourceObject.getInstance().isOfferwallAvailable();
    }

    public static void getOfferwallCredits() {
        IronSourceObject.getInstance().getOfferwallCredits();
    }

    public static void setOfferwallListener(OfferwallListener listener) {
        IronSourceObject.getInstance().setOfferwallListener(listener);
    }

    public static IronSourceBannerLayout createBanner(Activity activity, ISBannerSize size) {
        return IronSourceObject.getInstance().createBanner(activity, size);
    }

    public static void loadBanner(IronSourceBannerLayout banner) {
        IronSourceObject.getInstance().loadBanner(banner);
    }

    public static void loadBanner(IronSourceBannerLayout banner, String placementName) {
        IronSourceObject.getInstance().loadBanner(banner, placementName);
    }

    public static void destroyBanner(IronSourceBannerLayout banner) {
        IronSourceObject.getInstance().destroyBanner(banner);
    }

    public static boolean isBannerPlacementCapped(String placementName) {
        return IronSourceObject.getInstance().isBannerPlacementCapped(placementName);
    }

    public static void setSegmentListener(SegmentListener listener) {
        IronSourceObject.getInstance().setSegmentListener(listener);
    }

    public static void setConsent(boolean consent) {
        IronSourceObject.getInstance().setConsent(consent);
    }

    public static void setMetaData(String key, String value) {
        ArrayList<String> singleValueSet = new ArrayList<String>();
        singleValueSet.add(value);
        IronSourceObject.getInstance().setMetaData(key, singleValueSet);
    }

    public static void setMetaData(String key, List<String> values) {
        IronSourceObject.getInstance().setMetaData(key, values);
    }

    @Deprecated
    public static void setImpressionDataListener(@NotNull ImpressionDataListener listener) {
        IronSourceObject.getInstance().removeAllImpressionDataListeners();
        IronSource.addImpressionDataListener(listener);
    }

    public static void addImpressionDataListener(@NotNull ImpressionDataListener listener) {
        IronSourceObject.getInstance().addImpressionDataListener(listener);
    }

    public static void removeImpressionDataListener(@NotNull ImpressionDataListener listener) {
        IronSourceObject.getInstance().removeImpressionDataListener(listener);
    }

    public static void setAdRevenueData(@NotNull String dataSource, @NotNull JSONObject impressionData) {
        IronSourceObject.getInstance().setAdRevenueData(dataSource, impressionData);
    }

    public static enum AD_UNIT {
        REWARDED_VIDEO("rewardedVideo"),
        INTERSTITIAL("interstitial"),
        OFFERWALL("offerwall"),
        BANNER("banner");

        private String mValue;

        private AD_UNIT(String value) {
            this.mValue = value;
        }

        public String toString() {
            return this.mValue;
        }
    }
}

