/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.ironsource.lifecycle.IronsourceLifecycleFragment;
import com.ironsource.lifecycle.IronsourceLifecycleListener;
import com.ironsource.lifecycle.IronsourceLifecycleProvider;
import com.ironsource.lifecycle.IronsourceLifecycleState;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronsourceLifecycleManager
implements Application.ActivityLifecycleCallbacks {
    private String TAG = "IronsourceLifecycleManager";
    private static IronsourceLifecycleManager sInstance = new IronsourceLifecycleManager();
    private static AtomicBoolean sInitialized = new AtomicBoolean(false);
    private Handler mHandler;
    static final long TIMEOUT_MS = 700L;
    private int mStartedCounter = 0;
    private int mResumedCounter = 0;
    private boolean mPauseSent = true;
    private boolean mStopSent = true;
    private IronsourceLifecycleState mState = IronsourceLifecycleState.NONE;
    private List<IronsourceLifecycleListener> mObservers = new CopyOnWriteArrayList<IronsourceLifecycleListener>();
    private Runnable mDelayedPauseRunnable = new Runnable(){

        @Override
        public void run() {
            IronsourceLifecycleManager.this.dispatchPauseIfNeeded();
            IronsourceLifecycleManager.this.dispatchStopIfNeeded();
        }
    };
    private IronsourceLifecycleFragment.ActivityInitializationListener mInitializationListener = new IronsourceLifecycleFragment.ActivityInitializationListener(){

        @Override
        public void onCreate(Activity activity) {
        }

        @Override
        public void onStart(Activity activity) {
            IronsourceLifecycleManager.this.activityStarted(activity);
        }

        @Override
        public void onResume(Activity activity) {
            IronsourceLifecycleManager.this.activityResumed(activity);
        }
    };

    public static IronsourceLifecycleManager getInstance() {
        return sInstance;
    }

    public void addObserver(IronsourceLifecycleListener observer) {
        if (IronsourceLifecycleProvider.isCreated() && observer != null && !this.mObservers.contains(observer)) {
            this.mObservers.add(observer);
        }
    }

    public void removeObserver(IronsourceLifecycleListener observer) {
        if (this.mObservers.contains(observer)) {
            this.mObservers.remove(observer);
        }
    }

    public IronsourceLifecycleState getCurrentState() {
        return this.mState;
    }

    public boolean isAppInBackground() {
        return this.mState == IronsourceLifecycleState.STOPPED;
    }

    void init(Context context) {
        if (sInitialized.compareAndSet(false, true)) {
            this.mHandler = new Handler(Looper.getMainLooper());
            Application app = (Application)context.getApplicationContext();
            if (app != null) {
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        IronsourceLifecycleFragment.injectIfNeededIn(activity);
        IronsourceLifecycleFragment myLifecycleFragment = IronsourceLifecycleFragment.get(activity);
        if (myLifecycleFragment != null) {
            myLifecycleFragment.setProcessListener(this.mInitializationListener);
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        this.activityPaused(activity);
    }

    public void onActivityStopped(Activity activity) {
        this.activityStopped(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    void activityStarted(Activity activity) {
        ++this.mStartedCounter;
        if (this.mStartedCounter == 1 && this.mStopSent) {
            for (IronsourceLifecycleListener listener : this.mObservers) {
                listener.appStarted();
            }
            this.mStopSent = false;
            this.mState = IronsourceLifecycleState.STARTED;
        }
    }

    void activityResumed(Activity activity) {
        ++this.mResumedCounter;
        if (this.mResumedCounter == 1) {
            if (this.mPauseSent) {
                for (IronsourceLifecycleListener listener : this.mObservers) {
                    listener.appResumed();
                }
                this.mPauseSent = false;
                this.mState = IronsourceLifecycleState.RESUMED;
            } else {
                this.mHandler.removeCallbacks(this.mDelayedPauseRunnable);
            }
        }
    }

    void activityPaused(Activity activity) {
        --this.mResumedCounter;
        if (this.mResumedCounter == 0) {
            this.mHandler.postDelayed(this.mDelayedPauseRunnable, 700L);
        }
    }

    void activityStopped(Activity activity) {
        --this.mStartedCounter;
        this.dispatchStopIfNeeded();
    }

    private void dispatchPauseIfNeeded() {
        if (this.mResumedCounter == 0) {
            this.mPauseSent = true;
            for (IronsourceLifecycleListener listener : this.mObservers) {
                listener.appPaused();
            }
            this.mState = IronsourceLifecycleState.PAUSED;
        }
    }

    private void dispatchStopIfNeeded() {
        if (this.mStartedCounter == 0 && this.mPauseSent) {
            for (IronsourceLifecycleListener listener : this.mObservers) {
                listener.appStopped();
            }
            this.mStopSent = true;
            this.mState = IronsourceLifecycleState.STOPPED;
        }
    }
}

