/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.media.AudioManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.ironsource.environment.IronSourceSharedPreferencesUtilities;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

public class DeviceStatus {
    private static final String DEVICE_OS = "android";
    private static final String GOOGLE_PLAY_SERVICES_CLASS_NAME = "com.google.android.gms.ads.identifier.AdvertisingIdClient";
    private static final String GOOGLE_PLAY_SERVICES_GET_AID_INFO_METHOD_NAME = "getAdvertisingIdInfo";
    private static final String GOOGLE_PLAY_SERVICES_GET_AID_METHOD_NAME = "getId";
    private static final String GOOGLE_PLAY_SERVICES_IS_LIMITED_AD_TRACKING_METHOD_NAME = "isLimitAdTrackingEnabled";
    private static final String MEDIATION_SHARED_PREFS = "Mediation_Shared_Preferences";
    private static final String SUPERSONIC_SHARED_PREFS = "supersonic_shared_preferen";
    public static final String UUID_ENABLED = "uuidEnabled";
    private static final String CACHED_UUID_KEY = "cachedUUID";
    private static final String AUID_KEY = "auid";
    private static String uniqueId = null;
    private static String applicationUserId = null;

    public static long getDeviceLocalTime() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        Date currentLocalTime = calendar.getTime();
        return currentLocalTime.getTime();
    }

    public static int getDeviceTimeZoneOffsetInMinutes() {
        return -(TimeZone.getDefault().getOffset(DeviceStatus.getDeviceLocalTime()) / 60000);
    }

    public static String getDeviceTimeZoneId() {
        String timeZoneId = TimeZone.getDefault().getID();
        return timeZoneId != null ? timeZoneId : "";
    }

    public static String[] getAdvertisingIdInfo(Context c2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> mAdvertisingIdClientClass = Class.forName(GOOGLE_PLAY_SERVICES_CLASS_NAME);
        Method getAdvertisingIdInfoMethod = mAdvertisingIdClientClass.getMethod(GOOGLE_PLAY_SERVICES_GET_AID_INFO_METHOD_NAME, Context.class);
        Object mInfoClass = getAdvertisingIdInfoMethod.invoke(mAdvertisingIdClientClass, c2);
        Method getIdMethod = mInfoClass.getClass().getMethod(GOOGLE_PLAY_SERVICES_GET_AID_METHOD_NAME, new Class[0]);
        Method isLimitAdTrackingEnabledMethod = mInfoClass.getClass().getMethod(GOOGLE_PLAY_SERVICES_IS_LIMITED_AD_TRACKING_METHOD_NAME, new Class[0]);
        String advertisingId = getIdMethod.invoke(mInfoClass, new Object[0]).toString();
        boolean isLimitedTrackingEnabled = (Boolean)isLimitAdTrackingEnabledMethod.invoke(mInfoClass, new Object[0]);
        return new String[]{advertisingId, "" + isLimitedTrackingEnabled};
    }

    public static String getDeviceLanguage(Context c2) throws Exception {
        return c2.getResources().getConfiguration().locale.getLanguage();
    }

    public static String getDeviceLocalCountry(Context c2) throws Exception {
        return c2.getResources().getConfiguration().locale.getCountry();
    }

    public static boolean getIsTablet(Context c2) {
        WindowManager windowManager = (WindowManager)c2.getSystemService("window");
        if (windowManager != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            float dpWidth = (float)displayMetrics.widthPixels / displayMetrics.density;
            return dpWidth >= 600.0f;
        }
        return false;
    }

    private static long getFreeStorageInBytes(File f2) {
        long SIZE_KB = 1024L;
        long SIZE_MB = 0x100000L;
        StatFs stat = new StatFs(f2.getPath());
        long res = Build.VERSION.SDK_INT < 19 ? (long)stat.getAvailableBlocks() * (long)stat.getBlockSize() : stat.getAvailableBlocksLong() * stat.getBlockSizeLong();
        return res / 0x100000L;
    }

    public static boolean isExternalMemoryAvailableWritable() {
        return "mounted".equals(Environment.getExternalStorageState()) && Environment.isExternalStorageRemovable();
    }

    public static long getTotalDeviceRAM(Context c2) {
        ActivityManager activityManager = (ActivityManager)c2.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        if (activityManager != null) {
            activityManager.getMemoryInfo(memoryInfo);
            if (Build.VERSION.SDK_INT >= 16) {
                return memoryInfo.totalMem;
            }
        }
        return -1L;
    }

    public static boolean isCharging(Context c2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = c2.registerReceiver(null, intentFilter);
        int status = -1;
        if (batteryStatus != null) {
            status = batteryStatus.getIntExtra("status", -1);
        }
        return status == 2 || status == 5;
    }

    public static int chargingType(Context c2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = c2.registerReceiver(null, intentFilter);
        if (batteryStatus != null) {
            return batteryStatus.getIntExtra("plugged", -1);
        }
        return -1;
    }

    public static boolean isAirplaneMode(Context c2) {
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                return Settings.System.getInt((ContentResolver)c2.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return false;
    }

    public static boolean isStayOnWhenPluggedIn(Context c2) {
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                return Settings.Global.getInt((ContentResolver)c2.getContentResolver(), (String)"stay_on_while_plugged_in", (int)0) != 0;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return false;
    }

    public static String getMobileCarrier(Context c2) {
        if (c2 != null) {
            TelephonyManager tm = (TelephonyManager)c2.getSystemService("phone");
            return tm != null ? tm.getNetworkOperatorName() : "";
        }
        return "";
    }

    public static String getMobileCountryCodeISO(Context c2) {
        if (c2 != null) {
            TelephonyManager tm = (TelephonyManager)c2.getSystemService("phone");
            return tm != null ? tm.getNetworkCountryIso() : "";
        }
        return "";
    }

    public static String getAndroidOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getAndroidAPIVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceOEM() {
        return Build.MANUFACTURER;
    }

    public static String getDeviceOs() {
        return DEVICE_OS;
    }

    public static boolean isRootedDevice() {
        return DeviceStatus.findBinary("su");
    }

    private static boolean findBinary(String binaryName) {
        boolean found = false;
        try {
            String[] paths;
            for (String path : paths = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
                File file = new File(path + binaryName);
                if (!file.exists()) continue;
                found = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return found;
    }

    public static boolean isRTL(Context context) {
        Configuration config = context.getResources().getConfiguration();
        return Build.VERSION.SDK_INT >= 17 && config.getLayoutDirection() == 1;
    }

    public static int getApplicationRotation(Context context) {
        Display defaultDisplay = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        return defaultDisplay.getRotation();
    }

    public static float getSystemVolumePercent(Context context) {
        AudioManager audio = (AudioManager)context.getSystemService("audio");
        float res = -1.0f;
        try {
            res = (float)audio.getStreamVolume(3) / (float)audio.getStreamMaxVolume(3);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return res;
    }

    public static int getDisplayWidth() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return displayMetrics.widthPixels;
    }

    public static int getDisplayHeight() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return displayMetrics.heightPixels;
    }

    public static int getDeviceWidth() {
        return DeviceStatus.getDisplayWidth();
    }

    public static int getDeviceHeight() {
        return DeviceStatus.getDisplayHeight();
    }

    public static int getActivityRequestedOrientation(Context activity) {
        return activity instanceof Activity ? ((Activity)activity).getRequestedOrientation() : -1;
    }

    public static int getDeviceDefaultOrientation(Context context) {
        int rotation = DeviceStatus.getApplicationRotation(context);
        int orientation = DeviceStatus.getDeviceOrientation(context);
        if ((rotation == 0 || rotation == 2) && orientation == 2 || (rotation == 1 || rotation == 3) && orientation == 1) {
            return 2;
        }
        return 1;
    }

    public static int getDeviceOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public static float getDeviceDensity() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return displayMetrics.density;
    }

    public static List<ApplicationInfo> getInstalledApplications(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.getInstalledApplications(0);
    }

    public static boolean isDeviceOrientationLocked(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"accelerometer_rotation", (int)0) != 1;
    }

    public static File getExternalCacheDir(Context context) {
        return context.getExternalCacheDir();
    }

    public static String getInternalCacheDirPath(Context context) {
        String path = null;
        File internalFile = context.getCacheDir();
        if (internalFile != null) {
            path = internalFile.getPath();
        }
        return path;
    }

    public static long getAvailableInternalMemorySizeInMegaBytes() {
        File path = Environment.getDataDirectory();
        long res = DeviceStatus.getFreeStorageInBytes(path);
        return res;
    }

    public static long getAvailableMemorySizeInMegaBytes(String path) {
        return DeviceStatus.getFreeStorageInBytes(new File(path));
    }

    public static long getAvailableExternalMemorySizeInMegaBytes() {
        long res = 0L;
        if (DeviceStatus.isExternalMemoryAvailableWritable()) {
            File path = Environment.getExternalStorageDirectory();
            res = DeviceStatus.getFreeStorageInBytes(path);
        }
        return res;
    }

    @TargetApi(value=19)
    public static boolean isImmersiveSupported(Activity activity) {
        int uiOptions = activity.getWindow().getDecorView().getSystemUiVisibility();
        return (uiOptions | 0x1000) == uiOptions || (uiOptions | 0x800) == uiOptions;
    }

    public static int getBatteryLevel(Context context) {
        int batteryLevel = -1;
        try {
            int scale;
            Intent batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            int level = batteryIntent != null ? batteryIntent.getIntExtra("level", -1) : 0;
            int n = scale = batteryIntent != null ? batteryIntent.getIntExtra("scale", -1) : 0;
            if (level != -1 && scale != -1) {
                batteryLevel = (int)((float)level / (float)scale * 100.0f);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return batteryLevel;
    }

    public static synchronized String getOrGenerateOnceUniqueIdentifier(Context context) {
        if (!TextUtils.isEmpty((CharSequence)uniqueId)) {
            return uniqueId;
        }
        boolean isEnabled = IronSourceSharedPreferencesUtilities.getBooleanFromSharedPrefs(context, MEDIATION_SHARED_PREFS, UUID_ENABLED, true);
        if (isEnabled) {
            String id = IronSourceSharedPreferencesUtilities.getStringFromSharedPrefs(context, MEDIATION_SHARED_PREFS, CACHED_UUID_KEY, "");
            if (TextUtils.isEmpty((CharSequence)id)) {
                uniqueId = UUID.randomUUID().toString();
                IronSourceSharedPreferencesUtilities.saveStringToSharedPrefs(context, MEDIATION_SHARED_PREFS, CACHED_UUID_KEY, uniqueId);
            } else {
                uniqueId = id;
            }
        }
        return uniqueId;
    }

    public static synchronized String getAppUserID(Context context) {
        if (!TextUtils.isEmpty((CharSequence)applicationUserId)) {
            return applicationUserId;
        }
        if (context == null) {
            return "";
        }
        applicationUserId = IronSourceSharedPreferencesUtilities.getStringFromSharedPrefs(context, SUPERSONIC_SHARED_PREFS, AUID_KEY, "");
        if (TextUtils.isEmpty((CharSequence)applicationUserId)) {
            applicationUserId = UUID.randomUUID().toString();
            IronSourceSharedPreferencesUtilities.saveStringToSharedPrefs(context, SUPERSONIC_SHARED_PREFS, AUID_KEY, applicationUserId);
        }
        return applicationUserId;
    }

    public static int getScreenBrightness(Context c2) {
        if (c2 != null) {
            return Settings.System.getInt((ContentResolver)c2.getContentResolver(), (String)"screen_brightness", (int)-1);
        }
        return -1;
    }
}

