/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.app.Activity;
import android.text.TextUtils;
import com.ironsource.sdk.ISNAdView.ISNAdViewDelegate;
import com.ironsource.sdk.WPAD.AdViewsManager;
import com.ironsource.sdk.controller.ContextProvider;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.controller.WebViewMessagingMediator;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.utils.WPADUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AdViewsJSAdapter
implements ISNAdViewDelegate {
    private Activity mActivity;
    private WebViewMessagingMediator mControllerMessageMediator;
    private AdViewsManager mAdViewManager;
    private static final String LOAD_WITH_URL = "loadWithUrl";
    private static final String SEND_MESSAGE = "sendMessage";
    public static final String IS_EXTERNAL_AD_VIEW_INITIATED = "isExternalAdViewInitiated";
    public static final String REMOVE_AD_VIEW = "removeAdView";
    private static final String AD_VIEWS_FUNCTION_PROPERTY_NAME = "functionName";
    private static final String AD_VIEWS_PARAMS_PROPERTY_NAME = "functionParams";
    private static final String SUCCESS_JS_CALLBACK_NAME = "success";
    private static final String FAIL_JS_CALLBACK_NAME = "fail";
    public static final String ERR_MSG = "errMsg";
    private static final String UNSUPPORTED_AD_VIEWS_API_MESSAGE = "%s | unsupported AdViews API";
    ContextProvider mContextProvider;

    public AdViewsJSAdapter(ContextProvider contextProvider) {
        this.mContextProvider = contextProvider;
        this.mAdViewManager = AdViewsManager.getInstance();
    }

    public void setCommunicationWithController(WebViewMessagingMediator delegate) {
        this.mControllerMessageMediator = delegate;
    }

    @Override
    public void sendMessageToController(String message, JSONObject params) {
        if (this.mControllerMessageMediator != null && !TextUtils.isEmpty((CharSequence)message)) {
            this.mControllerMessageMediator.sendMessageToController(message, params);
        }
    }

    @Override
    public void sendErrorMessageToController(String failureMethod, String errorMessage, String adViewId) {
        JSONObject errorObject = WPADUtils.buildErrorObject(errorMessage, adViewId);
        this.sendMessageToController(failureMethod, errorObject);
    }

    void call(String params, WebController.NativeAPI.JSCallbackTask callback) throws Exception {
        FunctionCall fCall = this.fetchFunctionCall(params);
        SSAObj result = new SSAObj();
        try {
            switch (fCall.name) {
                case "loadWithUrl": {
                    this.mAdViewManager.loadWithUrl(this, fCall.params, this.mContextProvider.getCurrentActivityContext(), fCall.successCallback, fCall.failCallback);
                    break;
                }
                case "sendMessage": {
                    this.mAdViewManager.sendMessageToAd(fCall.params, fCall.successCallback, fCall.failCallback);
                    break;
                }
                case "isExternalAdViewInitiated": {
                    this.mAdViewManager.sendIsExternalAdViewInitiated(fCall.params, fCall.successCallback);
                    break;
                }
                case "removeAdView": {
                    this.mAdViewManager.removeAdView(fCall.params, fCall.successCallback, fCall.failCallback);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(UNSUPPORTED_AD_VIEWS_API_MESSAGE, fCall.name));
                }
            }
        }
        catch (Exception ex) {
            result.put(ERR_MSG, ex.getMessage());
            String adViewId = this.mAdViewManager.getAdViewId(fCall.params);
            if (!TextUtils.isEmpty((CharSequence)adViewId)) {
                result.put("adViewId", adViewId);
            }
            callback.sendMessage(false, fCall.failCallback, result);
        }
    }

    private FunctionCall fetchFunctionCall(String params) throws JSONException {
        JSONObject functionData = new JSONObject(params);
        FunctionCall res = new FunctionCall();
        res.name = functionData.optString(AD_VIEWS_FUNCTION_PROPERTY_NAME);
        res.params = functionData.optJSONObject(AD_VIEWS_PARAMS_PROPERTY_NAME);
        res.successCallback = functionData.optString(SUCCESS_JS_CALLBACK_NAME);
        res.failCallback = functionData.optString(FAIL_JS_CALLBACK_NAME);
        return res;
    }

    private static class FunctionCall {
        String name;
        JSONObject params;
        String successCallback;
        String failCallback;

        private FunctionCall() {
        }
    }
}

