/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.InterstitialManagerListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashApi;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class InterstitialSmash
extends AbstractSmash
implements InterstitialSmashListener,
InterstitialSmashApi {
    private JSONObject mInterstitialAdapterConfigs;
    private InterstitialManagerListener mInterstitialManagerListener;
    private long mLoadStartTime;
    private int mTimeout;

    InterstitialSmash(ProviderSettings adapterConfigs, int timeout) {
        super(adapterConfigs);
        this.mInterstitialAdapterConfigs = adapterConfigs.getInterstitialSettings();
        this.mMaxAdsPerIteration = this.mInterstitialAdapterConfigs.optInt("maxAdsPerIteration", 99);
        this.mMaxAdsPerSession = this.mInterstitialAdapterConfigs.optInt("maxAdsPerSession", 99);
        this.mMaxAdsPerDay = this.mInterstitialAdapterConfigs.optInt("maxAdsPerDay", 99);
        this.mIsMultipleInstances = adapterConfigs.isMultipleInstances();
        this.mSpId = adapterConfigs.getSubProviderId();
        this.mTimeout = timeout;
    }

    @Override
    void completeIteration() {
        this.mIterationShowCounter = 0;
        this.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
    }

    @Override
    void startInitTimer() {
        try {
            this.stopInitTimer();
            this.mInitTimer = new Timer();
            this.mInitTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.cancel();
                    if (InterstitialSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING && InterstitialSmash.this.mInterstitialManagerListener != null) {
                        InterstitialSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
                        InterstitialSmash.this.mInterstitialManagerListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError("Timeout", "Interstitial"), InterstitialSmash.this);
                    }
                }
            }, this.mTimeout * 1000);
        }
        catch (Exception e2) {
            this.logException("startInitTimer", e2.getLocalizedMessage());
        }
    }

    @Override
    void startLoadTimer() {
        try {
            this.stopLoadTimer();
            this.mLoadTimer = new Timer();
            this.mLoadTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.cancel();
                    if (InterstitialSmash.this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && InterstitialSmash.this.mInterstitialManagerListener != null) {
                        InterstitialSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
                        long elapsedTime = new Date().getTime() - InterstitialSmash.this.mLoadStartTime;
                        InterstitialSmash.this.mInterstitialManagerListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("Timeout"), InterstitialSmash.this, elapsedTime);
                    }
                }
            }, this.mTimeout * 1000);
        }
        catch (Exception e2) {
            this.logException("startLoadTimer", e2.getLocalizedMessage());
        }
    }

    @Override
    protected String getAdUnitString() {
        return "interstitial";
    }

    @Override
    public void initInterstitial(String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mAdapter.addInterstitialListener(this);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":initInterstitial()", 1);
            this.mAdapter.initInterstitial(appKey, userId, this.mInterstitialAdapterConfigs, this);
        }
    }

    @Override
    public void loadInterstitial() {
        this.startLoadTimer();
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":loadInterstitial()", 1);
            this.mLoadStartTime = new Date().getTime();
            this.mAdapter.loadInterstitial(this.mInterstitialAdapterConfigs, this);
        }
    }

    @Override
    public void showInterstitial() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":showInterstitial()", 1);
            this.preShow();
            this.mAdapter.showInterstitial(this.mInterstitialAdapterConfigs, this);
        }
    }

    @Override
    public boolean isInterstitialReady() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":isInterstitialReady()", 1);
            return this.mAdapter.isInterstitialReady(this.mInterstitialAdapterConfigs);
        }
        return false;
    }

    @Override
    public void setInterstitialManagerListener(InterstitialManagerListener listener) {
        this.mInterstitialManagerListener = listener;
    }

    @Override
    public void onInterstitialInitSuccess() {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            if (this.mInterstitialManagerListener != null) {
                this.mInterstitialManagerListener.onInterstitialInitSuccess(this);
            }
        }
    }

    @Override
    public void onInterstitialInitFailed(IronSourceError error) {
        this.stopInitTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.INIT_PENDING) {
            this.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            if (this.mInterstitialManagerListener != null) {
                this.mInterstitialManagerListener.onInterstitialInitFailed(error, this);
            }
        }
    }

    @Override
    public void onInterstitialAdReady() {
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mInterstitialManagerListener != null) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mInterstitialManagerListener.onInterstitialAdReady(this, elapsedTime);
        }
    }

    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        this.stopLoadTimer();
        if (this.mMediationState == AbstractSmash.MEDIATION_STATE.LOAD_PENDING && this.mInterstitialManagerListener != null) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mInterstitialManagerListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
        }
    }

    @Override
    public void onInterstitialAdOpened() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdOpened(this);
        }
    }

    @Override
    public void onInterstitialAdClosed() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdClosed(this);
        }
    }

    @Override
    public void onInterstitialAdShowSucceeded() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdShowSucceeded(this);
        }
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error) {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdShowFailed(error, this);
        }
    }

    @Override
    public void onInterstitialAdClicked() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdClicked(this);
        }
    }

    @Override
    public void onInterstitialAdVisible() {
        if (this.mInterstitialManagerListener != null) {
            this.mInterstitialManagerListener.onInterstitialAdVisible(this);
        }
    }
}

