/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.lifecycle.LifecycleSensitiveTimer;
import com.ironsource.mediationsdk.IRewardedManager;
import com.ironsource.mediationsdk.logger.IronLog;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class ExpiredRvAdsManager {
    private static final int EXPIRED_DURATION_DISABLED = -1;
    private Runnable expirationTask;
    private int expiredDurationInMinutes = 0;
    private IRewardedManager manager;
    private LifecycleSensitiveTimer timer;

    private ExpiredRvAdsManager() {
    }

    static ExpiredRvAdsManager getInstance() {
        return ExpiredRvAdsManagerHolder.instance;
    }

    void initialize(final IRewardedManager manager, int expiredDurationInMinutes) {
        this.manager = manager;
        if (expiredDurationInMinutes > 0) {
            this.expiredDurationInMinutes = expiredDurationInMinutes;
            this.expirationTask = new Runnable(){

                @Override
                public void run() {
                    IronLog.INTERNAL.info("loaded ads are expired");
                    if (manager != null) {
                        manager.reloadRewardedVideos();
                    }
                }
            };
        } else {
            this.expiredDurationInMinutes = -1;
        }
        IronLog.INTERNAL.verbose("initializing with expiredDurationInMinutes=" + this.expiredDurationInMinutes);
    }

    void startExpirationTimerForAds(long deltaInMilliSeconds) {
        if (this.enabled()) {
            deltaInMilliSeconds = Math.max(deltaInMilliSeconds, 0L);
            long delayMillis = TimeUnit.MINUTES.toMillis(this.expiredDurationInMinutes) - deltaInMilliSeconds;
            if (delayMillis > 0L) {
                this.cancelExpirationScheduler();
                this.timer = new LifecycleSensitiveTimer(delayMillis, this.expirationTask, true);
                Calendar c2 = Calendar.getInstance();
                c2.add(14, (int)delayMillis);
                IronLog.INTERNAL.info("loaded ads will expire on: " + c2.getTime() + " in " + String.format("%.2f", (double)delayMillis / 1000.0 / 60.0) + " mins");
            } else {
                IronLog.INTERNAL.info("loaded ads are loaded immediately");
                this.manager.reloadRewardedVideos();
            }
        }
    }

    void cancelExpirationScheduler() {
        if (this.enabled() && this.timer != null) {
            IronLog.INTERNAL.info("canceling expiration timer");
            this.timer.invalidate();
        }
    }

    public boolean enabled() {
        return this.expiredDurationInMinutes != -1;
    }

    private static class ExpiredRvAdsManagerHolder {
        private static volatile ExpiredRvAdsManager instance = new ExpiredRvAdsManager();

        private ExpiredRvAdsManagerHolder() {
        }
    }
}

