/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.lifecycle;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Bundle;

public class IronsourceLifecycleFragment
extends Fragment {
    private static final String REPORT_FRAGMENT_TAG = "com.ironsource.lifecycle.IronsourceLifecycleFragment";
    private ActivityInitializationListener mProcessListener;

    static IronsourceLifecycleFragment get(Activity activity) {
        return (IronsourceLifecycleFragment)activity.getFragmentManager().findFragmentByTag(REPORT_FRAGMENT_TAG);
    }

    static void injectIfNeededIn(Activity activity) {
        FragmentManager manager = activity.getFragmentManager();
        if (manager != null && manager.findFragmentByTag(REPORT_FRAGMENT_TAG) == null) {
            manager.beginTransaction().add((Fragment)new IronsourceLifecycleFragment(), REPORT_FRAGMENT_TAG).commit();
            manager.executePendingTransactions();
        }
    }

    void setProcessListener(ActivityInitializationListener processListener) {
        this.mProcessListener = processListener;
    }

    private void dispatchCreate(ActivityInitializationListener listener) {
        if (listener != null) {
            listener.onCreate(this.getActivity());
        }
    }

    private void dispatchStart(ActivityInitializationListener listener) {
        if (listener != null) {
            listener.onStart(this.getActivity());
        }
    }

    private void dispatchResume(ActivityInitializationListener listener) {
        if (listener != null) {
            listener.onResume(this.getActivity());
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.dispatchCreate(this.mProcessListener);
    }

    public void onStart() {
        super.onStart();
        this.dispatchStart(this.mProcessListener);
    }

    public void onResume() {
        super.onResume();
        this.dispatchResume(this.mProcessListener);
    }

    public void onPause() {
        super.onPause();
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mProcessListener = null;
    }

    static interface ActivityInitializationListener {
        public void onCreate(Activity var1);

        public void onStart(Activity var1);

        public void onResume(Activity var1);
    }
}

