/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.environment.ANRError;
import com.ironsource.environment.ANRHandler;
import com.ironsource.environment.ANRListener;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.CrashHandler;
import com.ironsource.environment.DbHandler;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.environment.ExceptionLog;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;

public class CrashReporter {
    private static final String CRASH_REPORTER_VERSION = "1.0.1";
    private JSONObject mCrashReport = new JSONObject();
    private String mAnrReport = "";
    private boolean isANR = false;
    private String mAdvertisingId;
    private String mSessionId;
    private boolean isOptOutEnabled = false;
    private Context mContext;
    private Thread.UncaughtExceptionHandler mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    private String crashReporterURL = "https://outcome-crash-report.supersonicads.com/reporter";
    private String crashKeyword = " ";

    public static CrashReporter getInstance() {
        return CrashReporterHolder.INSTANCE;
    }

    private CrashReporter() {
        Thread.setDefaultUncaughtExceptionHandler(new CrashHandler(this.mDefaultHandler));
    }

    public void init(final Context context, HashSet<String> keyParamsToInclude, String reporterURL, String keyword, boolean shouldSendANR, final String sessionId, int anrTimeout) {
        if (context != null) {
            Log.d((String)"automation_log", (String)"init ISCrashReporter");
            this.mContext = context;
            if (!TextUtils.isEmpty((CharSequence)keyword)) {
                this.crashKeyword = keyword;
            }
            if (!TextUtils.isEmpty((CharSequence)reporterURL)) {
                this.crashReporterURL = reporterURL;
            }
            this.mSessionId = sessionId;
            if (shouldSendANR) {
                new ANRHandler(anrTimeout).setANRListener(new ANRListener(){

                    @Override
                    public void onAppNotResponding(ANRError error) {
                        CrashReporter.this.mAnrReport = error.toString();
                        CrashReporter.this.isANR = true;
                    }

                    @Override
                    public void onANRHandlerDogGivingUp() {
                    }
                }).start();
            }
            this.sendExceptions(context, keyParamsToInclude);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            String[] advertisingIdInfo = DeviceStatus.getAdvertisingIdInfo(context);
                            if (advertisingIdInfo.length == 2) {
                                if (!TextUtils.isEmpty((CharSequence)advertisingIdInfo[0])) {
                                    CrashReporter.this.mAdvertisingId = advertisingIdInfo[0];
                                }
                                CrashReporter.this.isOptOutEnabled = Boolean.parseBoolean(advertisingIdInfo[1]);
                                SharedPreferences sharedPref = context.getSharedPreferences("CRep", 0);
                                SharedPreferences.Editor editor = sharedPref.edit();
                                editor.putString("String1", CrashReporter.this.mAdvertisingId);
                                editor.putString("sId", sessionId);
                                editor.apply();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }).start();
        }
    }

    static List<ExceptionLog> getExceptions() {
        return null;
    }

    private void sendExceptions(Context context, HashSet<String> keyParamsToInclude) {
        String networkType = this.getConnectionType(this.getContext());
        if (!networkType.equals("none")) {
            SharedPreferences sharedPref = context.getSharedPreferences("CRep", 0);
            String gaid = sharedPref.getString("String1", this.mAdvertisingId);
            String sId = sharedPref.getString("sId", this.mSessionId);
            StringBuilder sb = new StringBuilder();
            List<ExceptionLog> reportList = DbHandler.getAllReports();
            for (ExceptionLog report : reportList) {
                String crashDate = report.getDate();
                String stackTraceCrash = report.getStacktrace();
                String crashType = "";
                crashType = this.isANR ? "ANR" : "Crash";
                String bundle = context.getPackageName();
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("crashDate", (Object)crashDate);
                    jsonObject.put("stacktraceCrash", (Object)stackTraceCrash);
                    jsonObject.put("crashType", (Object)crashType);
                    jsonObject.put("CrashReporterVersion", (Object)CRASH_REPORTER_VERSION);
                    jsonObject.put("SDKVersion", (Object)"7.1.3");
                    jsonObject.put("deviceLanguage", (Object)DeviceStatus.getDeviceLanguage(context));
                    jsonObject.put("appVersion", (Object)ApplicationContext.getPublisherApplicationVersion(context, bundle));
                    jsonObject.put("deviceOSVersion", (Object)DeviceStatus.getAndroidOsVersion());
                    jsonObject.put("network", (Object)networkType);
                    jsonObject.put("deviceApiLevel", DeviceStatus.getAndroidAPIVersion());
                    jsonObject.put("deviceModel", (Object)DeviceStatus.getDeviceModel());
                    jsonObject.put("deviceOS", (Object)DeviceStatus.getDeviceOs());
                    jsonObject.put("advertisingId", (Object)gaid);
                    jsonObject.put("isLimitAdTrackingEnabled", this.isOptOutEnabled);
                    jsonObject.put("deviceOEM", (Object)DeviceStatus.getDeviceOEM());
                    jsonObject.put("systemProperties", (Object)System.getProperties());
                    jsonObject.put("bundleId", (Object)bundle);
                    jsonObject.put("sId", (Object)sId);
                    JSONObject ret = new JSONObject();
                    if (jsonObject != null && keyParamsToInclude != null && !keyParamsToInclude.isEmpty()) {
                        for (String key : keyParamsToInclude) {
                            try {
                                if (!jsonObject.has(key)) continue;
                                ret.put(key, jsonObject.opt(key));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        ret = jsonObject;
                    }
                    this.mCrashReport = ret;
                }
                catch (Exception ret) {
                    // empty catch block
                }
                if (this.mCrashReport.length() == 0) {
                    Log.d((String)"ISCrashReport", (String)" Is Empty");
                    continue;
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            URL url = new URL(CrashReporter.getInstance().crashReporterURL);
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
                            conn.setRequestProperty("Accept", "application/json");
                            conn.setDoOutput(true);
                            conn.setDoInput(true);
                            Log.i((String)"JSON", (String)CrashReporter.this.mCrashReport.toString());
                            DataOutputStream os = new DataOutputStream(conn.getOutputStream());
                            os.writeBytes(CrashReporter.this.mCrashReport.toString());
                            os.flush();
                            os.close();
                            Log.i((String)"STATUS", (String)String.valueOf(conn.getResponseCode()));
                            Log.i((String)"MSG", (String)conn.getResponseMessage());
                            conn.disconnect();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                });
                thread.start();
                DbHandler.deleteAllReports();
            }
        }
    }

    Context getContext() {
        return this.mContext;
    }

    String getKeyword() {
        return this.crashKeyword;
    }

    private String getConnectionType(Context c2) {
        if (c2 == null) {
            return "none";
        }
        ConnectivityManager cm = (ConnectivityManager)c2.getSystemService("connectivity");
        if (cm == null) {
            return "none";
        }
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = cm.getActiveNetwork();
            NetworkCapabilities mNetworkCapabilities = cm.getNetworkCapabilities(network);
            if (mNetworkCapabilities == null) {
                return "none";
            }
            if (mNetworkCapabilities.hasTransport(1)) {
                return "wifi";
            }
            if (mNetworkCapabilities.hasTransport(0)) {
                return "cellular";
            }
            return "none";
        }
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getTypeName().equalsIgnoreCase("WIFI")) {
                return "wifi";
            }
            if (info.getTypeName().equalsIgnoreCase("MOBILE")) {
                return "cellular";
            }
        } else {
            return "none";
        }
        return "none";
    }

    public String getCrashReporterVersion() {
        return CRASH_REPORTER_VERSION;
    }

    private static class CrashReporterHolder {
        static volatile CrashReporter INSTANCE = new CrashReporter();

        private CrashReporterHolder() {
        }
    }
}

