package com.ironsource.adapters.supersonicads;

import android.text.TextUtils;

import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.ProviderSettingsHolder;
import com.ironsource.mediationsdk.utils.IronSourceConstants;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Created by pnina.r on 8/23/16.
 */
public class SupersonicConfig {
    private final String CUSTOM_PARAM_PREFIX = "custom_";
    private final String CLIENT_SIDE_CALLBACKS = "useClientSideCallbacks";
    private final String MAX_VIDEO_LENGTH = "maxVideoLength";
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String CAMPAIGN_ID = "campaignId";
    private final String LANGUAGE = "language";
    private final String APPLICATION_PRIVATE_KEY = "privateKey";
    private final String ITEM_NAME = "itemName";
    private final String ITEM_COUNT = "itemCount";

    private Map<String, String> mRewardedVideoCustomParams;
    private Map<String, String> mOfferwallCustomParams;

    private static SupersonicConfig mInstance;

    ProviderSettings mProviderSettings;

    public static SupersonicConfig getConfigObj() {
        if (mInstance == null)
            mInstance = new SupersonicConfig();

        return mInstance;
    }

    private SupersonicConfig() {
        mProviderSettings = new ProviderSettings(ProviderSettingsHolder.getProviderSettingsHolder().getProviderSettings(IronSourceConstants.MEDIATION_PROVIDER_NAME));
    }

    //***** setters *****
    public void setClientSideCallbacks(boolean status) {
        mProviderSettings.setRewardedVideoSettings(CLIENT_SIDE_CALLBACKS, String.valueOf(status));
    }

    public void setCustomControllerUrl(String url) {
        mProviderSettings.setRewardedVideoSettings(DYNAMIC_CONTROLLER_URL, url);
        mProviderSettings.setInterstitialSettings(DYNAMIC_CONTROLLER_URL, url);
        mProviderSettings.setBannerSettings(DYNAMIC_CONTROLLER_URL, url);
    }

    public void setDebugMode(int debugMode) {
        mProviderSettings.setRewardedVideoSettings(DYNAMIC_CONTROLLER_DEBUG_MODE, debugMode);
        mProviderSettings.setInterstitialSettings(DYNAMIC_CONTROLLER_DEBUG_MODE, debugMode);
        mProviderSettings.setBannerSettings(DYNAMIC_CONTROLLER_DEBUG_MODE, debugMode);
    }

    public void setCampaignId(String id) {
        mProviderSettings.setRewardedVideoSettings(CAMPAIGN_ID, id);
    }

    public void setLanguage(String language) {
        mProviderSettings.setRewardedVideoSettings(LANGUAGE, language);
        mProviderSettings.setInterstitialSettings(LANGUAGE, language);
    }

    public void setRewardedVideoCustomParams(Map<String, String> rvCustomParams) {
        mRewardedVideoCustomParams = convertCustomParams(rvCustomParams);
    }

    public void setOfferwallCustomParams(Map<String, String> owCustomParams) {
        mOfferwallCustomParams = convertCustomParams(owCustomParams);
    }

    private Map<String, String> convertCustomParams(Map<String, String> customParams) {
        Map<String, String> result = new HashMap<>();

        try {
            if (customParams != null) {

                //Take a set of all keys
                Set<String> keys = customParams.keySet();
                if (keys != null) {
                    for (String k : keys) {

                        if (!TextUtils.isEmpty(k)) {
                            String value = customParams.get(k);
                            if (!TextUtils.isEmpty(value)) {
                                result.put(CUSTOM_PARAM_PREFIX + k, value);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, ":convertCustomParams()", e);
        }

        return result;
    }

    //***** getters *****
    //only for rv
    public boolean getClientSideCallbacks() {
        boolean csc = false;

        if (mProviderSettings != null && mProviderSettings.getRewardedVideoSettings() != null) {
            if (mProviderSettings.getRewardedVideoSettings().has(CLIENT_SIDE_CALLBACKS))
                csc = mProviderSettings.getRewardedVideoSettings().optBoolean(CLIENT_SIDE_CALLBACKS, false);
        }

        return csc;
    }

    public Map<String, String> getOfferwallCustomParams() {
        return mOfferwallCustomParams;
    }

    Map<String, String> getRewardedVideoCustomParams() {
        return mRewardedVideoCustomParams;
    }
}
