/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.WPAD;

import android.app.Activity;
import android.webkit.WebView;
import com.ironsource.sdk.ISNAdView.ISNAdViewDelegate;
import com.ironsource.sdk.WPAD.ISNAdViewProtocol;
import com.ironsource.sdk.WPAD.ISNAdunitWebView;
import com.ironsource.sdk.utils.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AdViewsManager {
    private static final String TAG = AdViewsManager.class.getSimpleName();
    private static AdViewsManager mInstance = null;
    Map<String, ISNAdViewProtocol> mAdViewsCollection = Collections.synchronizedMap(new HashMap());

    public static synchronized AdViewsManager getInstance() {
        if (mInstance == null) {
            mInstance = new AdViewsManager();
        }
        return mInstance;
    }

    public String getAdViewId(JSONObject params) throws JSONException {
        String adViewId = "";
        if (params != null && params.has("adViewId")) {
            adViewId = params.getString("adViewId");
        } else if (params != null && params.has("params")) {
            JSONObject paramsObject = new JSONObject(params.getString("params"));
            adViewId = paramsObject.getString("adViewId");
        }
        return adViewId;
    }

    public void loadWithUrl(ISNAdViewDelegate delegate, JSONObject params, Activity activity, String successCallback, String failureCallback) throws Exception {
        String adViewId = params.getString("adViewId");
        if (adViewId.isEmpty()) {
            Logger.i(TAG, "loadWithUrl fail - adViewId is empty");
            throw new Exception("adViewId is empty");
        }
        if (this.mAdViewsCollection.containsKey(adViewId)) {
            Logger.i(TAG, "sendMessageToAd fail - collection already contain adViewId");
            throw new Exception("collection already contain adViewId");
        }
        ISNAdunitWebView adunitWebView = new ISNAdunitWebView(delegate, activity, adViewId);
        this.mAdViewsCollection.put(adViewId, adunitWebView);
        adunitWebView.loadWithUrl(params, successCallback, failureCallback);
    }

    public void sendMessageToAd(JSONObject params, String successCallback, String failureCallback) throws Exception {
        JSONObject paramsObject = new JSONObject(params.getString("params"));
        String adViewId = paramsObject.getString("adViewId");
        if (adViewId.isEmpty()) {
            Logger.i(TAG, "sendMessageToAd fail - adViewId is empty");
            throw new Exception("adViewId is empty");
        }
        if (!this.mAdViewsCollection.containsKey(adViewId)) {
            Logger.i(TAG, "sendMessageToAd fail - collection does not contain adViewId");
            throw new Exception("collection does not contain adViewId");
        }
        ISNAdViewProtocol adunitWebView = this.mAdViewsCollection.get(adViewId);
        adunitWebView.sendMessageToAd(params, successCallback, failureCallback);
    }

    public WebView getAdViewById(String adViewId) {
        if (adViewId.isEmpty() || !this.mAdViewsCollection.containsKey(adViewId)) {
            return null;
        }
        ISNAdViewProtocol adunitWebView = this.mAdViewsCollection.get(adViewId);
        return adunitWebView.getViewToPresent();
    }

    public void sendIsExternalAdViewInitiated(JSONObject params, String successMethod) throws Exception {
        String adViewId = params.getString("adViewId");
        if (adViewId.isEmpty()) {
            Logger.i(TAG, "sendIsExternalAdViewInitiated fail - adViewId is empty");
            throw new Exception("adViewId is empty");
        }
        if (!this.mAdViewsCollection.containsKey(adViewId)) {
            Logger.i(TAG, "sendIsExternalAdViewInitiated fail - collection does not contain adViewId");
            throw new Exception("collection does not contain adViewId");
        }
        ISNAdViewProtocol adunitWebView = this.mAdViewsCollection.get(adViewId);
        adunitWebView.sendIsExternalAdViewInitiated(successMethod);
    }

    public void removeAdView(JSONObject params, String successCallback, String failureCallback) throws Exception {
        String adViewId = params.getString("adViewId");
        if (adViewId.isEmpty()) {
            Logger.i(TAG, "removeAdView fail - adViewId is empty");
            throw new Exception("adViewId is empty");
        }
        if (!this.mAdViewsCollection.containsKey(adViewId)) {
            Logger.i(TAG, "removeAdView fail - collection does not contain adViewId");
            throw new Exception("collection does not contain adViewId");
        }
        ISNAdViewProtocol adunitWebView = this.mAdViewsCollection.get(adViewId);
        this.mAdViewsCollection.remove(adViewId);
        adunitWebView.performCleanup(successCallback, failureCallback);
    }
}

