/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class ConnectivityService {
    public static final String NETWORK_TYPE_3G = "3g";
    public static final String NETWORK_TYPE_WIFI = "wifi";
    public static final String NETWORK_TYPE_NONE = "none";
    public static final String NETWORK_TYPE_BLUETOOTH = "bluetooth";
    public static final String NETWORK_TYPE_ETHERNET = "ethernet";
    public static final String NETWORK_TYPE_VPN = "vpn";
    public static final String NETWORK_TYPE_CELLULAR = "cellular";
    public static final String NETWORK_TYPE_WIFI_AWARE = "wifiAware";
    public static final String NETWORK_TYPE_LOWPAN = "lowpan";

    public static String getConnectionType(Context context) {
        NetworkInfo activeNetwork;
        StringBuilder connectionType = new StringBuilder();
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (activeNetwork = cm.getActiveNetworkInfo()) != null && activeNetwork.isConnected()) {
            String typeName = activeNetwork.getTypeName();
            int typeId = activeNetwork.getType();
            if (typeId == 0) {
                connectionType.append(NETWORK_TYPE_3G);
            } else if (typeId == 1) {
                connectionType.append(NETWORK_TYPE_WIFI);
            } else {
                connectionType.append(typeName);
            }
        }
        return connectionType.toString();
    }

    public static boolean isConnectedWifi(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getNetworkInfo(1);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isConnectedMobile(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getNetworkInfo(0);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static String getNetworkOperator(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            return tm.getNetworkOperator();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static int getNetworkMCC(Context context) {
        try {
            return context.getResources().getConfiguration().mcc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static int getNetworkMNC(Context context) {
        try {
            return context.getResources().getConfiguration().mnc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static String getSimOperator(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                return tm.getSimOperator();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static int getPhoneType(Context context) {
        int result = -1;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            result = tm.getPhoneType();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

