/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.util.Base64;
import com.ironsource.mediationsdk.logger.IronLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IronSourceGZIP {
    public static byte[] compress(String data) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
        GZIPOutputStream gzip = new GZIPOutputStream(bos);
        gzip.write(data.getBytes());
        gzip.close();
        byte[] compressed = bos.toByteArray();
        IronLog.INTERNAL.verbose("compressed string: " + Base64.encodeToString((byte[])compressed, (int)0));
        bos.close();
        return compressed;
    }

    public static String decompress(byte[] compressed) {
        try {
            String line;
            IronLog.INTERNAL.verbose("compressed string: " + Base64.encodeToString((byte[])compressed, (int)0));
            ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
            GZIPInputStream gis = new GZIPInputStream(bis);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            gis.close();
            bis.close();
            return sb.toString();
        }
        catch (Exception e2) {
            IronLog.INTERNAL.error("exception while decompressing " + e2);
            return null;
        }
    }
}

