/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.DailyCappingListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

public class DailyCappingManager {
    private static final int RAND_MINUTES = 10;
    private Map<String, Integer> mSmashIdToMaxShowsPerDay;
    private Map<String, Integer> mSmashIdToCounter;
    private Map<String, String> mSmashIdToCounterDate;
    private String mAdUnitName;
    private Timer mTimer = null;
    private DailyCappingListener mListener;
    private IronSourceLoggerManager mLogger;

    public DailyCappingManager(String adUnitName, DailyCappingListener listener) {
        this.mAdUnitName = adUnitName;
        this.mListener = listener;
        this.mSmashIdToMaxShowsPerDay = new HashMap<String, Integer>();
        this.mSmashIdToCounter = new HashMap<String, Integer>();
        this.mSmashIdToCounterDate = new HashMap<String, String>();
        this.mLogger = IronSourceLoggerManager.getLogger();
        this.scheduleTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSmash(AbstractSmash smash) {
        DailyCappingManager dailyCappingManager = this;
        synchronized (dailyCappingManager) {
            try {
                if (smash.getMaxAdsPerDay() != 99) {
                    this.mSmashIdToMaxShowsPerDay.put(this.getUniqueId(smash), smash.getMaxAdsPerDay());
                }
            }
            catch (Exception e2) {
                this.mLogger.logException(IronSourceLogger.IronSourceTag.INTERNAL, "addSmash", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseShowCounter(AbstractSmash smash) {
        DailyCappingManager dailyCappingManager = this;
        synchronized (dailyCappingManager) {
            try {
                String smashId = this.getUniqueId(smash);
                if (!this.mSmashIdToMaxShowsPerDay.containsKey(smashId)) {
                    return;
                }
                int count = this.getTodayShowCount(smashId);
                this.saveCounter(smashId, count + 1);
            }
            catch (Exception e2) {
                this.mLogger.logException(IronSourceLogger.IronSourceTag.INTERNAL, "increaseShowCounter", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSendCapReleasedEvent(AbstractSmash smash) {
        DailyCappingManager dailyCappingManager = this;
        synchronized (dailyCappingManager) {
            try {
                String smashId = this.getUniqueId(smash);
                if (!this.mSmashIdToMaxShowsPerDay.containsKey(smashId)) {
                    return false;
                }
                if (this.getTodayDate().equalsIgnoreCase(this.getCounterDate(smashId))) {
                    return false;
                }
                return this.mSmashIdToMaxShowsPerDay.get(smashId) <= this.getCounter(smashId);
            }
            catch (Exception e2) {
                this.mLogger.logException(IronSourceLogger.IronSourceTag.INTERNAL, "shouldSendCapReleasedEvent", e2);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCapped(AbstractSmash smash) {
        DailyCappingManager dailyCappingManager = this;
        synchronized (dailyCappingManager) {
            try {
                String smashId = this.getUniqueId(smash);
                if (!this.mSmashIdToMaxShowsPerDay.containsKey(smashId)) {
                    return false;
                }
                return this.mSmashIdToMaxShowsPerDay.get(smashId) <= this.getTodayShowCount(smashId);
            }
            catch (Exception e2) {
                this.mLogger.logException(IronSourceLogger.IronSourceTag.INTERNAL, "isCapped", e2);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimerTick() {
        DailyCappingManager dailyCappingManager = this;
        synchronized (dailyCappingManager) {
            try {
                for (String smashId : this.mSmashIdToMaxShowsPerDay.keySet()) {
                    this.zeroCounter(smashId);
                }
                this.mListener.onDailyCapReleased();
                this.scheduleTimer();
            }
            catch (Exception e2) {
                this.mLogger.logException(IronSourceLogger.IronSourceTag.INTERNAL, "onTimerTick", e2);
            }
        }
    }

    private void scheduleTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DailyCappingManager.this.onTimerTick();
            }
        }, this.getUtcMidnight());
    }

    private Date getUtcMidnight() {
        Random random = new Random();
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
        date.set(11, 0);
        date.set(12, random.nextInt(10));
        date.set(13, random.nextInt(60));
        date.set(14, random.nextInt(1000));
        ((Calendar)date).add(5, 1);
        return date.getTime();
    }

    private int getTodayShowCount(String smashId) {
        if (!this.getTodayDate().equalsIgnoreCase(this.getCounterDate(smashId))) {
            this.zeroCounter(smashId);
        }
        return this.getCounter(smashId);
    }

    private String getCounterDate(String smashId) {
        if (this.mSmashIdToCounterDate.containsKey(smashId)) {
            return this.mSmashIdToCounterDate.get(smashId);
        }
        String ret = IronSourceUtils.getStringFromSharedPrefs(ContextProvider.getInstance().getApplicationContext(), this.getDayKeyName(smashId), this.getTodayDate());
        this.mSmashIdToCounterDate.put(smashId, ret);
        return ret;
    }

    private int getCounter(String smashId) {
        if (this.mSmashIdToCounter.containsKey(smashId)) {
            return this.mSmashIdToCounter.get(smashId);
        }
        int ret = IronSourceUtils.getIntFromSharedPrefs(ContextProvider.getInstance().getApplicationContext(), this.getCounterKeyName(smashId), 0);
        this.mSmashIdToCounter.put(smashId, ret);
        return ret;
    }

    private void saveCounter(String smashId, int counter) {
        this.mSmashIdToCounter.put(smashId, counter);
        this.mSmashIdToCounterDate.put(smashId, this.getTodayDate());
        IronSourceUtils.saveIntToSharedPrefs(ContextProvider.getInstance().getApplicationContext(), this.getCounterKeyName(smashId), counter);
        IronSourceUtils.saveStringToSharedPrefs(ContextProvider.getInstance().getApplicationContext(), this.getDayKeyName(smashId), this.getTodayDate());
    }

    private void zeroCounter(String smashId) {
        this.mSmashIdToCounter.put(smashId, 0);
        this.mSmashIdToCounterDate.put(smashId, this.getTodayDate());
        IronSourceUtils.saveIntToSharedPrefs(ContextProvider.getInstance().getApplicationContext(), this.getCounterKeyName(smashId), 0);
        IronSourceUtils.saveStringToSharedPrefs(ContextProvider.getInstance().getApplicationContext(), this.getDayKeyName(smashId), this.getTodayDate());
    }

    private String getUniqueId(AbstractSmash smash) {
        return this.mAdUnitName + "_" + smash.getSubProviderId() + "_" + smash.getName();
    }

    private String getCounterKeyName(String smashId) {
        return smashId + "_counter";
    }

    private String getDayKeyName(String smashId) {
        return smashId + "_day";
    }

    private String getTodayDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date());
    }
}

