/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.server;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.mediationsdk.IronsourceObjectPublisherDataHolder;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ServerURL {
    private static String BASE_URL_PREFIX = "https://init.supersonicads.com/sdk/v";
    private static String BASE_URL_SUFFIX = "?request=";
    private static final String PLATFORM_KEY = "platform";
    private static final String APPLICATION_KEY = "applicationKey";
    private static final String APPLICATION_USER_ID = "applicationUserId";
    private static final String SDK_VERSION = "sdkVersion";
    private static final String PLUGIN_TYPE = "pluginType";
    private static final String PLUGIN_VERSION = "pluginVersion";
    private static final String PLUGIN_FW_VERSION = "plugin_fw_v";
    private static final String GAID = "advId";
    private static final String SERR = "serr";
    private static final String APPLICATION_VERSION = "appVer";
    private static final String OS_VERSION = "osVer";
    private static final String DEVICE_MODEL = "devModel";
    private static final String DEVICE_MAKE = "devMake";
    private static final String CONNECTION_TYPE = "connType";
    private static final String MEDIATION_TYPE = "mt";
    private static final String FIRST_SESSION = "fs";
    private static final String COPPA = "coppa";
    private static final String BROWSER_USER_AGENT = "browserUserAgent";
    private static final String DEVICE_LANG = "deviceLang";
    private static final String BUNDLE_ID = "bundleId";
    private static final String ANDROID = "android";
    private static final String IMPRESSION = "impression";
    private static final String PLACEMENT = "placementId";
    private static final String EQUAL = "=";
    private static final String AMPERSAND = "&";

    public static String getCPVProvidersURL(Context context, String applicationKey, String applicationUserId, String gaid, String mediationType, Vector<Pair<String, String>> segmentParamVector) throws UnsupportedEncodingException {
        String browserUserAgent;
        String connection;
        String appVersion;
        Vector<Pair<String, String>> array = new Vector<Pair<String, String>>();
        array.add(new Pair((Object)PLATFORM_KEY, (Object)ANDROID));
        array.add(new Pair((Object)APPLICATION_KEY, (Object)applicationKey));
        array.add(new Pair((Object)APPLICATION_USER_ID, (Object)applicationUserId));
        array.add(new Pair((Object)SDK_VERSION, (Object)IronSourceUtils.getSDKVersion()));
        if (IronSourceUtils.getSerr() == 0) {
            array.add(new Pair((Object)SERR, (Object)String.valueOf(IronSourceUtils.getSerr())));
        }
        if (!TextUtils.isEmpty((CharSequence)ConfigFile.getConfigFile().getPluginType())) {
            array.add(new Pair((Object)PLUGIN_TYPE, (Object)ConfigFile.getConfigFile().getPluginType()));
        }
        if (!TextUtils.isEmpty((CharSequence)ConfigFile.getConfigFile().getPluginVersion())) {
            array.add(new Pair((Object)PLUGIN_VERSION, (Object)ConfigFile.getConfigFile().getPluginVersion()));
        }
        if (!TextUtils.isEmpty((CharSequence)ConfigFile.getConfigFile().getPluginFrameworkVersion())) {
            array.add(new Pair((Object)PLUGIN_FW_VERSION, (Object)ConfigFile.getConfigFile().getPluginFrameworkVersion()));
        }
        if (!TextUtils.isEmpty((CharSequence)gaid)) {
            array.add(new Pair((Object)GAID, (Object)gaid));
        }
        if (!TextUtils.isEmpty((CharSequence)mediationType)) {
            array.add(new Pair((Object)MEDIATION_TYPE, (Object)mediationType));
        }
        if (!TextUtils.isEmpty((CharSequence)(appVersion = ApplicationContext.getPublisherApplicationVersion(context, context.getPackageName())))) {
            array.add(new Pair((Object)APPLICATION_VERSION, (Object)appVersion));
        }
        int osVersion = Build.VERSION.SDK_INT;
        array.add(new Pair((Object)OS_VERSION, (Object)(osVersion + "")));
        String make = Build.MANUFACTURER;
        array.add(new Pair((Object)DEVICE_MAKE, (Object)make));
        String model = Build.MODEL;
        array.add(new Pair((Object)DEVICE_MODEL, (Object)model));
        int isFirstSession = IronSourceUtils.getFirstSession(context) ? 1 : 0;
        array.add(new Pair((Object)FIRST_SESSION, (Object)(isFirstSession + "")));
        ConcurrentHashMap<String, List<String>> metaDataMap = IronsourceObjectPublisherDataHolder.getInstance().getMediationMetaData();
        if (metaDataMap.containsKey("is_child_directed")) {
            List values = (List)metaDataMap.get("is_child_directed");
            array.add(new Pair((Object)COPPA, values.get(0)));
        }
        if (!TextUtils.isEmpty((CharSequence)(connection = IronSourceUtils.getConnectionType(context)))) {
            array.add(new Pair((Object)CONNECTION_TYPE, (Object)connection));
        }
        if (segmentParamVector != null) {
            array.addAll(segmentParamVector);
        }
        if ((browserUserAgent = IronSourceUtils.getInstance().getBrowserUserAgent()).length() != 0) {
            array.add(new Pair((Object)BROWSER_USER_AGENT, (Object)browserUserAgent));
        }
        String deviceLang = null;
        try {
            deviceLang = DeviceStatus.getDeviceLanguage(context) + "-" + DeviceStatus.getDeviceLocalCountry(context);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (deviceLang != null && deviceLang.length() != 0) {
            array.add((Pair<String, String>)new Pair((Object)DEVICE_LANG, (Object)deviceLang));
        }
        if (context != null) {
            array.add((Pair<String, String>)new Pair((Object)BUNDLE_ID, (Object)context.getPackageName()));
        }
        String params = ServerURL.createURLParams(array);
        String encryptedParams = IronSourceAES.encode("C38FB23A402222A0C17D34A92F971D1F", params);
        String encodedEncryptedParams = URLEncoder.encode(encryptedParams, "UTF-8");
        return ServerURL.getBaseUrl(IronSourceUtils.getSDKVersion()) + encodedEncryptedParams;
    }

    public static String getRequestURL(String requestUrl, boolean hit, int placementId) throws UnsupportedEncodingException {
        Vector<Pair<String, String>> array = new Vector<Pair<String, String>>();
        array.add(new Pair((Object)IMPRESSION, (Object)Boolean.toString(hit)));
        array.add(new Pair((Object)PLACEMENT, (Object)Integer.toString(placementId)));
        String params = ServerURL.createURLParams(array);
        return requestUrl + AMPERSAND + params;
    }

    private static String createURLParams(Vector<Pair<String, String>> array) throws UnsupportedEncodingException {
        String str = "";
        for (Pair<String, String> pair : array) {
            if (str.length() > 0) {
                str = str + AMPERSAND;
            }
            str = str + (String)pair.first + EQUAL + URLEncoder.encode((String)pair.second, "UTF-8");
        }
        return str;
    }

    private static String getBaseUrl(String sdkVersion) {
        return BASE_URL_PREFIX + sdkVersion + BASE_URL_SUFFIX;
    }

    private static void setBaseUrlPrefix(String baseUrlPrefix) {
        BASE_URL_PREFIX = baseUrlPrefix;
    }
}

