/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.agent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.ISNEventsUtils;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceNetworkAPI;
import com.ironsource.sdk.SSAPublisher;
import com.ironsource.sdk.agent.ActivityLifeCycleListener;
import com.ironsource.sdk.agent.OnPauseOnResumeHandler;
import com.ironsource.sdk.constants.Events;
import com.ironsource.sdk.controller.ContextProvider;
import com.ironsource.sdk.controller.ControllerManager;
import com.ironsource.sdk.controller.DemandSourceManager;
import com.ironsource.sdk.controller.FeaturesManager;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.ISNEnums;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.OnRewardedVideoListener;
import com.ironsource.sdk.listeners.internals.DSAdProductListener;
import com.ironsource.sdk.listeners.internals.DSBannerListener;
import com.ironsource.sdk.listeners.internals.DSInterstitialListener;
import com.ironsource.sdk.listeners.internals.DSRewardedVideoListener;
import com.ironsource.sdk.service.TokenService;
import com.ironsource.sdk.utils.DeviceProperties;
import com.ironsource.sdk.utils.IronSourceSharedPrefHelper;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class IronSourceAdsPublisherAgent
implements SSAPublisher,
DSRewardedVideoListener,
DSInterstitialListener,
DSAdProductListener,
DSBannerListener,
IronSourceNetworkAPI,
OnPauseOnResumeHandler {
    private static final String TAG = "IronSourceAdsPublisherAgent";
    private final String SUPERSONIC_ADS = "SupersonicAds";
    private static IronSourceAdsPublisherAgent sInstance;
    private ControllerManager mControllerManager;
    private String mApplicationKey;
    private String mUserId;
    private long adViewContainerCounter;
    private DemandSourceManager mDemandSourceManager;
    private TokenService mTokenService;
    private boolean mEnableLifeCycleListeners = false;
    private ContextProvider mContextProvider;

    private IronSourceAdsPublisherAgent(Context applicationContext, int debugMode) {
        this.initPublisherAgent(applicationContext);
    }

    IronSourceAdsPublisherAgent(String applicationKey, String userId, Context applicationContext) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.initPublisherAgent(applicationContext);
    }

    private void initPublisherAgent(Context applicationContext) {
        try {
            IronSourceSharedPrefHelper.getSupersonicPrefHelper(applicationContext);
            this.mTokenService = this.createToken(applicationContext);
            this.mDemandSourceManager = new DemandSourceManager();
            this.mContextProvider = new ContextProvider();
            if (applicationContext instanceof Activity) {
                this.mContextProvider.updateActivityContext((Activity)applicationContext);
            }
            this.mControllerManager = new ControllerManager(applicationContext, this.mContextProvider, this.mTokenService, this.mDemandSourceManager);
            Logger.enableLogging(FeaturesManager.getInstance().getDebugMode());
            Logger.i(TAG, "C'tor");
            JSONObject networkConfiguration = SDKUtils.getNetworkConfiguration();
            this.decideOnListeningToApplicationLifeCycleEvents(applicationContext, networkConfiguration);
            this.adViewContainerCounter = 0L;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private TokenService createToken(Context applicationContext) {
        TokenService tokenService = TokenService.getInstance();
        tokenService.fetchIndependentData();
        tokenService.fetchDependentData(applicationContext, this.mApplicationKey, this.mUserId);
        return tokenService;
    }

    public static IronSourceNetworkAPI createInstance(Context applicationContext, String applicationKey, String userId) {
        return IronSourceAdsPublisherAgent.getInstance(applicationKey, userId, applicationContext);
    }

    public static synchronized IronSourceNetworkAPI getInstance(String applicationKey, String userId, Context applicationContext) {
        if (sInstance == null) {
            ISNEventsTracker.logEvent(SDK5Events.initSDK);
            sInstance = new IronSourceAdsPublisherAgent(applicationKey, userId, applicationContext);
        } else {
            TokenService.getInstance().collectApplicationKey(applicationKey);
            TokenService.getInstance().collectApplicationUserId(userId);
        }
        return sInstance;
    }

    public static synchronized IronSourceAdsPublisherAgent getInstance(Context applicationContext) throws Exception {
        return IronSourceAdsPublisherAgent.getInstance(applicationContext, 0);
    }

    public static synchronized IronSourceAdsPublisherAgent getInstance(Context applicationContext, int debugMode) throws Exception {
        Logger.i(TAG, "getInstance()");
        if (sInstance == null) {
            sInstance = new IronSourceAdsPublisherAgent(applicationContext, debugMode);
        }
        return sInstance;
    }

    public ControllerManager getControllerManager() {
        return this.mControllerManager;
    }

    private OnRewardedVideoListener getAdProductListenerAsRVListener(DemandSource demandSource) {
        if (demandSource == null) {
            return null;
        }
        return (OnRewardedVideoListener)demandSource.getListener();
    }

    private OnInterstitialListener getAdProductListenerAsISListener(DemandSource demandSource) {
        if (demandSource == null) {
            return null;
        }
        return (OnInterstitialListener)demandSource.getListener();
    }

    private OnBannerListener getAdProductListenerAsBNListener(DemandSource demandSource) {
        if (demandSource == null) {
            return null;
        }
        return (OnBannerListener)demandSource.getListener();
    }

    @Override
    public void initRewardedVideo(final String applicationKey, final String userId, String demandSourceName, Map<String, String> extraParameters, OnRewardedVideoListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        final DemandSource demandSource = this.mDemandSourceManager.createDemandSource(ISNEnums.ProductType.RewardedVideo, demandSourceName, extraParameters, listener);
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.initRewardedVideo(applicationKey, userId, demandSource, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void showRewardedVideo(final JSONObject showParams) {
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.showRewardedVideo(showParams, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void initOfferWall(final String applicationKey, final String userId, final Map<String, String> extraParameters, final OnOfferWallListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.initOfferWall(applicationKey, userId, extraParameters, listener);
            }
        });
    }

    @Override
    public void initOfferWall(final Map<String, String> initParams, final OnOfferWallListener listener) {
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.initOfferWall(IronSourceAdsPublisherAgent.this.mApplicationKey, IronSourceAdsPublisherAgent.this.mUserId, initParams, listener);
            }
        });
    }

    @Override
    public void showOfferWall(final Map<String, String> extraParameters) {
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.showOfferWall(extraParameters);
            }
        });
    }

    @Override
    public void getOfferWallCredits(final String applicationKey, final String userId, final OnOfferWallListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.getOfferWallCredits(applicationKey, userId, listener);
            }
        });
    }

    @Override
    public void getOfferWallCredits(final OnOfferWallListener listener) {
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.getOfferWallCredits(IronSourceAdsPublisherAgent.this.mApplicationKey, IronSourceAdsPublisherAgent.this.mUserId, listener);
            }
        });
    }

    @Override
    public void initInterstitial(final String applicationKey, final String userId, String demandSourceName, Map<String, String> extraParameters, OnInterstitialListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        final DemandSource demandSource = this.mDemandSourceManager.createDemandSource(ISNEnums.ProductType.Interstitial, demandSourceName, extraParameters, listener);
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.initInterstitial(applicationKey, userId, demandSource, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void loadInterstitial(JSONObject loadParams) {
        if (loadParams == null) {
            return;
        }
        final String demandSourceName = loadParams.optString("demandSourceName");
        if (TextUtils.isEmpty((CharSequence)demandSourceName)) {
            return;
        }
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.loadInterstitial(demandSourceName, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public boolean isInterstitialAdAvailable(String demandSourceName) {
        return this.mControllerManager.isInterstitialAdAvailable(demandSourceName);
    }

    @Override
    public void showInterstitial(final JSONObject showParams) {
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.showInterstitial(showParams, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void initBanner(final String applicationKey, final String userId, String demandSourceName, Map<String, String> extraParameters, OnBannerListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        final DemandSource demandSource = this.mDemandSourceManager.createDemandSource(ISNEnums.ProductType.Banner, demandSourceName, extraParameters, listener);
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.initBanner(applicationKey, userId, demandSource, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void initBanner(String demandSourceName, Map<String, String> extraParameters, OnBannerListener listener) {
        final DemandSource demandSource = this.mDemandSourceManager.createDemandSource(ISNEnums.ProductType.Banner, demandSourceName, extraParameters, listener);
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.initBanner(IronSourceAdsPublisherAgent.this.mApplicationKey, IronSourceAdsPublisherAgent.this.mUserId, demandSource, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void loadBanner(final JSONObject loadParams) {
        if (loadParams != null) {
            this.mControllerManager.executeCommand(new Runnable(){

                @Override
                public void run() {
                    IronSourceAdsPublisherAgent.this.mControllerManager.loadBanner(loadParams, IronSourceAdsPublisherAgent.this);
                }
            });
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (this.mEnableLifeCycleListeners) {
            return;
        }
        this.handleOnResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        if (this.mEnableLifeCycleListeners) {
            return;
        }
        this.handleOnPause(activity);
    }

    @Override
    public void release(Activity activity) {
        try {
            Logger.i(TAG, "release()");
            DeviceProperties.release();
            this.mControllerManager.unregisterConnectionReceiver((Context)activity);
            this.mControllerManager.destroy();
            this.mControllerManager = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        sInstance = null;
    }

    @Override
    public void onAdProductInitSuccess(ISNEnums.ProductType type, String demandSourceName, AdUnitsReady adUnitsReady) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnBannerListener listener;
            demandSource.setDemandSourceInitState(2);
            if (type == ISNEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVInitSuccess(adUnitsReady);
                }
            } else if (type == ISNEnums.ProductType.Interstitial) {
                OnInterstitialListener listener3 = this.getAdProductListenerAsISListener(demandSource);
                if (listener3 != null) {
                    listener3.onInterstitialInitSuccess();
                }
            } else if (type == ISNEnums.ProductType.Banner && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
                listener.onBannerInitSuccess();
            }
        }
    }

    @Override
    public void onAdProductInitFailed(ISNEnums.ProductType type, String demandSourceName, String description) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        ISNEventParams params = new ISNEventParams().addPair("demandsourcename", demandSourceName).addPair("producttype", (Object)type).addPair("callfailreason", description);
        if (demandSource != null) {
            OnBannerListener listener;
            params.addPair("isbiddinginstance", ISNEventsUtils.getIsBiddingInstance(demandSource));
            demandSource.setDemandSourceInitState(3);
            if (type == ISNEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVInitFail(description);
                }
            } else if (type == ISNEnums.ProductType.Interstitial) {
                OnInterstitialListener listener3 = this.getAdProductListenerAsISListener(demandSource);
                if (listener3 != null) {
                    listener3.onInterstitialInitFailed(description);
                }
            } else if (type == ISNEnums.ProductType.Banner && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
                listener.onBannerInitFailed(description);
            }
        }
        ISNEventsTracker.logEvent(SDK5Events.initProductFailed, params.getData());
    }

    @Override
    public void onRVNoMoreOffers(String demandSourceName) {
        OnRewardedVideoListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.RewardedVideo, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
            listener.onRVNoMoreOffers();
        }
    }

    @Override
    public void onRVAdCredited(String demandSourceName, int credits) {
        OnRewardedVideoListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.RewardedVideo, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
            listener.onRVAdCredited(credits);
        }
    }

    @Override
    public void onAdProductClose(ISNEnums.ProductType type, String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnInterstitialListener listener;
            if (type == ISNEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVAdClosed();
                }
            } else if (type == ISNEnums.ProductType.Interstitial && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
                listener.onInterstitialClose();
            }
        }
    }

    @Override
    public void onRVShowFail(String demandSourceName, String description) {
        OnRewardedVideoListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.RewardedVideo, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
            listener.onRVShowFail(description);
        }
    }

    @Override
    public void onAdProductClick(ISNEnums.ProductType type, String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnBannerListener listener;
            if (type == ISNEnums.ProductType.RewardedVideo) {
                OnRewardedVideoListener listener2 = this.getAdProductListenerAsRVListener(demandSource);
                if (listener2 != null) {
                    listener2.onRVAdClicked();
                }
            } else if (type == ISNEnums.ProductType.Interstitial) {
                OnInterstitialListener listener3 = this.getAdProductListenerAsISListener(demandSource);
                if (listener3 != null) {
                    listener3.onInterstitialClick();
                }
            } else if (type == ISNEnums.ProductType.Banner && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
                listener.onBannerClick();
            }
        }
    }

    @Override
    public void onAdProductEventNotificationReceived(ISNEnums.ProductType type, String demandSourceName, String eventName, JSONObject extData) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            try {
                OnRewardedVideoListener listener;
                if (type == ISNEnums.ProductType.Interstitial) {
                    OnInterstitialListener listener2 = this.getAdProductListenerAsISListener(demandSource);
                    if (listener2 != null) {
                        extData.put("demandSourceName", (Object)demandSourceName);
                        listener2.onInterstitialEventNotificationReceived(eventName, extData);
                    }
                } else if (type == ISNEnums.ProductType.RewardedVideo && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
                    extData.put("demandSourceName", (Object)demandSourceName);
                    listener.onRVEventNotificationReceived(eventName, extData);
                }
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void onAdProductOpen(ISNEnums.ProductType type, String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(type, demandSourceName);
        if (demandSource != null) {
            OnRewardedVideoListener listener;
            if (type == ISNEnums.ProductType.Interstitial) {
                OnInterstitialListener listener2 = this.getAdProductListenerAsISListener(demandSource);
                if (listener2 != null) {
                    listener2.onInterstitialOpen();
                }
            } else if (type == ISNEnums.ProductType.RewardedVideo && (listener = this.getAdProductListenerAsRVListener(demandSource)) != null) {
                listener.onRVAdOpened();
            }
        }
    }

    @Override
    public void onInterstitialLoadSuccess(String demandSourceName) {
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Interstitial, demandSourceName);
        ISNEventParams params = new ISNEventParams().addPair("demandsourcename", demandSourceName);
        if (demandSource != null) {
            params.addPair("producttype", (Object)ISNEventsUtils.getProductType(demandSource, ISNEnums.ProductType.Interstitial)).addPair("isbiddinginstance", ISNEventsUtils.getIsBiddingInstance(demandSource));
            OnInterstitialListener listener = this.getAdProductListenerAsISListener(demandSource);
            if (listener != null) {
                listener.onInterstitialLoadSuccess();
            }
        }
        ISNEventsTracker.logEvent(SDK5Events.loadAdSuccess, params.getData());
    }

    @Override
    public void onInterstitialLoadFailed(String demandSourceName, String description) {
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Interstitial, demandSourceName);
        ISNEventParams params = new ISNEventParams();
        params.addPair("callfailreason", description).addPair("demandsourcename", demandSourceName);
        if (demandSource != null) {
            params.addPair("producttype", (Object)ISNEventsUtils.getProductType(demandSource, ISNEnums.ProductType.Interstitial)).addPair("generalmessage", demandSource.getDemandSourceInitState() == 2 ? Events.INTIALIZED : Events.UNINTIALIZED).addPair("isbiddinginstance", ISNEventsUtils.getIsBiddingInstance(demandSource));
            OnInterstitialListener listener = this.getAdProductListenerAsISListener(demandSource);
            if (listener != null) {
                listener.onInterstitialLoadFailed(description);
            }
        }
        ISNEventsTracker.logEvent(SDK5Events.loadAdFailed, params.getData());
    }

    @Override
    public void onInterstitialShowSuccess(String demandSourceName) {
        OnInterstitialListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Interstitial, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
            listener.onInterstitialShowSuccess();
        }
    }

    @Override
    public void onInterstitialShowFailed(String demandSourceName, String description) {
        OnInterstitialListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Interstitial, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsISListener(demandSource)) != null) {
            listener.onInterstitialShowFailed(description);
        }
    }

    @Override
    public void onInterstitialAdRewarded(String demandSourceId, int amount) {
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Interstitial, demandSourceId);
        OnInterstitialListener listener = this.getAdProductListenerAsISListener(demandSource);
        if (demandSource == null || listener == null) {
            return;
        }
        listener.onInterstitialAdRewarded(demandSourceId, amount);
    }

    private DemandSource getDemandSourceByName(ISNEnums.ProductType type, String demandSourceName) {
        if (TextUtils.isEmpty((CharSequence)demandSourceName)) {
            return null;
        }
        return this.mDemandSourceManager.getDemandSourceById(type, demandSourceName);
    }

    @Override
    public void setMediationState(String productType, String demandSourceName, int state) {
        DemandSource demandSource;
        ISNEnums.ProductType product;
        if (!TextUtils.isEmpty((CharSequence)productType) && !TextUtils.isEmpty((CharSequence)demandSourceName) && (product = SDKUtils.getProductType(productType)) != null && (demandSource = this.mDemandSourceManager.getDemandSourceById(product, demandSourceName)) != null) {
            demandSource.setMediationState(state);
        }
    }

    @Override
    public void updateConsentInfo(final JSONObject consentParams) {
        this.updateConsentInToken(consentParams);
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.updateConsentInfo(consentParams);
            }
        });
    }

    private void updateConsentInToken(JSONObject consentParams) {
        if (consentParams != null && consentParams.has("gdprConsentStatus")) {
            try {
                JSONObject consentDataToUpdateInToken = new JSONObject();
                String gdprConsentStatus = consentParams.getString("gdprConsentStatus");
                boolean consentValue = Boolean.parseBoolean(gdprConsentStatus);
                consentDataToUpdateInToken.put("consent", consentValue);
                this.mTokenService.updateData(consentDataToUpdateInToken);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public ISNAdView createBanner(Activity activity, ISAdSize bannerSize) {
        String containerIdentifier = "SupersonicAds_" + this.adViewContainerCounter;
        ++this.adViewContainerCounter;
        ISNAdView isnAdView = new ISNAdView(activity, containerIdentifier, bannerSize);
        this.mControllerManager.setCommunicationWithAdView(isnAdView);
        return isnAdView;
    }

    @Override
    public void onBannerLoadSuccess(String demandSourceName) {
        OnBannerListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Banner, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
            listener.onBannerLoadSuccess();
        }
    }

    @Override
    public void onBannerLoadFail(String demandSourceName, String description) {
        OnBannerListener listener;
        DemandSource demandSource = this.getDemandSourceByName(ISNEnums.ProductType.Banner, demandSourceName);
        if (demandSource != null && (listener = this.getAdProductListenerAsBNListener(demandSource)) != null) {
            listener.onBannerLoadFail(description);
        }
    }

    @Override
    public void loadAd(Activity activity, IronSourceAdInstance adInstance, Map<String, String> loadParams) {
        this.mContextProvider.updateActivityContext(activity);
        ISNEventParams params = new ISNEventParams();
        params.addPair("isbiddinginstance", adInstance.isInAppBidding()).addPair("demandsourcename", adInstance.getName()).addPair("producttype", (Object)(adInstance.isRewarded() ? ISNEnums.ProductType.RewardedVideo : ISNEnums.ProductType.Interstitial));
        ISNEventsTracker.logEvent(SDK5Events.loadAd, params.getData());
        Logger.d(TAG, "loadAd " + adInstance.getId());
        if (adInstance.isInAppBidding()) {
            this.loadInAppBiddingAd(adInstance, loadParams);
        } else {
            this.loadInstance(adInstance, loadParams);
        }
    }

    private void loadInAppBiddingAd(IronSourceAdInstance adInstance, Map<String, String> loadParams) {
        try {
            loadParams = this.decodeADM(loadParams);
        }
        catch (Exception exception) {
            ISNEventParams params = new ISNEventParams().addPair("callfailreason", exception.getMessage()).addPair("generalmessage", adInstance.isInitialized() ? Events.INTIALIZED : Events.UNINTIALIZED).addPair("isbiddinginstance", adInstance.isInAppBidding()).addPair("demandsourcename", adInstance.getName()).addPair("producttype", (Object)(adInstance.isRewarded() ? ISNEnums.ProductType.RewardedVideo : ISNEnums.ProductType.Interstitial));
            ISNEventsTracker.logEvent(SDK5Events.parseAdmFailed, params.getData());
            exception.printStackTrace();
            Logger.d(TAG, "loadInAppBiddingAd failed decoding  ADM " + exception.getMessage());
        }
        this.loadInstance(adInstance, loadParams);
    }

    private void loadInstance(IronSourceAdInstance adInstance, Map<String, String> loadParams) {
        if (adInstance.isInitialized()) {
            this.loadInitializedInstance(adInstance, loadParams);
        } else {
            this.loadUninitializedInstance(adInstance, loadParams);
        }
    }

    private Map<String, String> decodeADM(Map<String, String> loadParams) {
        String decodedADM = "";
        String serverData = loadParams.get("adm");
        decodedADM = SDKUtils.decodeString(serverData);
        loadParams.put("adm", decodedADM);
        return loadParams;
    }

    private void loadInitializedInstance(final IronSourceAdInstance adInstance, final Map<String, String> loadParams) {
        Logger.d(TAG, "loadOnInitializedInstance " + adInstance.getId());
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                DemandSource demandSource = IronSourceAdsPublisherAgent.this.mDemandSourceManager.getDemandSourceById(ISNEnums.ProductType.Interstitial, adInstance.getId());
                if (demandSource != null) {
                    IronSourceAdsPublisherAgent.this.mControllerManager.loadInterstitial(demandSource, loadParams, IronSourceAdsPublisherAgent.this);
                }
            }
        });
    }

    private void loadUninitializedInstance(final IronSourceAdInstance adInstance, final Map<String, String> loadParams) {
        Logger.d(TAG, "loadOnNewInstance " + adInstance.getId());
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                DemandSource demandSource = IronSourceAdsPublisherAgent.this.mDemandSourceManager.createDemandSource(ISNEnums.ProductType.Interstitial, adInstance);
                ISNEventParams params = new ISNEventParams();
                params.addPair("isbiddinginstance", adInstance.isInAppBidding()).addPair("demandsourcename", adInstance.getName()).addPair("producttype", (Object)(adInstance.isRewarded() ? ISNEnums.ProductType.RewardedVideo : ISNEnums.ProductType.Interstitial));
                ISNEventsTracker.logEvent(SDK5Events.initProduct, params.getData());
                IronSourceAdsPublisherAgent.this.mControllerManager.initInterstitial(IronSourceAdsPublisherAgent.this.mApplicationKey, IronSourceAdsPublisherAgent.this.mUserId, demandSource, IronSourceAdsPublisherAgent.this);
                adInstance.setInitialized(true);
                IronSourceAdsPublisherAgent.this.mControllerManager.loadInterstitial(demandSource, loadParams, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public void showAd(IronSourceAdInstance adInstance, final Map<String, String> showParams) {
        Logger.i(TAG, "showAd " + adInstance.getId());
        final DemandSource demandSource = this.mDemandSourceManager.getDemandSourceById(ISNEnums.ProductType.Interstitial, adInstance.getId());
        if (demandSource == null) {
            return;
        }
        this.mControllerManager.executeCommand(new Runnable(){

            @Override
            public void run() {
                IronSourceAdsPublisherAgent.this.mControllerManager.showInterstitial(demandSource, showParams, IronSourceAdsPublisherAgent.this);
            }
        });
    }

    @Override
    public boolean isAdAvailable(IronSourceAdInstance adInstance) {
        Logger.d(TAG, "isAdAvailable " + adInstance.getId());
        DemandSource demandSource = this.mDemandSourceManager.getDemandSourceById(ISNEnums.ProductType.Interstitial, adInstance.getId());
        if (demandSource == null) {
            return false;
        }
        return demandSource.getAvailabilityState();
    }

    public void decideOnListeningToApplicationLifeCycleEvents(Context applicationContext, JSONObject networkConfiguration) {
        this.mEnableLifeCycleListeners = networkConfiguration.optBoolean("enableLifeCycleListeners", false);
        if (this.mEnableLifeCycleListeners) {
            try {
                ActivityLifeCycleListener activityLifeCycleListener = new ActivityLifeCycleListener(this);
                Application application = (Application)applicationContext;
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifeCycleListener);
            }
            catch (Throwable ex) {
                ISNEventParams params = new ISNEventParams();
                params.addPair("generalmessage", ex.getMessage());
                ISNEventsTracker.logEvent(SDK5Events.failedRegisterActivityLifecycle, params.getData());
            }
        }
    }

    @Override
    public void handleOnPause(Activity activity) {
        try {
            this.mControllerManager.enterBackground();
            this.mControllerManager.unregisterConnectionReceiver((Context)activity);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void handleOnResume(Activity activity) {
        this.mControllerManager.enterForeground();
        this.mControllerManager.registerConnectionReceiver((Context)activity);
    }
}

