/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.Events;

import android.content.Context;
import com.ironsource.eventsTracker.IBaseData;
import com.ironsource.network.ConnectivityUtils;
import com.ironsource.sdk.utils.DeviceProperties;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;

public class ISNEventsBaseData
implements IBaseData {
    private static Map<String, Object> baseData = new HashMap<String, Object>();

    private ISNEventsBaseData(Builder builder) {
        this.collectPermanentData(builder);
        this.collectMutableData(builder.context);
    }

    private void collectMutableData(Context context) {
        baseData.put("connectiontype", ConnectivityUtils.getConnectionType(context));
    }

    private void collectPermanentData(Builder builder) {
        Context context = builder.context;
        DeviceProperties instance = DeviceProperties.getInstance(context);
        baseData.put("deviceos", SDKUtils.encodeString(instance.getDeviceOsType()));
        baseData.put("deviceosversion", SDKUtils.encodeString(instance.getDeviceOsVersion()));
        baseData.put("deviceapilevel", instance.getDeviceApiLevel());
        baseData.put("deviceoem", SDKUtils.encodeString(instance.getDeviceOem()));
        baseData.put("devicemodel", SDKUtils.encodeString(instance.getDeviceModel()));
        baseData.put("bundleid", SDKUtils.encodeString(context.getPackageName()));
        baseData.put("applicationkey", SDKUtils.encodeString(builder.applicationKey));
        baseData.put("sessionid", SDKUtils.encodeString(builder.sessionId));
        baseData.put("sdkversion", SDKUtils.encodeString(DeviceProperties.getSupersonicSdkVersion()));
        baseData.put("applicationuserid", SDKUtils.encodeString(builder.userId));
        baseData.put("env", "prod");
        baseData.put("origin", "n");
    }

    @Override
    public Map<String, Object> getData() {
        return baseData;
    }

    public static void setConnectionType(String connectionType) {
        baseData.put("connectiontype", SDKUtils.encodeString(connectionType));
    }

    public static class Builder {
        String sessionId;
        String applicationKey;
        String integrationType;
        Context context;
        String userId;

        Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        Builder setIntegrationType(String integration) {
            this.integrationType = integration;
            return this;
        }

        Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        Builder setApplicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public ISNEventsBaseData build() {
            return new ISNEventsBaseData(this);
        }
    }
}

