/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.ironsource.mediationsdk.logger.IronLog;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IronSourceAES {
    public static synchronized String encode(String keyString, String stringToEncode) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)stringToEncode)) {
            return "";
        }
        try {
            byte[] clearText = stringToEncode.getBytes("UTF8");
            return IronSourceAES.encodeFromBytes(keyString, clearText);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public static synchronized String encodeFromBytes(String keyString, byte[] bytesToEncode) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return "";
        }
        if (bytesToEncode == null) {
            return "";
        }
        try {
            SecretKeySpec skeySpec = IronSourceAES.getKey(keyString);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(1, (Key)skeySpec, ivParameterSpec);
            String encrypedValue = Base64.encodeToString((byte[])cipher.doFinal(bytesToEncode), (int)0);
            encrypedValue = encrypedValue.replaceAll(System.getProperty("line.separator"), "");
            return encrypedValue;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public static synchronized String decode(String keyString, String stringToDecode) {
        byte[] decodedBytes = IronSourceAES.decodeToBytes(keyString, stringToDecode);
        if (decodedBytes != null) {
            return new String(decodedBytes);
        }
        return "";
    }

    public static synchronized byte[] decodeToBytes(String keyString, String stringToDecode) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)stringToDecode)) {
            return null;
        }
        try {
            SecretKeySpec key = IronSourceAES.getKey(keyString);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            byte[] encrypedPwdBytes = Base64.decode((String)stringToDecode, (int)0);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)key, ivParameterSpec);
            byte[] decryptedValueBytes = cipher.doFinal(encrypedPwdBytes);
            return decryptedValueBytes;
        }
        catch (Exception e2) {
            IronLog.INTERNAL.error("exception on decryption error: " + e2.getMessage());
            e2.printStackTrace();
            return null;
        }
    }

    private static SecretKeySpec getKey(String key) throws UnsupportedEncodingException {
        int keyLength = 256;
        byte[] keyBytes = new byte[keyLength / 8];
        Arrays.fill(keyBytes, (byte)0);
        byte[] passwordBytes = key.getBytes("UTF-8");
        int length = passwordBytes.length < keyBytes.length ? passwordBytes.length : keyBytes.length;
        System.arraycopy(passwordBytes, 0, keyBytes, 0, length);
        return new SecretKeySpec(keyBytes, "AES");
    }
}

