/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class IronsourceObjectPublisherDataHolder {
    private static IronsourceObjectPublisherDataHolder sInstance;
    private final HashSet<ImpressionDataListener> impressionDataListeners = new HashSet();
    private ConcurrentHashMap<String, List<String>> mediationMetaData = new ConcurrentHashMap();

    public static synchronized IronsourceObjectPublisherDataHolder getInstance() {
        if (sInstance == null) {
            sInstance = new IronsourceObjectPublisherDataHolder();
        }
        return sInstance;
    }

    IronsourceObjectPublisherDataHolder() {
    }

    public HashSet<ImpressionDataListener> getImpressionDataListeners() {
        return this.impressionDataListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImpressionDataListener(@NotNull ImpressionDataListener impressionDataListener) {
        IronsourceObjectPublisherDataHolder ironsourceObjectPublisherDataHolder = this;
        synchronized (ironsourceObjectPublisherDataHolder) {
            this.impressionDataListeners.add(impressionDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImpressionDataListener(@NotNull ImpressionDataListener impressionDataListener) {
        IronsourceObjectPublisherDataHolder ironsourceObjectPublisherDataHolder = this;
        synchronized (ironsourceObjectPublisherDataHolder) {
            this.impressionDataListeners.remove(impressionDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllImpressionDataListeners() {
        IronsourceObjectPublisherDataHolder ironsourceObjectPublisherDataHolder = this;
        synchronized (ironsourceObjectPublisherDataHolder) {
            this.impressionDataListeners.clear();
        }
    }

    public ConcurrentHashMap<String, List<String>> getMediationMetaData() {
        return this.mediationMetaData;
    }

    public void setMetaData(String key, List<String> values) {
        this.mediationMetaData.put(key, values);
    }
}

