/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.environment.StringUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdaptersCompatibilityHandler {
    private static final AdaptersCompatibilityHandler instance = new AdaptersCompatibilityHandler();
    private final ConcurrentHashMap<String, String> mAdapterNameToMinIsVersion = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> mAdapterNameToMinRvVersion;

    public static AdaptersCompatibilityHandler getInstance() {
        return instance;
    }

    private AdaptersCompatibilityHandler() {
        this.mAdapterNameToMinIsVersion.put("adcolony", "4.1.6");
        this.mAdapterNameToMinIsVersion.put("vungle", "4.1.5");
        this.mAdapterNameToMinIsVersion.put("applovin", "4.3.3");
        this.mAdapterNameToMinIsVersion.put("admob", "4.3.2");
        this.mAdapterNameToMinRvVersion = new ConcurrentHashMap();
        this.mAdapterNameToMinRvVersion.put("adcolony", "4.1.6");
        this.mAdapterNameToMinRvVersion.put("admob", "4.3.2");
        this.mAdapterNameToMinRvVersion.put("applovin", "4.3.3");
        this.mAdapterNameToMinRvVersion.put("chartboost", "4.1.9");
        this.mAdapterNameToMinRvVersion.put("fyber", "4.1.0");
        this.mAdapterNameToMinRvVersion.put("hyprmx", "4.1.2");
        this.mAdapterNameToMinRvVersion.put("inmobi", "4.3.1");
        this.mAdapterNameToMinRvVersion.put("maio", "4.1.3");
        this.mAdapterNameToMinRvVersion.put("tapjoy", "4.0.0");
        this.mAdapterNameToMinRvVersion.put("unityads", "4.1.4");
        this.mAdapterNameToMinRvVersion.put("vungle", "4.1.5");
    }

    public boolean isAdapterVersionRVCompatible(AbstractAdapter adapter) {
        return this.isAdapterVersionCompatible(adapter, this.mAdapterNameToMinRvVersion, "rewarded video");
    }

    public boolean isAdapterVersionISCompatible(AbstractAdapter adapter) {
        return this.isAdapterVersionCompatible(adapter, this.mAdapterNameToMinIsVersion, "interstitial");
    }

    private boolean isAdapterVersionCompatible(AbstractAdapter adapter, Map<String, String> mAdapterNameToMinVersion, String adUnit) {
        String adapterVersion;
        if (adapter == null) {
            return false;
        }
        String adapterName = StringUtils.toLowerCase(adapter.getProviderName());
        if (!mAdapterNameToMinVersion.containsKey(adapterName)) {
            return true;
        }
        String minAcceptedVersion = mAdapterNameToMinVersion.get(adapterName);
        boolean isCompatible = this.isVersionGreaterOrEqual(minAcceptedVersion, adapterVersion = adapter.getVersion());
        if (!isCompatible) {
            String message = adapter.getProviderName() + " adapter " + adapterVersion + " is incompatible with SDK version " + IronSourceUtils.getSDKVersion() + " for " + adUnit + " ad unit, please update your adapter to the latest version";
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, message, 3);
        }
        return isCompatible;
    }

    public boolean isBannerAdapterCompatible(AbstractAdapter adapter) {
        if (adapter == null) {
            return false;
        }
        String adapterVersion = adapter.getVersion();
        boolean isCompatible = this.isVersionGreaterOrEqual("4.3.0", adapterVersion);
        if (!isCompatible) {
            String message = adapter.getProviderName() + " adapter " + adapterVersion + " is incompatible with SDK version " + IronSourceUtils.getSDKVersion() + ", please update your adapter to the latest version";
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, message, 3);
        }
        return isCompatible;
    }

    private boolean isVersionGreaterOrEqual(String minAcceptedVersion, String adapterVersion) {
        if (minAcceptedVersion.equalsIgnoreCase(adapterVersion)) {
            return true;
        }
        String[] minAcceptedVersionArr = minAcceptedVersion.split("\\.");
        String[] adapterVersionArr = adapterVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int minDigit = Integer.parseInt(minAcceptedVersionArr[i]);
            int adapterDigit = Integer.parseInt(adapterVersionArr[i]);
            if (adapterDigit < minDigit) {
                return false;
            }
            if (adapterDigit <= minDigit) continue;
            return true;
        }
        return true;
    }
}

