/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.ironsource.environment.CrashReporter;
import com.ironsource.environment.ExceptionLog;
import java.util.ArrayList;
import java.util.List;

public class DbHandler
extends SQLiteOpenHelper {
    public DbHandler(Context context) {
        super(context, "reports", null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        String CREATE_CONTACTS_TABLE = "CREATE TABLE IF NOT EXISTS REPORTS(id INTEGER PRIMARY KEY AUTOINCREMENT , stack_trace TEXT NOT NULL, crash_date TEXT NOT NULL );";
        db.execSQL(CREATE_CONTACTS_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReport(ExceptionLog report) {
        DbHandler dh = new DbHandler(CrashReporter.getInstance().getContext());
        SQLiteDatabase db = dh.getWritableDatabase();
        db.beginTransaction();
        try {
            ContentValues values = new ContentValues();
            String stackTrace = report.getStacktrace();
            String date = report.getDate();
            values.put("stack_trace", stackTrace);
            values.put("crash_date", date);
            db.insert("REPORTS", null, values);
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    public static ExceptionLog getReportById(int id) {
        DbHandler dh = new DbHandler(CrashReporter.getInstance().getContext());
        SQLiteDatabase db = dh.getReadableDatabase();
        String query = "SELECT * FROM REPORTSWHERE id= " + id + ";";
        Cursor cursor = db.rawQuery(query, null);
        int reportId = cursor.getInt(0);
        String stackTrace = cursor.getString(1);
        String reportDate = cursor.getString(2);
        cursor.close();
        db.close();
        return new ExceptionLog(reportId, stackTrace, reportDate);
    }

    public static Cursor getExceptionCursorById(int id) {
        DbHandler dh = new DbHandler(CrashReporter.getInstance().getContext());
        SQLiteDatabase db = dh.getReadableDatabase();
        String query = "SELECT * FROM REPORTSWHERE id= " + id + ";";
        return db.rawQuery(query, null);
    }

    public static List<ExceptionLog> getAllReports() {
        DbHandler dh = new DbHandler(CrashReporter.getInstance().getContext());
        ArrayList<ExceptionLog> reportList = new ArrayList<ExceptionLog>();
        String selectQuery = "SELECT * FROM REPORTS ;";
        SQLiteDatabase db = dh.getReadableDatabase();
        Cursor cursor = db.rawQuery(selectQuery, null);
        if (cursor.moveToFirst()) {
            do {
                int id = cursor.getInt(0);
                String stackTrace = cursor.getString(1);
                String crashDate = cursor.getString(2);
                ExceptionLog report = new ExceptionLog(id, stackTrace, crashDate);
                reportList.add(report);
            } while (cursor.moveToNext());
        }
        cursor.close();
        db.close();
        return reportList;
    }

    public static Cursor getExceptionsCursor() {
        DbHandler dh = new DbHandler(CrashReporter.getInstance().getContext());
        ArrayList reportList = new ArrayList();
        String selectQuery = "SELECT * FROM REPORTS;";
        SQLiteDatabase db = dh.getReadableDatabase();
        return db.rawQuery(selectQuery, null);
    }

    public static void deleteAllReports() {
        DbHandler dh = new DbHandler(CrashReporter.getInstance().getContext());
        SQLiteDatabase db = dh.getWritableDatabase();
        String DELETE_ALL_REPORTS = "DELETE FROM REPORTS WHERE id >= 0;";
        db.execSQL(DELETE_ALL_REPORTS);
        db.close();
    }
}

