/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.ISNEventsUtils;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.controller.AdViewsJSAdapter;
import com.ironsource.sdk.controller.BannerJSAdapter;
import com.ironsource.sdk.controller.CommandExecutor;
import com.ironsource.sdk.controller.ControllerEventListener;
import com.ironsource.sdk.controller.DemandSourceManager;
import com.ironsource.sdk.controller.DeviceDataJSAdapter;
import com.ironsource.sdk.controller.IronSourceController;
import com.ironsource.sdk.controller.NativeController;
import com.ironsource.sdk.controller.OMIDJSAdapter;
import com.ironsource.sdk.controller.PermissionsJSAdapter;
import com.ironsource.sdk.controller.TokenJSAdapter;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.ISNEnums;
import com.ironsource.sdk.data.ISNError;
import com.ironsource.sdk.listeners.OnNetworkSDKInitListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.internals.DSBannerListener;
import com.ironsource.sdk.listeners.internals.DSInterstitialListener;
import com.ironsource.sdk.listeners.internals.DSRewardedVideoListener;
import com.ironsource.sdk.service.TokenService;
import com.ironsource.sdk.utils.Logger;
import java.util.Map;
import org.json.JSONObject;

public class ControllerManager
implements ControllerEventListener,
IronSourceController {
    private String TAG = ControllerManager.class.getSimpleName();
    private IronSourceController mController;
    private ISNEnums.ControllerState mControllerState = ISNEnums.ControllerState.None;
    private CountDownTimer mGlobalControllerTimer;
    private CommandExecutor mCommandExecutor = new CommandExecutor("NativeCommandExecutor");
    private CommandExecutor mControllerCommandsExecutor = new CommandExecutor("ControllerCommandsExecutor");
    private static final Handler mUiHandler = new Handler(Looper.getMainLooper());

    public ControllerManager(Activity activity, TokenService tokenService, DemandSourceManager demandSourceManager) {
        this.createController(activity, tokenService, demandSourceManager);
    }

    private void createController(final Activity activity, final TokenService tokenService, final DemandSourceManager demandSourceManager) {
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ControllerManager.this.createWebController(activity, tokenService, demandSourceManager);
                }
                catch (Exception ex) {
                    ControllerManager.this.createNativeController(Log.getStackTraceString((Throwable)ex));
                }
            }
        });
    }

    private void createWebController(Activity activity, TokenService tokenService, DemandSourceManager demandSourceManager) throws Exception {
        ISNEventsTracker.logEvent(SDK5Events.createControllerWeb);
        this.mController = new WebController(activity, demandSourceManager, this);
        WebController controller = (WebController)this.mController;
        controller.addTokenJSInterface(new TokenJSAdapter(activity.getApplicationContext(), tokenService));
        controller.addOmidJSInterface(new OMIDJSAdapter(activity.getApplicationContext()));
        controller.addPermissionsJSInterface(new PermissionsJSAdapter(activity.getApplicationContext()));
        controller.addBannerJSInterface(new BannerJSAdapter());
        controller.addDeviceDataJSInterface(new DeviceDataJSAdapter(activity.getApplicationContext()));
        controller.addAdViewsJSInterface(new AdViewsJSAdapter(activity));
        this.mGlobalControllerTimer = new CountDownTimer(200000L, 1000L){

            public void onTick(long millisUntilFinished) {
                Logger.i(ControllerManager.this.TAG, "Global Controller Timer Tick " + millisUntilFinished);
            }

            public void onFinish() {
                Logger.i(ControllerManager.this.TAG, "Global Controller Timer Finish");
                ControllerManager.this.destroyWebControllerIfExist();
                mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ControllerManager.this.createNativeController("controller html - download timeout");
                    }
                });
            }
        }.start();
        controller.downloadController();
        this.mCommandExecutor.setReady();
        this.mCommandExecutor.purgeDelayedCommands();
    }

    private void destroyWebControllerIfExist() {
        if (this.mController != null) {
            this.mController.destroy();
        }
    }

    private void createNativeController(String errorReason) {
        ISNEventsTracker.logEvent(SDK5Events.createControllerNative, new ISNEventParams().addPair("callfailreason", errorReason).getData());
        this.mController = new NativeController(this);
        ((NativeController)this.mController).setFailedControllerReason(errorReason);
        this.mCommandExecutor.setReady();
        this.mCommandExecutor.purgeDelayedCommands();
    }

    private boolean isControllerStateReady() {
        return ISNEnums.ControllerState.Ready.equals((Object)this.mControllerState);
    }

    public void executeCommand(Runnable runnable) {
        this.mCommandExecutor.executeCommand(runnable);
    }

    @Override
    public void handleControllerLoaded() {
        this.mControllerState = ISNEnums.ControllerState.Loaded;
    }

    @Override
    public void handleControllerReady() {
        if (ISNEnums.ControllerType.Web.equals((Object)this.getType())) {
            ISNEventsTracker.logEvent(SDK5Events.controllerStageReady);
            this.reportInitSDKSuccessToCaller();
        }
        this.handleReadyState();
    }

    private void handleReadyState() {
        this.mControllerState = ISNEnums.ControllerState.Ready;
        if (this.mGlobalControllerTimer != null) {
            this.mGlobalControllerTimer.cancel();
        }
        this.mControllerCommandsExecutor.setReady();
        this.mControllerCommandsExecutor.purgeDelayedCommands();
        this.mController.restoreSavedState();
    }

    private void reportInitSDKSuccessToCaller() {
        OnNetworkSDKInitListener initSDKListener = IronSourceNetwork.getInitListener();
        if (initSDKListener != null) {
            initSDKListener.onSuccess();
        }
    }

    @Override
    public void handleControllerFailed(final String failureReason) {
        ISNEventsTracker.logEvent(SDK5Events.controllerFailed, new ISNEventParams().addPair("callfailreason", failureReason).getData());
        this.reportInitSDKFailedToCaller(failureReason);
        if (this.mGlobalControllerTimer != null) {
            this.mGlobalControllerTimer.cancel();
        }
        this.destroyWebControllerIfExist();
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.createNativeController(failureReason);
            }
        });
    }

    private void reportInitSDKFailedToCaller(String failReason) {
        OnNetworkSDKInitListener initSDKListener = IronSourceNetwork.getInitListener();
        if (initSDKListener != null) {
            initSDKListener.onFail(new ISNError(1001, failReason));
        }
    }

    @Override
    public ISNEnums.ControllerType getType() {
        return this.mController.getType();
    }

    @Override
    public void initOfferWall(final String applicationKey, final String userId, final Map<String, String> extraParameters, final OnOfferWallListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initOfferWall(applicationKey, userId, extraParameters, listener);
            }
        });
    }

    @Override
    public void showOfferWall(final Map<String, String> extraParameters) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showOfferWall(extraParameters);
            }
        });
    }

    @Override
    public void getOfferWallCredits(final String applicationKey, final String userId, final OnOfferWallListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.getOfferWallCredits(applicationKey, userId, listener);
            }
        });
    }

    @Override
    public void initRewardedVideo(final String applicationKey, final String userId, final DemandSource demandSource, final DSRewardedVideoListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initRewardedVideo(applicationKey, userId, demandSource, listener);
            }
        });
    }

    @Override
    public void showRewardedVideo(final JSONObject showParams, final DSRewardedVideoListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showRewardedVideo(showParams, listener);
            }
        });
    }

    @Override
    public void initInterstitial(final String applicationKey, final String userId, final DemandSource demandSource, final DSInterstitialListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initInterstitial(applicationKey, userId, demandSource, listener);
            }
        });
    }

    @Override
    public void loadInterstitial(final String demandSourceName, final DSInterstitialListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.loadInterstitial(demandSourceName, listener);
            }
        });
    }

    @Override
    public void loadInterstitial(final DemandSource demandSource, final Map<String, String> loadParams, final DSInterstitialListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ISNEventParams params = new ISNEventParams().addPair("demandsourcename", demandSource.getDemandSourceName()).addPair("producttype", (Object)ISNEventsUtils.getProductType(demandSource, ISNEnums.ProductType.Interstitial)).addPair("isbiddinginstance", ISNEventsUtils.getIsBiddingInstance(demandSource));
                ISNEventsTracker.logEvent(SDK5Events.loadProduct, params.getData());
                ControllerManager.this.mController.loadInterstitial(demandSource, loadParams, listener);
            }
        });
    }

    @Override
    public void showInterstitial(final JSONObject showParams, final DSInterstitialListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showInterstitial(showParams, listener);
            }
        });
    }

    @Override
    public void showInterstitial(final DemandSource demandSource, final Map<String, String> showParams, final DSInterstitialListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.showInterstitial(demandSource, showParams, listener);
            }
        });
    }

    @Override
    public boolean isInterstitialAdAvailable(String demandSourceName) {
        if (!this.isControllerStateReady()) {
            return false;
        }
        return this.mController.isInterstitialAdAvailable(demandSourceName);
    }

    @Override
    public void initBanner(final String applicationKey, final String userId, final DemandSource demandSource, final DSBannerListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.initBanner(applicationKey, userId, demandSource, listener);
            }
        });
    }

    @Override
    public void loadBanner(final JSONObject loadParams, final DSBannerListener listener) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.loadBanner(loadParams, listener);
            }
        });
    }

    @Override
    public void updateConsentInfo(final JSONObject consentParams) {
        this.mControllerCommandsExecutor.executeCommand(new Runnable(){

            @Override
            public void run() {
                ControllerManager.this.mController.updateConsentInfo(consentParams);
            }
        });
    }

    @Override
    public void enterForeground() {
        if (this.isControllerStateReady()) {
            this.mController.enterForeground();
        }
    }

    @Override
    public void enterBackground() {
        if (this.isControllerStateReady()) {
            this.mController.enterBackground();
        }
    }

    @Override
    public void registerConnectionReceiver(Context context) {
        if (this.isControllerStateReady()) {
            this.mController.registerConnectionReceiver(context);
        }
    }

    @Override
    public void unregisterConnectionReceiver(Context context) {
        if (this.isControllerStateReady()) {
            this.mController.unregisterConnectionReceiver(context);
        }
    }

    @Override
    public void destroy() {
        if (this.mGlobalControllerTimer != null) {
            this.mGlobalControllerTimer.cancel();
        }
        this.mGlobalControllerTimer = null;
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ControllerManager.this.mController != null) {
                    ControllerManager.this.mController.destroy();
                    ControllerManager.this.mController = null;
                }
            }
        });
    }

    @Override
    @Deprecated
    public void restoreSavedState() {
    }

    public IronSourceController getController() {
        return this.mController;
    }

    @Override
    public void setCommunicationWithAdView(ISNAdView isnAdView) {
        if (this.mController != null) {
            this.mController.setCommunicationWithAdView(isnAdView);
        }
    }
}

