/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.Events;

import android.app.Activity;
import android.util.Pair;
import com.ironsource.eventsTracker.EventsConfiguration;
import com.ironsource.sdk.Events.ISNEventsBaseData;
import com.ironsource.sdk.Events.ISNEventsFormatter;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.ISNEnums;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONObject;

public class ISNEventsUtils {
    public static ISNEventsBaseData createEventsBaseData(Activity activity, String userId, String applicationKey, Map<String, String> initParams) throws Exception {
        ISNEventsBaseData.Builder baseDataBuilder = new ISNEventsBaseData.Builder();
        if (initParams != null && initParams.containsKey("sessionid")) {
            baseDataBuilder.setSessionId(initParams.get("sessionid"));
        }
        if (activity != null) {
            baseDataBuilder.setContext(activity.getApplicationContext());
        }
        return baseDataBuilder.setUserId(userId).setApplicationKey(applicationKey).build();
    }

    public static EventsConfiguration createConfigurations(JSONObject eventConfig) {
        return new EventsConfiguration.Builder(eventConfig.optString("endpoint")).setHttpMethodGet().setEnableEvents(eventConfig.optBoolean("enabled")).setFormatter(new ISNEventsFormatter()).addHeaders(ISNEventsUtils.createHeaders()).setAllowLogs(false).build();
    }

    private static ArrayList<Pair<String, String>> createHeaders() {
        ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        headers.add(new Pair((Object)"Content-Type", (Object)"application/json"));
        headers.add(new Pair((Object)"charset", (Object)"utf-8"));
        return headers;
    }

    public static boolean getIsBiddingInstance(DemandSource demandSource) {
        if (demandSource == null) {
            return false;
        }
        if (demandSource.getExtraParams().get("inAppBidding") == null) {
            return false;
        }
        return Boolean.parseBoolean(demandSource.getExtraParams().get("inAppBidding"));
    }

    public static ISNEnums.ProductType getProductType(DemandSource demandSource, ISNEnums.ProductType product) {
        if (demandSource == null) {
            return product;
        }
        if (demandSource.getExtraParams() == null) {
            return product;
        }
        if (demandSource.getExtraParams().get("rewarded") == null) {
            return product;
        }
        return Boolean.parseBoolean(demandSource.getExtraParams().get("rewarded")) ? ISNEnums.ProductType.RewardedVideo : ISNEnums.ProductType.Interstitial;
    }
}

