/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.model;

import android.text.TextUtils;
import com.ironsource.mediationsdk.model.ApplicationEvents;
import com.ironsource.mediationsdk.model.OfferwallPlacement;
import java.util.ArrayList;
import org.json.JSONObject;

public class OfferwallConfigurations {
    private ArrayList<OfferwallPlacement> mOWPlacements;
    private static final int DEFAULT_OW_PLACEMENT_ID = 0;
    private static final String ADAPTER_NAME = "adapterName";
    private OfferwallPlacement mDefaultOWPlacement;
    private ApplicationEvents mEvents;
    private JSONObject mOWSection;

    public OfferwallConfigurations(ApplicationEvents events) {
        this.mEvents = events;
        this.mOWPlacements = new ArrayList();
    }

    public void addOfferwallPlacement(OfferwallPlacement placement) {
        if (placement != null) {
            this.mOWPlacements.add(placement);
            if (this.mDefaultOWPlacement == null) {
                this.mDefaultOWPlacement = placement;
            } else if (placement.getPlacementId() == 0) {
                this.mDefaultOWPlacement = placement;
            }
        }
    }

    public OfferwallPlacement getOfferwallPlacement(String placementName) {
        for (OfferwallPlacement placement : this.mOWPlacements) {
            if (!placement.getPlacementName().equals(placementName)) continue;
            return placement;
        }
        return null;
    }

    public OfferwallPlacement getDefaultOfferwallPlacement() {
        for (OfferwallPlacement placement : this.mOWPlacements) {
            if (!placement.isDefault()) continue;
            return placement;
        }
        return this.mDefaultOWPlacement;
    }

    public ApplicationEvents getOfferWallEventsConfigurations() {
        return this.mEvents;
    }

    public String getOfferWallAdapterName() {
        if (this.mOWSection != null && !TextUtils.isEmpty((CharSequence)this.mOWSection.optString(ADAPTER_NAME))) {
            return this.mOWSection.optString(ADAPTER_NAME);
        }
        return "SupersonicAds";
    }

    public void setOfferWallSection(JSONObject owSection) {
        this.mOWSection = owSection;
    }
}

