/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import com.ironsource.mediationsdk.LWSProgRvSmash;
import com.ironsource.mediationsdk.LoadWhileShowSupportState;
import com.ironsource.mediationsdk.logger.IronLog;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class WaterfallLifeCycleHolder {
    private static String TAG = "WaterfallLifeCycleHolder";
    ConcurrentHashMap<String, CopyOnWriteArrayList<LWSProgRvSmash>> waterfalls = new ConcurrentHashMap();
    private String currentWaterfallId = "";
    private String previousWaterfallId = "";
    private LWSProgRvSmash showingSmash;
    private List<String> disableLoadWhileShowSupportNetworks;
    private int timeToDeleteOldWaterfallAfterAuction;
    private Timer timer = new Timer();

    public WaterfallLifeCycleHolder(List<String> disableLoadWhileShowSupportNetworks, int timeToDeleteOldWaterfallAfterAuction) {
        this.disableLoadWhileShowSupportNetworks = disableLoadWhileShowSupportNetworks;
        this.timeToDeleteOldWaterfallAfterAuction = timeToDeleteOldWaterfallAfterAuction;
    }

    public void setShowingSmash(LWSProgRvSmash showingSmash) {
        this.showingSmash = showingSmash;
    }

    public LWSProgRvSmash getShowingSmash() {
        return this.showingSmash;
    }

    public CopyOnWriteArrayList<LWSProgRvSmash> getCurrentWaterfall() {
        CopyOnWriteArrayList<LWSProgRvSmash> currentWaterfall = this.waterfalls.get(this.currentWaterfallId);
        if (currentWaterfall == null) {
            currentWaterfall = new CopyOnWriteArrayList();
        }
        return currentWaterfall;
    }

    public String getCurrentWaterfallId() {
        return this.currentWaterfallId;
    }

    public boolean shouldAddSmashToWaterfallRequest(LWSProgRvSmash smash) {
        boolean shouldNotAddSmashToWaterfallRequest = false;
        if (smash == null) {
            shouldNotAddSmashToWaterfallRequest = true;
        } else if (this.showingSmash == null) {
            shouldNotAddSmashToWaterfallRequest = false;
        } else if (smash.getLoadWhileShowSupportState() == LoadWhileShowSupportState.LOAD_WHILE_SHOW_BY_NETWORK && this.showingSmash.getInstanceName().equals(smash.getInstanceName())) {
            shouldNotAddSmashToWaterfallRequest = true;
        } else if ((smash.getLoadWhileShowSupportState() == LoadWhileShowSupportState.NONE || this.disableLoadWhileShowSupportNetworks.contains(smash.getNameForReflection())) && this.showingSmash.getNameForReflection().equals(smash.getNameForReflection())) {
            shouldNotAddSmashToWaterfallRequest = true;
        }
        if (shouldNotAddSmashToWaterfallRequest && smash != null) {
            IronLog.INTERNAL.info(smash.getInstanceName() + " does not support load while show and will not be added to the auction request");
        }
        return !shouldNotAddSmashToWaterfallRequest;
    }

    public void updateWaterFall(CopyOnWriteArrayList<LWSProgRvSmash> smashesFromWaterfall, String currentWaterfallId) {
        IronLog.INTERNAL.info("updating new  waterfall with id " + currentWaterfallId);
        this.waterfalls.put(currentWaterfallId, smashesFromWaterfall);
        if (!TextUtils.isEmpty((CharSequence)this.previousWaterfallId)) {
            if (this.isPreviousWaterfallShowing()) {
                IronLog.INTERNAL.info("ad from previous waterfall " + this.previousWaterfallId + " is still showing - the current waterfall " + this.currentWaterfallId + " will be deleted instead");
                String temp = this.currentWaterfallId;
                this.currentWaterfallId = this.previousWaterfallId;
                this.previousWaterfallId = temp;
            }
            final String waterFallIdToDelete = this.previousWaterfallId;
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        IronLog.INTERNAL.info("removing waterfall with id " + waterFallIdToDelete + " from memory");
                        WaterfallLifeCycleHolder.this.waterfalls.remove(waterFallIdToDelete);
                        IronLog.INTERNAL.info("waterfall size is currently " + WaterfallLifeCycleHolder.this.waterfalls.size());
                    }
                    finally {
                        this.cancel();
                    }
                }
            }, this.timeToDeleteOldWaterfallAfterAuction);
        }
        this.previousWaterfallId = this.currentWaterfallId;
        this.currentWaterfallId = currentWaterfallId;
    }

    public int getNumberOfWaterfalls() {
        return this.waterfalls.size();
    }

    public boolean areWaterFallsOverMaximum() {
        return this.waterfalls.size() > 5;
    }

    public boolean isPreviousWaterfallShowing() {
        return this.showingSmash != null && this.showingSmash.getAuctionId().equals(this.previousWaterfallId);
    }
}

