/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.BannerCallbackThrottler;
import com.ironsource.mediationsdk.BannerData;
import com.ironsource.mediationsdk.BannerManager;
import com.ironsource.mediationsdk.CallbackThrottler;
import com.ironsource.mediationsdk.DemandOnlyIsManager;
import com.ironsource.mediationsdk.DemandOnlyRvManager;
import com.ironsource.mediationsdk.IProgRvManager;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.ISDemandOnlyListenerWrapper;
import com.ironsource.mediationsdk.ISListenerWrapper;
import com.ironsource.mediationsdk.InterstitialManager;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceSegment;
import com.ironsource.mediationsdk.IronsourceObjectPublisherDataHolder;
import com.ironsource.mediationsdk.LWSProgRvManager;
import com.ironsource.mediationsdk.MediationInitializer;
import com.ironsource.mediationsdk.OfferwallManager;
import com.ironsource.mediationsdk.ProgBannerManager;
import com.ironsource.mediationsdk.ProgIsManager;
import com.ironsource.mediationsdk.ProgRvManager;
import com.ironsource.mediationsdk.RVDemandOnlyListenerWrapper;
import com.ironsource.mediationsdk.RVListenerWrapper;
import com.ironsource.mediationsdk.RewardedVideoManager;
import com.ironsource.mediationsdk.RewardedVideoSmash;
import com.ironsource.mediationsdk.config.ConfigValidationResult;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.events.SuperLooper;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.logger.LogListener;
import com.ironsource.mediationsdk.logger.PublisherLogger;
import com.ironsource.mediationsdk.metadata.MetaData;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.model.ApplicationEvents;
import com.ironsource.mediationsdk.model.BannerConfigurations;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.model.OfferwallPlacement;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.ironsource.mediationsdk.sdk.IronSourceInterface;
import com.ironsource.mediationsdk.sdk.ListenersWrapper;
import com.ironsource.mediationsdk.sdk.OfferwallListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.ironsource.mediationsdk.sdk.SegmentListener;
import com.ironsource.mediationsdk.server.HttpFunctions;
import com.ironsource.mediationsdk.server.ServerURL;
import com.ironsource.mediationsdk.utilities.IronSourcePreconditions;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.GeneralPropertiesWorker;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceTempUtils;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.ServerResponseWrapper;
import com.ironsource.mediationsdk.utils.TokenSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceObject
implements IronSourceInterface,
MediationInitializer.OnMediationInitializationListener {
    private final String TAG = this.getClass().getName();
    private final String IRONSOURCE_VERSION_STRING = "!SDK-VERSION-STRING!:com.ironsource:mediationsdk:\u200b7.1.0";
    private AbstractAdapter mOfferwallAdapter;
    private RewardedVideoManager mRewardedVideoManager;
    private InterstitialManager mInterstitialManager;
    private OfferwallManager mOfferwallManager;
    private BannerManager mBannerManager;
    private IronSourceLoggerManager mLoggerManager;
    private ListenersWrapper mListenersWrapper;
    private PublisherLogger mPublisherLogger;
    private AtomicBoolean mEventManagersInit;
    private final Object mServerResponseLocker = new Object();
    private ServerResponseWrapper mCurrentServerResponse = null;
    private String mAppKey = null;
    private String mUserId = null;
    private String mSegment = null;
    private String mDynamicUserId = null;
    private Map<String, String> mRvServerParams = null;
    private String mMediationType = null;
    private AtomicBoolean mAtomicIsFirstInit;
    private boolean mInitSucceeded = false;
    private List<IronSource.AD_UNIT> mInitiatedAdUnits;
    private String mSessionId = null;
    private Context mTrackNetworkStateContext;
    private Boolean mShouldTrackNetworkState = null;
    private Activity mActivity;
    private Set<IronSource.AD_UNIT> mAdUnitsToInitialize;
    private Set<IronSource.AD_UNIT> mRequestedAdUnits;
    private boolean mShouldSendGetInstanceEvent = true;
    private IronSourceSegment mIronSegment;
    private final String KEY_INIT_COUNTER = "sessionDepth";
    private int mInitCounter;
    private static IronSourceObject sInstance;
    private boolean mIsDemandOnlyRv;
    private boolean mIsDemandOnlyIs;
    private boolean mDidInitRewardedVideo;
    private boolean mDidInitInterstitial;
    private boolean mDidInitBanner;
    private Boolean mIsBnLoadBeforeInitCompleted;
    private IronSourceBannerLayout mBnLayoutToLoad;
    private String mBnPlacementToLoad;
    private Boolean mConsent = null;
    private IProgRvManager mProgRvManager;
    private ProgIsManager mProgIsManager;
    private ProgBannerManager mProgBannerManager;
    private boolean mIsRvProgrammatic;
    private boolean mIsIsProgrammatic;
    private boolean mIsIsLoadBeforeInitCompleted;
    private boolean mIsBnProgrammatic;
    private int rvProgrammaticMode;
    private CopyOnWriteArraySet<String> mDemandOnlyIsLoadBeforeInitCompleted;
    private CopyOnWriteArraySet<String> mDemandOnlyRvLoadBeforeInitCompleted;
    private DemandOnlyIsManager mDemandOnlyIsManager;
    private DemandOnlyRvManager mDemandOnlyRvManager;

    public static IronSourceObject getInstance() {
        return IronSourceObjectLoader.INSTANCE;
    }

    private IronSourceObject() {
        this.initializeManagers();
        this.mEventManagersInit = new AtomicBoolean();
        this.mAdUnitsToInitialize = new HashSet<IronSource.AD_UNIT>();
        this.mRequestedAdUnits = new HashSet<IronSource.AD_UNIT>();
        this.mIsDemandOnlyIs = false;
        this.mIsDemandOnlyRv = false;
        this.mAtomicIsFirstInit = new AtomicBoolean(true);
        this.mInitCounter = 0;
        this.mDidInitRewardedVideo = false;
        this.mDidInitInterstitial = false;
        this.mDidInitBanner = false;
        this.mSessionId = UUID.randomUUID().toString();
        this.mIsBnLoadBeforeInitCompleted = false;
        this.mIsIsLoadBeforeInitCompleted = false;
        this.mBnPlacementToLoad = null;
        this.mProgRvManager = null;
        this.mProgIsManager = null;
        this.mProgBannerManager = null;
        this.mIsRvProgrammatic = false;
        this.mIsIsProgrammatic = false;
        this.mIsBnProgrammatic = false;
        this.mDemandOnlyIsLoadBeforeInitCompleted = new CopyOnWriteArraySet();
        this.mDemandOnlyRvLoadBeforeInitCompleted = new CopyOnWriteArraySet();
        this.mDemandOnlyIsManager = null;
        this.mDemandOnlyRvManager = null;
        this.mBannerManager = null;
        this.rvProgrammaticMode = 1;
    }

    public void sendInitCompletedEvent(long elapsedTime) {
        boolean isDemandOnlyInit = this.mIsDemandOnlyRv || this.mIsDemandOnlyIs;
        JSONObject data = IronSourceUtils.getMediationAdditionalData(isDemandOnlyInit);
        try {
            data.put("duration", elapsedTime);
            data.put("sessionDepth", this.mInitCounter);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        EventData instanceEvent = new EventData(514, data);
        RewardedVideoEventsManager.getInstance().log(instanceEvent);
    }

    public synchronized void init(Activity activity, String appKey, boolean isDemandOnlyInit, IronSource.AD_UNIT ... adUnits) {
        IronLog.INTERNAL.verbose("");
        if (this.mAtomicIsFirstInit != null && this.mAtomicIsFirstInit.compareAndSet(true, false)) {
            if (adUnits == null || adUnits.length == 0) {
                for (IronSource.AD_UNIT adUnit : IronSource.AD_UNIT.values()) {
                    this.mAdUnitsToInitialize.add(adUnit);
                }
                this.mDidInitRewardedVideo = true;
                this.mDidInitInterstitial = true;
                this.mDidInitBanner = true;
            } else {
                for (IronSource.AD_UNIT adUnit : adUnits) {
                    this.mAdUnitsToInitialize.add(adUnit);
                    this.mRequestedAdUnits.add(adUnit);
                    if (adUnit.equals((Object)IronSource.AD_UNIT.INTERSTITIAL)) {
                        this.mDidInitInterstitial = true;
                    }
                    if (adUnit.equals((Object)IronSource.AD_UNIT.BANNER)) {
                        this.mDidInitBanner = true;
                    }
                    if (!adUnit.equals((Object)IronSource.AD_UNIT.REWARDED_VIDEO)) continue;
                    this.mDidInitRewardedVideo = true;
                }
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init(appKey:" + appKey + ")", 1);
            if (activity == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Init Fail - provided activity is null", 2);
                return;
            }
            ContextProvider.getInstance().updateActivity(activity);
            IronSourceUtils.getInstance().setBrowserUserAgent();
            this.mActivity = activity;
            ConfigValidationResult validationResultAppKey = this.validateAppKey(appKey);
            if (validationResultAppKey.isValid()) {
                this.mAppKey = appKey;
            }
            this.prepareEventManagers(activity);
            if (this.mAppKey == null) {
                MediationInitializer.getInstance().setInitStatusFailed();
                if (this.mAdUnitsToInitialize.contains((Object)IronSource.AD_UNIT.REWARDED_VIDEO)) {
                    this.mListenersWrapper.onRewardedVideoAvailabilityChanged(false);
                }
                if (this.mAdUnitsToInitialize.contains((Object)IronSource.AD_UNIT.OFFERWALL)) {
                    this.mListenersWrapper.onOfferwallAvailable(false, validationResultAppKey.getIronSourceError());
                }
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, validationResultAppKey.getIronSourceError().toString(), 1);
                return;
            }
            if (this.mShouldSendGetInstanceEvent) {
                JSONObject data = IronSourceUtils.getMediationAdditionalData(isDemandOnlyInit);
                try {
                    String androidXInfo = ",androidx=" + IronSourceUtils.isAndroidXAvailable();
                    if (IronSourceTempUtils.isKotlinLibraryExist()) {
                        data.put("ext1", (Object)("appLanguage=Kotlin" + IronSourceTempUtils.testKotlin() + androidXInfo));
                    } else {
                        data.put("ext1", (Object)("appLanguage=Java" + androidXInfo));
                    }
                    if (adUnits != null) {
                        for (IronSource.AD_UNIT adUnit : adUnits) {
                            data.put(adUnit.toString(), true);
                        }
                    }
                    data.put("sessionDepth", ++this.mInitCounter);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                EventData instanceEvent = new EventData(14, data);
                RewardedVideoEventsManager.getInstance().log(instanceEvent);
                this.mShouldSendGetInstanceEvent = false;
            }
            if (this.mAdUnitsToInitialize.contains((Object)IronSource.AD_UNIT.INTERSTITIAL)) {
                MediationInitializer.getInstance().addMediationInitializationListener(this.mInterstitialManager);
            }
            MediationInitializer.getInstance().addMediationInitializationListener(this);
            MediationInitializer.getInstance().init(activity, appKey, this.mUserId, adUnits);
        } else if (adUnits != null) {
            this.attachAdUnits(isDemandOnlyInit, adUnits);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Multiple calls to init without ad units are not allowed", 3);
        }
    }

    public synchronized void initISDemandOnly(Activity activity, String appKey, IronSource.AD_UNIT ... adUnits) {
        ArrayList<IronSource.AD_UNIT> validAdUnitsList = new ArrayList<IronSource.AD_UNIT>();
        if (adUnits == null || adUnits.length == 0) {
            if (this.mDidInitRewardedVideo) {
                this.sendAdUnitAlreadyInitializedLog(IronSource.AD_UNIT.REWARDED_VIDEO);
            } else {
                this.mIsDemandOnlyRv = true;
                validAdUnitsList.add(IronSource.AD_UNIT.REWARDED_VIDEO);
            }
            if (this.mDidInitInterstitial) {
                this.sendAdUnitAlreadyInitializedLog(IronSource.AD_UNIT.INTERSTITIAL);
            } else {
                this.mIsDemandOnlyIs = true;
                validAdUnitsList.add(IronSource.AD_UNIT.INTERSTITIAL);
            }
        } else {
            for (IronSource.AD_UNIT adUnit : adUnits) {
                if (adUnit.equals((Object)IronSource.AD_UNIT.BANNER) || adUnit.equals((Object)IronSource.AD_UNIT.OFFERWALL)) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, (Object)((Object)adUnit) + " ad unit cannot be initialized in demand only mode", 3);
                    continue;
                }
                if (adUnit.equals((Object)IronSource.AD_UNIT.INTERSTITIAL)) {
                    if (this.mDidInitInterstitial) {
                        this.sendAdUnitAlreadyInitializedLog(adUnit);
                    } else {
                        this.mIsDemandOnlyIs = true;
                        if (!validAdUnitsList.contains((Object)adUnit)) {
                            validAdUnitsList.add(adUnit);
                        }
                    }
                }
                if (!adUnit.equals((Object)IronSource.AD_UNIT.REWARDED_VIDEO)) continue;
                if (this.mDidInitRewardedVideo) {
                    this.sendAdUnitAlreadyInitializedLog(adUnit);
                    continue;
                }
                this.mIsDemandOnlyRv = true;
                if (validAdUnitsList.contains((Object)adUnit)) continue;
                validAdUnitsList.add(adUnit);
            }
        }
        ContextProvider.getInstance().updateActivity(activity);
        if (validAdUnitsList.size() > 0) {
            IronSource.AD_UNIT[] validAdUnitsArr = new IronSource.AD_UNIT[validAdUnitsList.size()];
            validAdUnitsArr = validAdUnitsList.toArray(validAdUnitsArr);
            this.init(activity, appKey, true, validAdUnitsArr);
        }
    }

    private void sendAdUnitAlreadyInitializedLog(IronSource.AD_UNIT adUnit) {
        String logMessage = (Object)((Object)adUnit) + " ad unit has already been initialized";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 3);
        IronSourceUtils.sendAutomationLog(logMessage);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void attachAdUnits(boolean isDemandOnlyInit, IronSource.AD_UNIT ... adUnits) {
        boolean shouldSentInstanceEvent;
        JSONObject data;
        IronSource.AD_UNIT adUnit;
        void var5_7;
        IronSource.AD_UNIT[] aD_UNITArray = adUnits;
        int n = aD_UNITArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            adUnit = aD_UNITArray[var5_7];
            if (adUnit.equals((Object)IronSource.AD_UNIT.INTERSTITIAL)) {
                this.mDidInitInterstitial = true;
            } else if (adUnit.equals((Object)IronSource.AD_UNIT.BANNER)) {
                this.mDidInitBanner = true;
            } else if (adUnit.equals((Object)IronSource.AD_UNIT.REWARDED_VIDEO)) {
                this.mDidInitRewardedVideo = true;
            }
            ++var5_7;
        }
        if (MediationInitializer.getInstance().getCurrentInitStatus() == MediationInitializer.EInitStatus.INIT_FAILED) {
            try {
                void var5_9;
                if (this.mListenersWrapper == null) return;
                aD_UNITArray = adUnits;
                n = aD_UNITArray.length;
                boolean bl2 = false;
                while (var5_9 < n) {
                    adUnit = aD_UNITArray[var5_9];
                    if (!this.mAdUnitsToInitialize.contains((Object)adUnit)) {
                        this.notifyPublisherAboutInitFailed(adUnit, true);
                    }
                    ++var5_9;
                }
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
        }
        if (!this.mInitSucceeded) {
            data = IronSourceUtils.getMediationAdditionalData(isDemandOnlyInit);
            shouldSentInstanceEvent = false;
            for (IronSource.AD_UNIT adUnit2 : adUnits) {
                if (!this.mAdUnitsToInitialize.contains((Object)adUnit2)) {
                    shouldSentInstanceEvent = true;
                    this.mAdUnitsToInitialize.add(adUnit2);
                    this.mRequestedAdUnits.add(adUnit2);
                    try {
                        data.put(adUnit2.toString(), true);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                    continue;
                }
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, (Object)((Object)adUnit2) + " ad unit has started initializing.", 3);
            }
            if (!shouldSentInstanceEvent) return;
            try {
                String string = ",androidx=" + IronSourceUtils.isAndroidXAvailable();
                if (IronSourceTempUtils.isKotlinLibraryExist()) {
                    data.put("ext1", (Object)("appLanguage=Kotlin" + IronSourceTempUtils.testKotlin() + string));
                } else {
                    data.put("ext1", (Object)("appLanguage=Java" + string));
                }
                data.put("sessionDepth", ++this.mInitCounter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            EventData eventData = new EventData(14, data);
            RewardedVideoEventsManager.getInstance().log(eventData);
            return;
        }
        if (this.mInitiatedAdUnits == null) {
            return;
        }
        data = IronSourceUtils.getMediationAdditionalData(isDemandOnlyInit);
        shouldSentInstanceEvent = false;
        for (IronSource.AD_UNIT adUnit3 : adUnits) {
            if (!this.mAdUnitsToInitialize.contains((Object)adUnit3)) {
                shouldSentInstanceEvent = true;
                this.mAdUnitsToInitialize.add(adUnit3);
                this.mRequestedAdUnits.add(adUnit3);
                try {
                    data.put(adUnit3.toString(), true);
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
                if (this.mInitiatedAdUnits != null && this.mInitiatedAdUnits.contains((Object)adUnit3)) {
                    this.startAdUnit(adUnit3);
                    continue;
                }
                this.notifyPublisherAboutInitFailed(adUnit3, false);
                continue;
            }
            this.sendAdUnitAlreadyInitializedLog(adUnit3);
        }
        if (!shouldSentInstanceEvent) return;
        try {
            String string = ",androidx=" + IronSourceUtils.isAndroidXAvailable();
            if (IronSourceTempUtils.isKotlinLibraryExist()) {
                data.put("ext1", (Object)("appLanguage=Kotlin" + IronSourceTempUtils.testKotlin() + string));
            } else {
                data.put("ext1", (Object)("appLanguage=Java" + string));
            }
            data.put("sessionDepth", ++this.mInitCounter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        EventData eventData = new EventData(14, data);
        RewardedVideoEventsManager.getInstance().log(eventData);
    }

    @Override
    public void onInitSuccess(List<IronSource.AD_UNIT> adUnits, boolean revived) {
        IronLog.INTERNAL.verbose("");
        try {
            this.mInitiatedAdUnits = adUnits;
            this.mInitSucceeded = true;
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "onInitSuccess()", 1);
            IronSourceUtils.sendAutomationLog("init success");
            if (revived) {
                IronSource.AD_UNIT[] data = IronSourceUtils.getMediationAdditionalData(false);
                try {
                    data.put("revived", true);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
                EventData revivedEvent = new EventData(114, (JSONObject)data);
                RewardedVideoEventsManager.getInstance().log(revivedEvent);
            }
            InterstitialEventsManager.getInstance().triggerEventsSend();
            RewardedVideoEventsManager.getInstance().triggerEventsSend();
            AdapterRepository.getInstance().setInitParams(this.getIronSourceAppKey(), this.getIronSourceUserId());
            for (IronSource.AD_UNIT adUnit : IronSource.AD_UNIT.values()) {
                if (!this.mAdUnitsToInitialize.contains((Object)adUnit)) continue;
                if (adUnits.contains((Object)adUnit)) {
                    this.startAdUnit(adUnit);
                    continue;
                }
                this.notifyPublisherAboutInitFailed(adUnit, false);
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    private void startAdUnit(IronSource.AD_UNIT adUnit) {
        switch (adUnit) {
            case REWARDED_VIDEO: {
                this.startRewardedVideo();
                break;
            }
            case INTERSTITIAL: {
                this.startInterstitial();
                break;
            }
            case OFFERWALL: {
                this.mOfferwallManager.initOfferwall(this.getIronSourceAppKey(), this.getIronSourceUserId());
                break;
            }
            case BANNER: {
                this.startBanner();
            }
        }
    }

    private void startProgrammaticRv() {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Rewarded Video started in programmatic mode", 0);
        ArrayList<ProviderSettings> providersList = new ArrayList<ProviderSettings>();
        for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getRewardedVideoProviderOrder().size(); ++i) {
            String provider = this.mCurrentServerResponse.getProviderOrder().getRewardedVideoProviderOrder().get(i);
            if (TextUtils.isEmpty((CharSequence)provider)) continue;
            providersList.add(this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider));
        }
        if (providersList.size() > 0) {
            this.mProgRvManager = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoAuctionSettings().getIsLoadWhileShow() ? new LWSProgRvManager(providersList, this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations(), this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks(), IronsourceObjectPublisherDataHolder.getInstance().getImpressionDataListeners()) : new ProgRvManager(providersList, this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations(), this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks(), IronsourceObjectPublisherDataHolder.getInstance().getImpressionDataListeners());
            if (this.mShouldTrackNetworkState != null) {
                this.mProgRvManager.shouldTrackNetworkState(this.mTrackNetworkStateContext, this.mShouldTrackNetworkState);
                if (this.mShouldTrackNetworkState.booleanValue()) {
                    this.mRewardedVideoManager.shouldTrackNetworkState(this.mTrackNetworkStateContext, false);
                }
            }
        } else {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false, true, this.rvProgrammaticMode);
            this.addToDictionary(data, new Object[][]{{"errorCode", 1010}});
            this.sentEventWithRVEventManager(81314, data);
            this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.REWARDED_VIDEO, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDemandOnlyRv() {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Rewarded Video started in demand only mode", 0);
        ArrayList<ProviderSettings> providersList = new ArrayList<ProviderSettings>();
        for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getRewardedVideoProviderOrder().size(); ++i) {
            String provider = this.mCurrentServerResponse.getProviderOrder().getRewardedVideoProviderOrder().get(i);
            if (TextUtils.isEmpty((CharSequence)provider)) continue;
            providersList.add(this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider));
        }
        if (providersList.size() > 0) {
            CopyOnWriteArraySet<String> copyOnWriteArraySet = this.mDemandOnlyRvLoadBeforeInitCompleted;
            synchronized (copyOnWriteArraySet) {
                this.mDemandOnlyRvManager = new DemandOnlyRvManager(providersList, this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations(), this.getIronSourceAppKey(), this.getIronSourceUserId());
            }
            for (String instanceId : this.mDemandOnlyRvLoadBeforeInitCompleted) {
                this.mDemandOnlyRvManager.loadRewardedVideoWithAdm(instanceId, null, false);
            }
            this.mDemandOnlyRvLoadBeforeInitCompleted.clear();
        } else {
            this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.REWARDED_VIDEO, false);
        }
    }

    private void startRewardedVideo() {
        if (this.mIsDemandOnlyRv) {
            this.startDemandOnlyRv();
            return;
        }
        this.mIsRvProgrammatic = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoAuctionSettings().getIsProgrammatic();
        this.rvProgrammaticMode = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoAuctionSettings().getIsLoadWhileShow() ? 2 : 1;
        this.sentEventWithRVEventManager(81000, IronSourceUtils.getMediationAdditionalData(false, this.mIsRvProgrammatic, this.rvProgrammaticMode));
        if (this.mIsRvProgrammatic) {
            this.startProgrammaticRv();
            return;
        }
        int rewardedVideoTimeout = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoAdaptersSmartLoadTimeout();
        for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getRewardedVideoProviderOrder().size(); ++i) {
            RewardedVideoSmash smash;
            ProviderSettings providerSettings;
            String provider = this.mCurrentServerResponse.getProviderOrder().getRewardedVideoProviderOrder().get(i);
            if (TextUtils.isEmpty((CharSequence)provider) || (providerSettings = this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider)) == null || !this.validateSmash(smash = new RewardedVideoSmash(providerSettings, rewardedVideoTimeout))) continue;
            smash.setRewardedVideoManagerListener(this.mRewardedVideoManager);
            smash.setProviderPriority(i + 1);
            this.mRewardedVideoManager.addSmashToArray(smash);
        }
        if (this.mRewardedVideoManager.mSmashArray.size() > 0) {
            RewardedVideoSmash premiumSmash;
            ProviderSettings providerSettings;
            String premiumProvider;
            RewardedVideoSmash backfillSmash;
            ProviderSettings providerSettings2;
            boolean ultraEventsEnabled = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoEventsConfigurations().isUltraEventsEnabled();
            this.mRewardedVideoManager.setIsUltraEventsEnabled(ultraEventsEnabled);
            int smartLoadAmount = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoAdaptersSmartLoadAmount();
            this.mRewardedVideoManager.setSmartLoadAmount(smartLoadAmount);
            int manualLoadInterval = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getManualLoadIntervalInSeconds();
            this.mRewardedVideoManager.setManualLoadInterval(manualLoadInterval);
            String backfillProvider = this.mCurrentServerResponse.getRVBackFillProvider();
            if (!TextUtils.isEmpty((CharSequence)backfillProvider) && (providerSettings2 = this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(backfillProvider)) != null && this.validateSmash(backfillSmash = new RewardedVideoSmash(providerSettings2, rewardedVideoTimeout))) {
                backfillSmash.setRewardedVideoManagerListener(this.mRewardedVideoManager);
                this.mRewardedVideoManager.setBackfillSmash(backfillSmash);
            }
            if (!TextUtils.isEmpty((CharSequence)(premiumProvider = this.mCurrentServerResponse.getRVPremiumProvider())) && (providerSettings = this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(premiumProvider)) != null && this.validateSmash(premiumSmash = new RewardedVideoSmash(providerSettings, rewardedVideoTimeout))) {
                premiumSmash.setRewardedVideoManagerListener(this.mRewardedVideoManager);
                this.mRewardedVideoManager.setPremiumSmash(premiumSmash);
            }
            this.mRewardedVideoManager.setExpiredDurationInMinutes(this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations().getExpiredDurationInMinutes());
            this.mRewardedVideoManager.initRewardedVideo(this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks());
        } else {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false, false, this.rvProgrammaticMode);
            this.addToDictionary(data, new Object[][]{{"errorCode", 1010}});
            this.sentEventWithRVEventManager(81314, data);
            this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.REWARDED_VIDEO, false);
        }
    }

    private void startProgrammaticIs() {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial started in programmatic mode", 0);
        ArrayList<ProviderSettings> providersList = new ArrayList<ProviderSettings>();
        for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getInterstitialProviderOrder().size(); ++i) {
            String provider = this.mCurrentServerResponse.getProviderOrder().getInterstitialProviderOrder().get(i);
            if (TextUtils.isEmpty((CharSequence)provider)) continue;
            providersList.add(this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider));
        }
        if (providersList.size() > 0) {
            this.mProgIsManager = new ProgIsManager(providersList, this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations(), this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks(), this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations().getISDelayLoadFailure(), IronsourceObjectPublisherDataHolder.getInstance().getImpressionDataListeners());
            if (this.mShouldTrackNetworkState != null) {
                this.mProgIsManager.shouldTrackNetworkState(this.mTrackNetworkStateContext, this.mShouldTrackNetworkState);
                if (this.mShouldTrackNetworkState.booleanValue()) {
                    this.mInterstitialManager.shouldTrackNetworkState(this.mTrackNetworkStateContext, false);
                }
            }
            if (this.mIsIsLoadBeforeInitCompleted) {
                this.mIsIsLoadBeforeInitCompleted = false;
                this.mProgIsManager.loadInterstitial();
            }
        } else {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false, true, 1);
            this.addToDictionary(data, new Object[][]{{"errorCode", 1010}});
            this.sentEventWithISEventManager(82314, data);
            this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.INTERSTITIAL, false);
        }
    }

    private void startProgrammaticBn(ArrayList<ProviderSettings> providersList) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner started in programmatic mode", 0);
        BannerData bannerData = new BannerData(this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks(), this.mCurrentServerResponse.getConfigurations().getBannerConfigurations());
        this.mProgBannerManager = new ProgBannerManager(providersList, bannerData, IronsourceObjectPublisherDataHolder.getInstance().getImpressionDataListeners());
        this.handleBannerLoadBeforeInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDemandOnlyIs() {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial started in demand only mode", 0);
        ArrayList<ProviderSettings> providersList = new ArrayList<ProviderSettings>();
        for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getInterstitialProviderOrder().size(); ++i) {
            String provider = this.mCurrentServerResponse.getProviderOrder().getInterstitialProviderOrder().get(i);
            if (TextUtils.isEmpty((CharSequence)provider)) continue;
            providersList.add(this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider));
        }
        if (providersList.size() > 0) {
            CopyOnWriteArraySet<String> i = this.mDemandOnlyIsLoadBeforeInitCompleted;
            synchronized (i) {
                this.mDemandOnlyIsManager = new DemandOnlyIsManager(providersList, this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations(), this.getIronSourceAppKey(), this.getIronSourceUserId());
            }
            for (String instanceId : this.mDemandOnlyIsLoadBeforeInitCompleted) {
                this.mDemandOnlyIsManager.loadInterstitialWithAdm(instanceId, null, false);
            }
            this.mDemandOnlyIsLoadBeforeInitCompleted.clear();
        } else {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false, false, 1);
            this.addToDictionary(data, new Object[][]{{"errorCode", 1010}});
            this.sentEventWithISEventManager(82314, data);
            this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.INTERSTITIAL, false);
        }
    }

    private void startInterstitial() {
        if (this.mIsDemandOnlyIs) {
            this.startDemandOnlyIs();
            return;
        }
        this.mIsIsProgrammatic = this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations().getInterstitialAuctionSettings().getIsProgrammatic();
        this.sentEventWithISEventManager(82000, IronSourceUtils.getMediationAdditionalData(false, this.mIsIsProgrammatic, 1));
        if (this.mIsIsProgrammatic) {
            this.startProgrammaticIs();
            return;
        }
        int interstitialTimeout = this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations().getInterstitialAdaptersSmartLoadTimeout();
        int interstitialDelayLoadFailureTimeout = this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations().getISDelayLoadFailure();
        this.mInterstitialManager.setDelayLoadFailureNotificationInSeconds(interstitialDelayLoadFailureTimeout);
        for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getInterstitialProviderOrder().size(); ++i) {
            InterstitialSmash smash;
            ProviderSettings providerSettings;
            String provider = this.mCurrentServerResponse.getProviderOrder().getInterstitialProviderOrder().get(i);
            if (TextUtils.isEmpty((CharSequence)provider) || (providerSettings = this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider)) == null || !this.validateSmash(smash = new InterstitialSmash(providerSettings, interstitialTimeout))) continue;
            smash.setInterstitialManagerListener(this.mInterstitialManager);
            smash.setProviderPriority(i + 1);
            this.mInterstitialManager.addSmashToArray(smash);
        }
        if (this.mInterstitialManager.mSmashArray.size() > 0) {
            int smartLoadAmount = this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations().getInterstitialAdaptersSmartLoadAmount();
            this.mInterstitialManager.setSmartLoadAmount(smartLoadAmount);
            this.mInterstitialManager.initInterstitial(this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks());
            if (this.mIsIsLoadBeforeInitCompleted) {
                this.mIsIsLoadBeforeInitCompleted = false;
                this.mInterstitialManager.loadInterstitial();
            }
        } else {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false, false, 1);
            this.addToDictionary(data, new Object[][]{{"errorCode", 1010}});
            this.sentEventWithISEventManager(82314, data);
            this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.INTERSTITIAL, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBanner() {
        Boolean bl = this.mIsBnLoadBeforeInitCompleted;
        synchronized (bl) {
            this.mIsBnProgrammatic = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations().getBannerAuctionSettings().getIsProgrammatic();
            IronLog.INTERNAL.verbose("mIsBnProgrammatic = " + this.mIsBnProgrammatic);
            IronLog.INTERNAL.verbose("mIsBnLoadBeforeInitCompleted = " + this.mIsBnLoadBeforeInitCompleted);
            this.sentEventWithISEventManager(83000, IronSourceUtils.getMediationAdditionalData(false, this.mIsBnProgrammatic, 1));
            ArrayList<ProviderSettings> adapterConfigs = new ArrayList<ProviderSettings>();
            for (int i = 0; i < this.mCurrentServerResponse.getProviderOrder().getBannerProviderOrder().size(); ++i) {
                ProviderSettings providerSettings;
                String provider = this.mCurrentServerResponse.getProviderOrder().getBannerProviderOrder().get(i);
                if (TextUtils.isEmpty((CharSequence)provider) || (providerSettings = this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings(provider)) == null) continue;
                adapterConfigs.add(providerSettings);
            }
            if (adapterConfigs.size() > 0) {
                if (this.mIsBnProgrammatic) {
                    this.startProgrammaticBn(adapterConfigs);
                    return;
                }
                long bannerTimeout = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations().getBannerAdaptersSmartLoadTimeout();
                int bannerInterval = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations().getBannerRefreshInterval();
                int bannerDelayLoadFailure = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations().getBannerDelayLoadFailure();
                this.mBannerManager = new BannerManager(adapterConfigs, this.getIronSourceAppKey(), IronSourceUtils.getUserIdForNetworks(), bannerTimeout, bannerInterval, bannerDelayLoadFailure);
                this.handleBannerLoadBeforeInit();
            } else {
                JSONObject data = IronSourceUtils.getMediationAdditionalData(false, this.mIsBnProgrammatic, 1);
                this.addToDictionary(data, new Object[][]{{"errorCode", 1010}});
                this.sentEventWithISEventManager(83314, data);
                this.notifyPublisherAboutInitFailed(IronSource.AD_UNIT.BANNER, false);
            }
        }
    }

    private void handleBannerLoadBeforeInit() {
        if (this.mIsBnLoadBeforeInitCompleted.booleanValue()) {
            this.mIsBnLoadBeforeInitCompleted = false;
            this.loadBanner(this.mBnLayoutToLoad, this.mBnPlacementToLoad);
            this.mBnLayoutToLoad = null;
            this.mBnPlacementToLoad = null;
        }
    }

    private boolean validateSmash(AbstractSmash smash) {
        return smash.getMaxAdsPerIteration() >= 1 && smash.getMaxAdsPerSession() >= 1;
    }

    @Override
    public void onInitFailed(String reason) {
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "onInitFailed(reason:" + reason + ")", 1);
            IronSourceUtils.sendAutomationLog("Mediation init failed");
            if (this.mListenersWrapper != null) {
                for (IronSource.AD_UNIT adUnit : this.mAdUnitsToInitialize) {
                    this.notifyPublisherAboutInitFailed(adUnit, true);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStillInProgressAfter15Secs() {
        Serializable serializable = this.mIsBnLoadBeforeInitCompleted;
        synchronized (serializable) {
            if (this.mIsBnLoadBeforeInitCompleted.booleanValue()) {
                this.mIsBnLoadBeforeInitCompleted = false;
                BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(this.mBnLayoutToLoad, new IronSourceError(603, "init had failed"));
                this.mBnLayoutToLoad = null;
                this.mBnPlacementToLoad = null;
            }
        }
        if (this.mIsIsLoadBeforeInitCompleted) {
            this.mIsIsLoadBeforeInitCompleted = false;
            CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
        }
        serializable = this.mDemandOnlyIsLoadBeforeInitCompleted;
        synchronized (serializable) {
            for (String instanceId : this.mDemandOnlyIsLoadBeforeInitCompleted) {
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
            }
            this.mDemandOnlyIsLoadBeforeInitCompleted.clear();
        }
        serializable = this.mDemandOnlyRvLoadBeforeInitCompleted;
        synchronized (serializable) {
            for (String instanceId : this.mDemandOnlyRvLoadBeforeInitCompleted) {
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Rewarded Video"));
            }
            this.mDemandOnlyRvLoadBeforeInitCompleted.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPublisherAboutInitFailed(IronSource.AD_UNIT adUnit, boolean isInitFailed) {
        switch (adUnit) {
            case REWARDED_VIDEO: {
                if (this.mIsDemandOnlyRv) {
                    for (String instanceId : this.mDemandOnlyRvLoadBeforeInitCompleted) {
                        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("initISDemandOnly() had failed", "Rewarded Video"));
                    }
                    this.mDemandOnlyRvLoadBeforeInitCompleted.clear();
                    break;
                }
                if (!isInitFailed && !this.isRewardedVideoConfigurationsReady() && !this.mRequestedAdUnits.contains((Object)adUnit)) break;
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(false);
                break;
            }
            case INTERSTITIAL: {
                if (this.mIsDemandOnlyIs) {
                    for (String instanceId : this.mDemandOnlyIsLoadBeforeInitCompleted) {
                        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("initISDemandOnly() had failed", "Interstitial"));
                    }
                    this.mDemandOnlyIsLoadBeforeInitCompleted.clear();
                    break;
                }
                if (!this.mIsIsLoadBeforeInitCompleted) break;
                this.mIsIsLoadBeforeInitCompleted = false;
                CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                break;
            }
            case OFFERWALL: {
                if (!isInitFailed && !this.isOfferwallConfigurationsReady() && !this.mRequestedAdUnits.contains((Object)adUnit)) break;
                this.mListenersWrapper.onOfferwallAvailable(false);
                break;
            }
            case BANNER: {
                Boolean bl = this.mIsBnLoadBeforeInitCompleted;
                synchronized (bl) {
                    if (this.mIsBnLoadBeforeInitCompleted.booleanValue()) {
                        this.mIsBnLoadBeforeInitCompleted = false;
                        BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(this.mBnLayoutToLoad, new IronSourceError(602, "Init had failed"));
                        this.mBnLayoutToLoad = null;
                        this.mBnPlacementToLoad = null;
                    }
                    break;
                }
            }
        }
    }

    private void prepareEventManagers(Activity activity) {
        if (this.mEventManagersInit != null && this.mEventManagersInit.compareAndSet(false, true)) {
            SuperLooper.getLooper().post(new GeneralPropertiesWorker(activity.getApplicationContext()));
            InterstitialEventsManager.getInstance().start(activity.getApplicationContext(), this.mIronSegment);
            RewardedVideoEventsManager.getInstance().start(activity.getApplicationContext(), this.mIronSegment);
        }
    }

    synchronized void addOWAdapter(AbstractAdapter adapter) {
        this.mOfferwallAdapter = adapter;
    }

    synchronized AbstractAdapter getOfferwallAdapter(String providerName) {
        try {
            if (this.mOfferwallAdapter != null && this.mOfferwallAdapter.getProviderName().equals(providerName)) {
                return this.mOfferwallAdapter;
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "getOfferwallAdapter exception: " + e2, 1);
        }
        return null;
    }

    private void initializeManagers() {
        this.mLoggerManager = IronSourceLoggerManager.getLogger(0);
        this.mPublisherLogger = new PublisherLogger(null, 1);
        this.mLoggerManager.addLogger(this.mPublisherLogger);
        this.mListenersWrapper = new ListenersWrapper();
        this.mRewardedVideoManager = new RewardedVideoManager();
        this.mRewardedVideoManager.setRewardedVideoListener(this.mListenersWrapper);
        this.mInterstitialManager = new InterstitialManager();
        this.mInterstitialManager.setInterstitialListener(this.mListenersWrapper);
        this.mOfferwallManager = new OfferwallManager();
        this.mOfferwallManager.setInternalOfferwallListener(this.mListenersWrapper);
    }

    public void onResume(Activity activity) {
        String logMessage = "onResume()";
        try {
            this.mActivity = activity;
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
            ContextProvider.getInstance().onResume(activity);
            if (this.mBannerManager != null) {
                this.mBannerManager.onResume();
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
        }
    }

    public void onPause(Activity activity) {
        String logMessage = "onPause()";
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
            ContextProvider.getInstance().onPause(activity);
            if (this.mBannerManager != null) {
                this.mBannerManager.onPause();
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
        }
    }

    @Override
    public void setMediationSegment(String segment) {
        try {
            String logMessage = this.TAG + ":setMediationSegment(segment:" + segment + ")";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
            ConfigValidationResult result = new ConfigValidationResult();
            this.validateSegment(segment, result);
            if (result.isValid()) {
                this.mSegment = segment;
            } else {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, result.getIronSourceError().toString(), 2);
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":setMediationSegment(segment:" + segment + ")", e2);
        }
    }

    public void setSegment(IronSourceSegment segment) {
        if (MediationInitializer.getInstance().getCurrentInitStatus() == MediationInitializer.EInitStatus.INIT_IN_PROGRESS || MediationInitializer.getInstance().getCurrentInitStatus() == MediationInitializer.EInitStatus.INITIATED) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "Segments must be set prior to Init. Setting a segment after the init will be ignored", 0);
        } else {
            this.mIronSegment = segment;
        }
    }

    @Override
    public boolean setDynamicUserId(String dynamicUserId) {
        try {
            String logMessage = this.TAG + ":setDynamicUserId(dynamicUserId:" + dynamicUserId + ")";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
            ConfigValidationResult result = new ConfigValidationResult();
            this.validateDynamicUserId(dynamicUserId, result);
            if (result.isValid()) {
                this.mDynamicUserId = dynamicUserId;
                JSONObject data = IronSourceUtils.getJsonForUserId(true);
                EventData instanceEvent = new EventData(52, data);
                RewardedVideoEventsManager.getInstance().log(instanceEvent);
                return true;
            }
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, result.getIronSourceError().toString(), 2);
            return false;
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":setDynamicUserId(dynamicUserId:" + dynamicUserId + ")", e2);
            return false;
        }
    }

    @Override
    public void setAdaptersDebug(boolean enabled) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "setAdaptersDebug : " + enabled, 1);
        AdapterRepository.getInstance().setAdaptersDebug(enabled);
    }

    @Override
    public void setMediationType(String mediationType) {
        try {
            String logMessage = this.TAG + ":setMediationType(mediationType:" + mediationType + ")";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, logMessage, 1);
            if (this.validateLength(mediationType, 1, 64) && this.validateAlphanumeric(mediationType)) {
                this.mMediationType = mediationType;
            } else {
                logMessage = " mediationType value is invalid - should be alphanumeric and 1-64 chars in length";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, logMessage, 1);
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":setMediationType(mediationType:" + mediationType + ")", e2);
        }
    }

    String getMediationSegment() {
        return this.mSegment;
    }

    String getDynamicUserId() {
        return this.mDynamicUserId;
    }

    Map<String, String> getRvServerParams() {
        return this.mRvServerParams;
    }

    public String getMediationType() {
        return this.mMediationType;
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId) {
    }

    @Override
    public void initInterstitial(Activity activity, String appKey, String userId) {
    }

    @Override
    public void initOfferwall(String appKey, String userId) {
    }

    public void showRewardedVideo() {
        if (!this.isRewardedVideoConfigurationsReady()) {
            String message = "showRewardedVideo can't be called before the Rewarded Video ad unit initialization completed successfully";
            this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildInitFailedError(message, "Rewarded Video"));
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, message, 3);
            return;
        }
        Placement defaultPlacement = this.getDefaultRewardedVideoPlacement();
        if (defaultPlacement == null) {
            String message = "showRewardedVideo error: empty default placement in response";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, message, 3);
            IronSourceError error = new IronSourceError(1021, message);
            this.mListenersWrapper.onRewardedVideoAdShowFailed(error);
        } else {
            this.showRewardedVideo(defaultPlacement.getPlacementName());
        }
    }

    private Placement getRewardedVideoPlacement(String placementName) {
        RewardedVideoConfigurations rewardedVideoConfigurations = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations();
        if (rewardedVideoConfigurations != null) {
            return rewardedVideoConfigurations.getRewardedVideoPlacement(placementName);
        }
        return null;
    }

    private Placement getDefaultRewardedVideoPlacement() {
        RewardedVideoConfigurations rewardedVideoConfigurations = this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations();
        if (rewardedVideoConfigurations != null) {
            return rewardedVideoConfigurations.getDefaultRewardedVideoPlacement();
        }
        return null;
    }

    private void showProgrammaticRewardedVideo(String placementName) {
        Placement placement = this.getRewardedVideoPlacement(placementName);
        if (placement == null) {
            placement = this.getDefaultRewardedVideoPlacement();
        }
        if (placement == null) {
            String message = "showProgrammaticRewardedVideo error: empty default placement in response";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, message, 3);
            IronSourceError error = new IronSourceError(1021, message);
            this.mListenersWrapper.onRewardedVideoAdShowFailed(error);
        } else {
            this.mProgRvManager.showRewardedVideo(placement);
        }
    }

    @Override
    public void showRewardedVideo(String placementName) {
        String logMessage = "showRewardedVideo(" + placementName + ")";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        try {
            if (this.mIsDemandOnlyRv) {
                String message = "Rewarded Video was initialized in demand only mode. Use showISDemandOnlyRewardedVideo instead";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildInitFailedError(message, "Rewarded Video"));
                return;
            }
            if (!this.isRewardedVideoConfigurationsReady()) {
                this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildInitFailedError("showRewardedVideo can't be called before the Rewarded Video ad unit initialization completed successfully", "Rewarded Video"));
                return;
            }
            if (this.mIsRvProgrammatic && this.mProgRvManager != null) {
                this.showProgrammaticRewardedVideo(placementName);
                return;
            }
            Placement placement = this.getPlacementToShowWithEvent(placementName);
            if (placement != null) {
                this.mRewardedVideoManager.setCurrentPlacement(placement);
                this.mRewardedVideoManager.showRewardedVideo(placement.getPlacementName());
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
            this.mListenersWrapper.onRewardedVideoAdShowFailed(new IronSourceError(510, e2.getMessage()));
        }
    }

    @Override
    public boolean isRewardedVideoAvailable() {
        boolean isAvailable = false;
        try {
            if (this.mIsDemandOnlyRv) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Rewarded Video was initialized in demand only mode. Use isISDemandOnlyRewardedVideoAvailable instead", 3);
                return false;
            }
            isAvailable = this.mIsRvProgrammatic ? this.mProgRvManager != null && this.mProgRvManager.isRewardedVideoAvailable() : this.mRewardedVideoManager.isRewardedVideoAvailable();
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
            if (this.mIsRvProgrammatic) {
                this.addToDictionary(data, new Object[][]{{"programmatic", this.rvProgrammaticMode}});
            }
            EventData event = new EventData(isAvailable ? 1101 : 1102, data);
            RewardedVideoEventsManager.getInstance().log(event);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "isRewardedVideoAvailable():" + isAvailable, 1);
        }
        catch (Throwable e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "isRewardedVideoAvailable():" + isAvailable, 1);
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "isRewardedVideoAvailable()", e2);
            isAvailable = false;
        }
        return isAvailable;
    }

    @Override
    public void setRewardedVideoListener(RewardedVideoListener listener) {
        if (listener == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setRewardedVideoListener(RVListener:null)", 1);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setRewardedVideoListener(RVListener)", 1);
        }
        this.mListenersWrapper.setRewardedVideoListener(listener);
        RVListenerWrapper.getInstance().setListener(listener);
    }

    @Override
    public void setRewardedVideoServerParameters(Map<String, String> params) {
        try {
            if (params == null || params.size() == 0) {
                return;
            }
            String logMessage = this.TAG + ":setRewardedVideoServerParameters(params:" + params.toString() + ")";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
            this.mRvServerParams = new HashMap<String, String>(params);
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + ":setRewardedVideoServerParameters(params:" + params.toString() + ")", e2);
        }
    }

    @Override
    public void clearRewardedVideoServerParameters() {
        this.mRvServerParams = null;
    }

    public synchronized void loadISDemandOnlyRewardedVideoWithAdm(String instanceId, String adm) {
        if (adm == null) {
            String message = "adm cannot be null";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, new IronSourceError(510, message));
            return;
        }
        this.loadISDemandOnlyRewardedVideo(instanceId, adm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadISDemandOnlyRewardedVideo(String instanceId, String adm) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "loadISDemandOnlyRewardedVideo() instanceId=" + instanceId, 1);
        try {
            if (!this.mDidInitRewardedVideo) {
                String message = "initISDemandOnly() must be called before loadISDemandOnlyRewardedVideo()";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, new IronSourceError(508, message));
                return;
            }
            if (!this.mIsDemandOnlyRv) {
                String message = "Rewarded video was initialized in mediation mode";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, new IronSourceError(508, message));
                return;
            }
            MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
            if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Rewarded Video"));
                return;
            }
            if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                    RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Rewarded Video"));
                } else {
                    CopyOnWriteArraySet<String> copyOnWriteArraySet = this.mDemandOnlyRvLoadBeforeInitCompleted;
                    synchronized (copyOnWriteArraySet) {
                        this.mDemandOnlyRvLoadBeforeInitCompleted.add(instanceId);
                    }
                    if (adm != null) {
                        JSONObject data = IronSourceUtils.getMediationAdditionalData(true, true, this.rvProgrammaticMode);
                        this.sentEventWithISEventManager(83003, data);
                    }
                }
                return;
            }
            CopyOnWriteArraySet<String> copyOnWriteArraySet = this.mDemandOnlyRvLoadBeforeInitCompleted;
            synchronized (copyOnWriteArraySet) {
                if (this.mDemandOnlyRvManager == null) {
                    this.mDemandOnlyRvLoadBeforeInitCompleted.add(instanceId);
                    if (adm != null) {
                        JSONObject data = IronSourceUtils.getMediationAdditionalData(true, true, this.rvProgrammaticMode);
                        this.sentEventWithISEventManager(83003, data);
                    }
                    return;
                }
            }
            if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations() == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "No rewarded video configurations found", 3);
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("the server response does not contain rewarded video data", "Rewarded Video"));
                return;
            }
            if (adm == null) {
                this.mDemandOnlyRvManager.loadRewardedVideoWithAdm(instanceId, null, false);
            } else {
                this.mDemandOnlyRvManager.loadRewardedVideoWithAdm(instanceId, adm, true);
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "loadISDemandOnlyRewardedVideo", e2);
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, new IronSourceError(510, e2.getMessage()));
        }
    }

    public synchronized void showDemandOnlyRewardedVideo(String instanceId) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "showISDemandOnlyRewardedVideo() instanceId=" + instanceId, 1);
        try {
            if (!this.mIsDemandOnlyRv) {
                String message = "Rewarded video was initialized in mediation mode. Use showRewardedVideo instead";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(instanceId, new IronSourceError(508, message));
                return;
            }
            if (this.mDemandOnlyRvManager == null) {
                String message = "Rewarded video was not initiated";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(instanceId, new IronSourceError(508, message));
                return;
            }
            this.mDemandOnlyRvManager.showRewardedVideo(instanceId);
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "showISDemandOnlyRewardedVideo", e2);
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(instanceId, new IronSourceError(510, e2.getMessage()));
        }
    }

    public synchronized boolean isDemandOnlyRewardedVideoAvailable(String instanceId) {
        return this.mDemandOnlyRvManager != null && this.mDemandOnlyRvManager.isRewardedVideoAvailable(instanceId);
    }

    void setISDemandOnlyRewardedVideoListener(ISDemandOnlyRewardedVideoListener listener) {
        RVDemandOnlyListenerWrapper.getInstance().setListener(listener);
    }

    private boolean isRewardedVideoConfigurationsReady() {
        return this.mCurrentServerResponse != null && this.mCurrentServerResponse.getConfigurations() != null && this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations() != null;
    }

    private Placement getPlacementToShowWithEvent(String placementName) {
        Placement placement = this.getRewardedVideoPlacement(placementName);
        if (placement == null) {
            String noPlacementMessage = "Placement is not valid, please make sure you are using the right placements, using the default placement.";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noPlacementMessage, 3);
            placement = this.getDefaultRewardedVideoPlacement();
            if (placement == null) {
                String noDefaultPlacement = "Default placement was not found, please make sure you are using the right placements.";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noDefaultPlacement, 3);
                return null;
            }
        }
        CappingManager.ECappingStatus cappingStatus = CappingManager.isPlacementCapped((Context)this.mActivity, placement);
        String cappedMessage = this.getCappingMessage(placement.getPlacementName(), cappingStatus);
        if (!TextUtils.isEmpty((CharSequence)cappedMessage)) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, cappedMessage, 1);
            this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildCappedPerPlacementError(cappedMessage));
            return null;
        }
        return placement;
    }

    @Override
    public void loadInterstitial() {
        String logMessage = "loadInterstitial()";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        try {
            if (this.mIsDemandOnlyIs) {
                String message = "Interstitial was initialized in demand only mode. Use loadISDemandOnlyInterstitial instead";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError(message, "Interstitial"));
                return;
            }
            if (!this.mDidInitInterstitial) {
                String message = "init() must be called before loadInterstitial()";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError(message, "Interstitial"));
                return;
            }
            MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
            if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                return;
            }
            if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                    CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                } else {
                    this.mIsIsLoadBeforeInitCompleted = true;
                }
                return;
            }
            if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations() == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "No interstitial configurations found", 3);
                CallbackThrottler.getInstance().onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("the server response does not contain interstitial data", "Interstitial"));
                return;
            }
            if (!this.mIsIsProgrammatic) {
                this.mInterstitialManager.loadInterstitial();
                return;
            }
            if (this.mProgIsManager == null) {
                this.mIsIsLoadBeforeInitCompleted = true;
            } else {
                this.mProgIsManager.loadInterstitial();
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
            CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(510, e2.getMessage()));
        }
    }

    public void showInterstitial() {
        String logMessage = "showInterstitial()";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        try {
            if (this.mIsDemandOnlyIs) {
                String message = "Interstitial was initialized in demand only mode. Use showISDemandOnlyInterstitial instead";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                this.mListenersWrapper.onInterstitialAdShowFailed(new IronSourceError(510, message));
                return;
            }
            if (!this.isInterstitialConfigurationsReady()) {
                this.mListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildInitFailedError("showInterstitial can't be called before the Interstitial ad unit initialization completed successfully", "Interstitial"));
                return;
            }
            InterstitialPlacement defaultPlacement = this.getDefaultInterstitialPlacement();
            if (defaultPlacement != null) {
                String placementName = defaultPlacement.getPlacementName();
                this.showInterstitial(placementName);
            } else {
                this.mListenersWrapper.onInterstitialAdShowFailed(new IronSourceError(1020, "showInterstitial error: empty default placement in response"));
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
            this.mListenersWrapper.onInterstitialAdShowFailed(new IronSourceError(510, e2.getMessage()));
        }
    }

    @Override
    public void showInterstitial(String placementName) {
        String logMessage = "showInterstitial(" + placementName + ")";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        try {
            if (this.mIsDemandOnlyIs) {
                String message = "Interstitial was initialized in demand only mode. Use showISDemandOnlyInterstitial instead";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                this.mListenersWrapper.onInterstitialAdShowFailed(new IronSourceError(510, message));
                return;
            }
            if (!this.isInterstitialConfigurationsReady()) {
                this.mListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildInitFailedError("showInterstitial can't be called before the Interstitial ad unit initialization completed successfully", "Interstitial"));
                return;
            }
            if (this.mIsIsProgrammatic) {
                this.showProgrammaticInterstitial(placementName);
                return;
            }
            InterstitialPlacement placement = this.getInterstitialPlacementToShowWithEvent(placementName);
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
            try {
                if (placement != null) {
                    data.put("placement", (Object)placement.getPlacementName());
                } else if (!TextUtils.isEmpty((CharSequence)placementName)) {
                    data.put("placement", (Object)placementName);
                }
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            EventData event = new EventData(2100, data);
            InterstitialEventsManager.getInstance().log(event);
            if (placement != null) {
                this.mInterstitialManager.setCurrentPlacement(placement);
                this.mInterstitialManager.showInterstitial(placement.getPlacementName());
            }
        }
        catch (Exception e3) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e3);
            this.mListenersWrapper.onInterstitialAdShowFailed(new IronSourceError(510, e3.getMessage()));
        }
    }

    private InterstitialPlacement getInterstitialPlacement(String placementName) {
        InterstitialConfigurations interstitialConfigurations = this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations();
        if (interstitialConfigurations != null) {
            return interstitialConfigurations.getInterstitialPlacement(placementName);
        }
        return null;
    }

    private InterstitialPlacement getDefaultInterstitialPlacement() {
        InterstitialConfigurations interstitialConfigurations = this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations();
        if (interstitialConfigurations != null) {
            return interstitialConfigurations.getDefaultInterstitialPlacement();
        }
        return null;
    }

    private void showProgrammaticInterstitial(String placementName) {
        String interstitialPlacementName = null;
        try {
            InterstitialPlacement placement = this.getInterstitialPlacement(placementName);
            if (placement == null) {
                placement = this.getDefaultInterstitialPlacement();
            }
            if (placement != null) {
                interstitialPlacementName = placement.getPlacementName();
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "showProgrammaticInterstitial()", e2);
        }
        this.mProgIsManager.showInterstitial(interstitialPlacementName);
    }

    @Override
    public boolean isInterstitialReady() {
        boolean isReady = false;
        try {
            if (this.mIsDemandOnlyIs) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Interstitial was initialized in demand only mode. Use isISDemandOnlyInterstitialReady instead", 3);
                return false;
            }
            isReady = this.mIsIsProgrammatic ? this.mProgIsManager != null && this.mProgIsManager.isInterstitialReady() : this.mInterstitialManager != null && this.mInterstitialManager.isInterstitialReady();
            JSONObject data = IronSourceUtils.getMediationAdditionalData(false, this.mIsIsProgrammatic, 1);
            EventData event = new EventData(isReady ? 2101 : 2102, data);
            InterstitialEventsManager.getInstance().log(event);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "isInterstitialReady():" + isReady, 1);
        }
        catch (Throwable e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "isInterstitialReady():" + isReady, 1);
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "isInterstitialReady()", e2);
            isReady = false;
        }
        return isReady;
    }

    @Override
    public void setInterstitialListener(InterstitialListener listener) {
        if (listener == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setInterstitialListener(ISListener:null)", 1);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setInterstitialListener(ISListener)", 1);
        }
        this.mListenersWrapper.setInterstitialListener(listener);
        ISListenerWrapper.getInstance().setListener(listener);
        CallbackThrottler.getInstance().setInterstitialListener(listener);
    }

    public synchronized void loadISDemandOnlyInterstitialWithAdm(String instanceId, String adm) {
        if (adm == null) {
            String message = "adm cannot be null";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, new IronSourceError(510, message));
            return;
        }
        this.loadDemandOnlyInterstitial(instanceId, adm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadDemandOnlyInterstitial(String instanceId, String adm) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "loadISDemandOnlyInterstitial() instanceId=" + instanceId, 1);
        try {
            if (!this.mDidInitInterstitial) {
                String message = "initISDemandOnly() must be called before loadISDemandOnlyInterstitial()";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, new IronSourceError(510, message));
                return;
            }
            if (!this.mIsDemandOnlyIs) {
                String message = "Interstitial was initialized in mediation mode. Use loadInterstitial instead";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, new IronSourceError(510, message));
                return;
            }
            MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
            if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                return;
            }
            if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                    ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                } else {
                    CopyOnWriteArraySet<String> copyOnWriteArraySet = this.mDemandOnlyIsLoadBeforeInitCompleted;
                    synchronized (copyOnWriteArraySet) {
                        this.mDemandOnlyIsLoadBeforeInitCompleted.add(instanceId);
                    }
                    if (adm != null) {
                        JSONObject data = IronSourceUtils.getMediationAdditionalData(true, true, 1);
                        this.sentEventWithISEventManager(83004, data);
                    }
                }
                return;
            }
            CopyOnWriteArraySet<String> copyOnWriteArraySet = this.mDemandOnlyIsLoadBeforeInitCompleted;
            synchronized (copyOnWriteArraySet) {
                if (this.mDemandOnlyIsManager == null) {
                    this.mDemandOnlyIsLoadBeforeInitCompleted.add(instanceId);
                    if (adm != null) {
                        JSONObject data = IronSourceUtils.getMediationAdditionalData(true, true, 1);
                        this.sentEventWithISEventManager(83004, data);
                    }
                    return;
                }
            }
            if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations() == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "No interstitial configurations found", 3);
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, ErrorBuilder.buildInitFailedError("the server response does not contain interstitial data", "Interstitial"));
                return;
            }
            if (adm == null) {
                this.mDemandOnlyIsManager.loadInterstitialWithAdm(instanceId, null, false);
            } else {
                this.mDemandOnlyIsManager.loadInterstitialWithAdm(instanceId, adm, true);
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "loadDemandOnlyInterstitial", e2);
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, new IronSourceError(510, e2.getMessage()));
        }
    }

    public void showDemandOnlyInterstitial(String instanceId) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "showISDemandOnlyInterstitial() instanceId=" + instanceId, 1);
        try {
            if (!this.mIsDemandOnlyIs) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Interstitial was initialized in mediation mode. Use showInterstitial instead", 3);
                return;
            }
            if (this.mDemandOnlyIsManager == null) {
                String message = "Interstitial video was not initiated";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdShowFailed(instanceId, new IronSourceError(508, message));
                return;
            }
            this.mDemandOnlyIsManager.showInterstitial(instanceId);
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "showISDemandOnlyInterstitial", e2);
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdShowFailed(instanceId, ErrorBuilder.buildInitFailedError("showISDemandOnlyInterstitial can't be called before the Interstitial ad unit initialization completed successfully", "Interstitial"));
        }
    }

    public synchronized boolean isDemandOnlyInterstitialReady(String instanceId) {
        return this.mDemandOnlyIsManager != null && this.mDemandOnlyIsManager.isInterstitialReady(instanceId);
    }

    public void setISDemandOnlyInterstitialListener(ISDemandOnlyInterstitialListener listener) {
        ISDemandOnlyListenerWrapper.getInstance().setListener(listener);
    }

    private boolean isInterstitialConfigurationsReady() {
        return this.mCurrentServerResponse != null && this.mCurrentServerResponse.getConfigurations() != null && this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations() != null;
    }

    private InterstitialPlacement getInterstitialPlacementToShowWithEvent(String placementName) {
        InterstitialPlacement placement = this.getInterstitialPlacement(placementName);
        if (placement == null) {
            String noPlacementMessage = "Placement is not valid, please make sure you are using the right placements, using the default placement.";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noPlacementMessage, 3);
            placement = this.getDefaultInterstitialPlacement();
            if (placement == null) {
                String noDefaultPlacement = "Default placement was not found, please make sure you are using the right placements.";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noDefaultPlacement, 3);
                return null;
            }
        }
        CappingManager.ECappingStatus cappingStatus = this.getInterstitialCappingStatus(placement.getPlacementName());
        String cappedMessage = this.getCappingMessage(placement.getPlacementName(), cappingStatus);
        if (!TextUtils.isEmpty((CharSequence)cappedMessage)) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, cappedMessage, 1);
            this.mListenersWrapper.setInterstitialPlacement(placement);
            this.mListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildCappedPerPlacementError(cappedMessage));
            return null;
        }
        return placement;
    }

    private boolean isOfferwallConfigurationsReady() {
        return this.mCurrentServerResponse != null && this.mCurrentServerResponse.getConfigurations() != null && this.mCurrentServerResponse.getConfigurations().getOfferwallConfigurations() != null;
    }

    @Override
    public void showOfferwall() {
        String logMessage = "showOfferwall()";
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
            if (!this.isOfferwallConfigurationsReady()) {
                this.mListenersWrapper.onOfferwallShowFailed(ErrorBuilder.buildInitFailedError("showOfferwall can't be called before the Offerwall ad unit initialization completed successfully", "Offerwall"));
                return;
            }
            OfferwallPlacement defaultPlacement = this.mCurrentServerResponse.getConfigurations().getOfferwallConfigurations().getDefaultOfferwallPlacement();
            if (defaultPlacement != null) {
                String placementName = defaultPlacement.getPlacementName();
                this.showOfferwall(placementName);
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
            this.mListenersWrapper.onOfferwallShowFailed(ErrorBuilder.buildInitFailedError("showOfferwall can't be called before the Offerwall ad unit initialization completed successfully", "Offerwall"));
        }
    }

    @Override
    public void showOfferwall(String placementName) {
        String logMessage = "showOfferwall(" + placementName + ")";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        try {
            if (!this.isOfferwallConfigurationsReady()) {
                this.mListenersWrapper.onOfferwallShowFailed(ErrorBuilder.buildInitFailedError("showOfferwall can't be called before the Offerwall ad unit initialization completed successfully", "Offerwall"));
                return;
            }
            OfferwallPlacement placement = this.mCurrentServerResponse.getConfigurations().getOfferwallConfigurations().getOfferwallPlacement(placementName);
            if (placement == null) {
                String noPlacementMessage = "Placement is not valid, please make sure you are using the right placements, using the default placement.";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noPlacementMessage, 3);
                placement = this.mCurrentServerResponse.getConfigurations().getOfferwallConfigurations().getDefaultOfferwallPlacement();
                if (placement == null) {
                    String noDefaultPlacement = "Default placement was not found, please make sure you are using the right placements.";
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noDefaultPlacement, 3);
                    return;
                }
            }
            this.mOfferwallManager.showOfferwall(placement.getPlacementName());
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
            this.mListenersWrapper.onOfferwallShowFailed(ErrorBuilder.buildInitFailedError("showOfferwall can't be called before the Offerwall ad unit initialization completed successfully", "Offerwall"));
        }
    }

    @Override
    public boolean isOfferwallAvailable() {
        boolean result = false;
        try {
            if (this.mOfferwallManager != null) {
                result = this.mOfferwallManager.isOfferwallAvailable();
            }
        }
        catch (Exception e2) {
            result = false;
        }
        return result;
    }

    @Override
    public void getOfferwallCredits() {
        String logMessage = "getOfferwallCredits()";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        try {
            this.mOfferwallManager.getOfferwallCredits();
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, logMessage, e2);
        }
    }

    @Override
    public void setOfferwallListener(OfferwallListener offerwallListener) {
        if (offerwallListener == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setOfferwallListener(OWListener:null)", 1);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setOfferwallListener(OWListener)", 1);
        }
        this.mListenersWrapper.setOfferwallListener(offerwallListener);
    }

    @Override
    public void setLogListener(LogListener logListener) {
        if (logListener == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setLogListener(LogListener:null)", 1);
        } else {
            this.mPublisherLogger.setLogListener(logListener);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "setLogListener(LogListener:" + logListener.getClass().getSimpleName() + ")", 1);
        }
    }

    private boolean isBannerConfigurationsReady() {
        return this.mCurrentServerResponse != null && this.mCurrentServerResponse.getConfigurations() != null && this.mCurrentServerResponse.getConfigurations().getBannerConfigurations() != null;
    }

    public IronSourceBannerLayout createBanner(Activity activity, ISBannerSize size) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "createBanner()", 1);
        if (activity == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "createBanner() : Activity cannot be null", 3);
            return null;
        }
        ContextProvider.getInstance().updateActivity(activity);
        return new IronSourceBannerLayout(activity, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBanner(IronSourceBannerLayout banner, String placementName) {
        IronLog.INTERNAL.verbose("placementName = " + placementName);
        if (banner == null || banner.isDestroyed()) {
            String message = "loadBanner can't be called - " + (banner == null ? "banner layout is null " : "banner layout is destroyed");
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, ErrorBuilder.buildLoadFailedError(message));
            return;
        }
        if (!this.mDidInitBanner) {
            String message = "init() must be called before loadBanner()";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, ErrorBuilder.buildLoadFailedError(message));
            return;
        }
        if (banner.getSize().getDescription().equals("CUSTOM") && (banner.getSize().getWidth() <= 0 || banner.getSize().getHeight() <= 0)) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "loadBanner: Unsupported banner size. Height and width must be bigger than 0", 3);
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, ErrorBuilder.unsupportedBannerSize(""));
            return;
        }
        MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
        if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(600, "Init() had failed"));
            return;
        }
        if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
            if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(601, "Init had failed"));
            } else {
                this.mBnLayoutToLoad = banner;
                this.mIsBnLoadBeforeInitCompleted = true;
                this.mBnPlacementToLoad = placementName;
            }
            return;
        }
        Boolean bl = this.mIsBnLoadBeforeInitCompleted;
        synchronized (bl) {
            if (this.mBannerManager == null && this.mProgBannerManager == null) {
                this.mBnLayoutToLoad = banner;
                this.mIsBnLoadBeforeInitCompleted = true;
                this.mBnPlacementToLoad = placementName;
                return;
            }
        }
        if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getBannerConfigurations() == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "No banner configurations found", 3);
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(615, "No banner configurations found"));
            return;
        }
        if (!this.mIsBnProgrammatic) {
            this.mBannerManager.loadBanner(banner, this.getBannerPlacement(placementName));
            return;
        }
        this.mProgBannerManager.loadBanner(banner, this.getBannerPlacement(placementName));
    }

    public void loadBanner(IronSourceBannerLayout banner) {
        this.loadBanner(banner, "");
    }

    public void destroyBanner(IronSourceBannerLayout banner) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "destroyBanner()", 1);
        try {
            if (this.mIsBnProgrammatic && this.mProgBannerManager != null) {
                this.mProgBannerManager.destroyBanner(banner);
            } else if (this.mBannerManager != null) {
                this.mBannerManager.destroyBanner(banner);
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, "destroyBanner()", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerResponseWrapper getServerResponse(Context context, String userId, IResponseListener listener) {
        ServerResponseWrapper response;
        Object object = this.mServerResponseLocker;
        synchronized (object) {
            if (this.mCurrentServerResponse != null) {
                return new ServerResponseWrapper(this.mCurrentServerResponse);
            }
            response = this.connectAndGetServerResponse(context, userId, listener);
            if (response == null || !response.isValidResponse()) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Null or invalid response. Trying to get cached response", 0);
                response = this.getCachedResponse(context, userId);
            }
            if (response != null) {
                this.mCurrentServerResponse = response;
                IronSourceUtils.saveLastResponse(context, response.toString());
                this.initializeSettingsFromServerResponse(this.mCurrentServerResponse, context);
            }
            InterstitialEventsManager.getInstance().setHasServerResponse(true);
            RewardedVideoEventsManager.getInstance().setHasServerResponse(true);
        }
        return response;
    }

    private ServerResponseWrapper getCachedResponse(Context context, String userId) {
        ServerResponseWrapper response = null;
        if (IronSourceUtils.isInitResponseCached(context)) {
            String cachedAppKey = IronSourceUtils.getCachedValueByKeyOfCachedInitResponse(context, "appKey");
            String cachedUserId = IronSourceUtils.getCachedValueByKeyOfCachedInitResponse(context, "userId");
            String cachedSettings = IronSourceUtils.getCachedValueByKeyOfCachedInitResponse(context, "response");
            if (this.getIronSourceAppKey() != null && cachedAppKey.equals(this.getIronSourceAppKey()) && cachedUserId.equals(userId)) {
                response = new ServerResponseWrapper(context, cachedAppKey, cachedUserId, cachedSettings);
                IronSourceError sse = ErrorBuilder.buildUsingCachedConfigurationError(cachedAppKey, cachedUserId);
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, sse.toString(), 1);
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, sse.toString() + ": " + response.toString(), 1);
                JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
                EventData event = new EventData(140, data);
                RewardedVideoEventsManager.getInstance().log(event);
            }
        }
        return response;
    }

    private ServerResponseWrapper connectAndGetServerResponse(Context context, String userId, IResponseListener listener) {
        if (!IronSourceUtils.isNetworkConnected(context)) {
            return null;
        }
        ServerResponseWrapper response = null;
        try {
            String gaid = this.getAdvertiserId(context);
            if (TextUtils.isEmpty((CharSequence)gaid)) {
                gaid = DeviceStatus.getOrGenerateOnceUniqueIdentifier(context);
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "using custom identifier", 1);
            }
            Vector<Pair<String, String>> additionParams = null;
            if (this.mIronSegment != null) {
                additionParams = this.mIronSegment.getSegmentData();
            }
            String mediationType = this.getMediationType();
            String serverResponseString = HttpFunctions.getStringFromURL(ServerURL.getCPVProvidersURL(context, this.getIronSourceAppKey(), userId, gaid, mediationType, additionParams), listener);
            if (serverResponseString == null) {
                IronLog.INTERNAL.warning("serverResponseString is null");
                return null;
            }
            if (IronSourceUtils.getSerr() == 1) {
                IronLog.INTERNAL.verbose("encrypt");
                JSONObject encryptedResponseJson = new JSONObject(serverResponseString);
                String encryptedResponse = encryptedResponseJson.optString("response", null);
                if (TextUtils.isEmpty((CharSequence)encryptedResponse)) {
                    IronLog.INTERNAL.warning("encryptedResponse is empty - return null");
                    return null;
                }
                serverResponseString = IronSourceAES.decode("C38FB23A402222A0C17D34A92F971D1F", encryptedResponse);
            }
            if (!(response = new ServerResponseWrapper(context, this.getIronSourceAppKey(), userId, serverResponseString)).isValidResponse()) {
                IronLog.INTERNAL.warning("response invalid - return null");
                return null;
            }
        }
        catch (Exception e2) {
            IronLog.INTERNAL.warning("exception = " + e2);
            e2.printStackTrace();
        }
        return response;
    }

    private void initializeSettingsFromServerResponse(ServerResponseWrapper response, Context context) {
        this.initializeLoggerManager(response);
        this.initializeEventsSettings(response, context);
    }

    private void initializeEventsSettings(ServerResponseWrapper response, Context context) {
        ApplicationEvents config;
        boolean isRVEventsEnabled = false;
        if (this.isRewardedVideoConfigurationsReady()) {
            isRVEventsEnabled = response.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoEventsConfigurations().isEventsEnabled();
        }
        boolean isISEventsEnabled = false;
        if (this.isInterstitialConfigurationsReady()) {
            isISEventsEnabled = response.getConfigurations().getInterstitialConfigurations().getInterstitialEventsConfigurations().isEventsEnabled();
        }
        boolean isBNEventsEnabled = false;
        if (this.isBannerConfigurationsReady()) {
            isBNEventsEnabled = response.getConfigurations().getBannerConfigurations().getBannerEventsConfigurations().isEventsEnabled();
        }
        boolean isOWEventsEnabled = false;
        if (this.isOfferwallConfigurationsReady()) {
            isOWEventsEnabled = response.getConfigurations().getOfferwallConfigurations().getOfferWallEventsConfigurations().isEventsEnabled();
        }
        if (isRVEventsEnabled) {
            config = response.getConfigurations().getRewardedVideoConfigurations().getRewardedVideoEventsConfigurations();
            RewardedVideoEventsManager.getInstance().setFormatterType(config.getEventsType(), context);
            RewardedVideoEventsManager.getInstance().setEventsUrl(config.getEventsURL(), context);
            RewardedVideoEventsManager.getInstance().setMaxNumberOfEvents(config.getMaxNumberOfEvents());
            RewardedVideoEventsManager.getInstance().setMaxEventsPerBatch(config.getMaxEventsPerBatch());
            RewardedVideoEventsManager.getInstance().setBackupThreshold(config.getEventsBackupThreshold());
            RewardedVideoEventsManager.getInstance().setOptOutEvents(config.getOptOutEvents(), context);
            RewardedVideoEventsManager.getInstance().setOptInEvents(config.getOptInEvents(), context);
            RewardedVideoEventsManager.getInstance().setTriggerEvents(config.getTriggerEvents(), context);
            RewardedVideoEventsManager.getInstance().setNonConnectivityEvents(config.getNonConnectivityEvents(), context);
            RewardedVideoEventsManager.getInstance().setServerSegmentData(response.getConfigurations().getApplicationConfigurations().getSegmetData());
        } else if (isOWEventsEnabled) {
            config = response.getConfigurations().getOfferwallConfigurations().getOfferWallEventsConfigurations();
            RewardedVideoEventsManager.getInstance().setFormatterType(config.getEventsType(), context);
            RewardedVideoEventsManager.getInstance().setEventsUrl(config.getEventsURL(), context);
            RewardedVideoEventsManager.getInstance().setMaxNumberOfEvents(config.getMaxNumberOfEvents());
            RewardedVideoEventsManager.getInstance().setMaxEventsPerBatch(config.getMaxEventsPerBatch());
            RewardedVideoEventsManager.getInstance().setBackupThreshold(config.getEventsBackupThreshold());
            RewardedVideoEventsManager.getInstance().setOptOutEvents(config.getOptOutEvents(), context);
            RewardedVideoEventsManager.getInstance().setOptInEvents(config.getOptInEvents(), context);
            RewardedVideoEventsManager.getInstance().setTriggerEvents(config.getTriggerEvents(), context);
            RewardedVideoEventsManager.getInstance().setNonConnectivityEvents(config.getNonConnectivityEvents(), context);
            RewardedVideoEventsManager.getInstance().setServerSegmentData(response.getConfigurations().getApplicationConfigurations().getSegmetData());
        } else {
            RewardedVideoEventsManager.getInstance().setIsEventsEnabled(false);
        }
        if (isISEventsEnabled) {
            config = response.getConfigurations().getInterstitialConfigurations().getInterstitialEventsConfigurations();
            InterstitialEventsManager.getInstance().setFormatterType(config.getEventsType(), context);
            InterstitialEventsManager.getInstance().setEventsUrl(config.getEventsURL(), context);
            InterstitialEventsManager.getInstance().setMaxNumberOfEvents(config.getMaxNumberOfEvents());
            InterstitialEventsManager.getInstance().setMaxEventsPerBatch(config.getMaxEventsPerBatch());
            InterstitialEventsManager.getInstance().setBackupThreshold(config.getEventsBackupThreshold());
            InterstitialEventsManager.getInstance().setOptOutEvents(config.getOptOutEvents(), context);
            InterstitialEventsManager.getInstance().setOptInEvents(config.getOptInEvents(), context);
            InterstitialEventsManager.getInstance().setTriggerEvents(config.getTriggerEvents(), context);
            InterstitialEventsManager.getInstance().setNonConnectivityEvents(config.getNonConnectivityEvents(), context);
            InterstitialEventsManager.getInstance().setServerSegmentData(response.getConfigurations().getApplicationConfigurations().getSegmetData());
        } else if (isBNEventsEnabled) {
            config = response.getConfigurations().getBannerConfigurations().getBannerEventsConfigurations();
            InterstitialEventsManager.getInstance().setFormatterType(config.getEventsType(), context);
            InterstitialEventsManager.getInstance().setEventsUrl(config.getEventsURL(), context);
            InterstitialEventsManager.getInstance().setMaxNumberOfEvents(config.getMaxNumberOfEvents());
            InterstitialEventsManager.getInstance().setMaxEventsPerBatch(config.getMaxEventsPerBatch());
            InterstitialEventsManager.getInstance().setBackupThreshold(config.getEventsBackupThreshold());
            InterstitialEventsManager.getInstance().setOptOutEvents(config.getOptOutEvents(), context);
            InterstitialEventsManager.getInstance().setOptInEvents(config.getOptInEvents(), context);
            InterstitialEventsManager.getInstance().setTriggerEvents(config.getTriggerEvents(), context);
            InterstitialEventsManager.getInstance().setNonConnectivityEvents(config.getNonConnectivityEvents(), context);
            InterstitialEventsManager.getInstance().setServerSegmentData(response.getConfigurations().getApplicationConfigurations().getSegmetData());
        } else {
            InterstitialEventsManager.getInstance().setIsEventsEnabled(false);
        }
    }

    private void initializeLoggerManager(ServerResponseWrapper response) {
        this.mPublisherLogger.setDebugLevel(response.getConfigurations().getApplicationConfigurations().getLoggerConfigurations().getPublisherLoggerLevel());
        this.mLoggerManager.setLoggerDebugLevel("console", response.getConfigurations().getApplicationConfigurations().getLoggerConfigurations().getConsoleLoggerLevel());
    }

    @Override
    public void removeRewardedVideoListener() {
        String logMessage = "removeRewardedVideoListener()";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mListenersWrapper.setRewardedVideoListener(null);
    }

    @Override
    public void removeInterstitialListener() {
        String logMessage = "removeInterstitialListener()";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mListenersWrapper.setInterstitialListener(null);
    }

    @Override
    public void removeOfferwallListener() {
        String logMessage = "removeOfferwallListener()";
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mListenersWrapper.setOfferwallListener(null);
    }

    void setIronSourceUserId(String userId, boolean isFromPublisher) {
        IronLog.API.verbose("userId = " + userId + ", isFromPublisher = " + isFromPublisher);
        this.mUserId = userId;
        if (isFromPublisher) {
            JSONObject data = IronSourceUtils.getJsonForUserId(false);
            EventData instanceEvent = new EventData(52, data);
            RewardedVideoEventsManager.getInstance().log(instanceEvent);
        }
    }

    public String getIronSourceAppKey() {
        return this.mAppKey;
    }

    public String getIronSourceUserId() {
        return this.mUserId;
    }

    private ConfigValidationResult validateAppKey(String appKey) {
        ConfigValidationResult result = new ConfigValidationResult();
        if (appKey != null) {
            if (this.validateLength(appKey, 5, 10)) {
                if (!this.validateAlphanumeric(appKey)) {
                    IronSourceError error = ErrorBuilder.buildInvalidCredentialsError("appKey", appKey, "should contain only english characters and numbers");
                    result.setInvalid(error);
                }
            } else {
                IronSourceError error = ErrorBuilder.buildInvalidCredentialsError("appKey", appKey, "length should be between 5-10 characters");
                result.setInvalid(error);
            }
        } else {
            IronSourceError error = new IronSourceError(506, "Init Fail - appKey is missing");
            result.setInvalid(error);
        }
        return result;
    }

    private void validateSegment(String segment, ConfigValidationResult result) {
        try {
            if (segment != null && segment.length() > 64) {
                result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("segment", "SupersonicAds", "segment value should not exceed 64 characters."));
            }
        }
        catch (Exception e2) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("segment", "SupersonicAds", "segment value should not exceed 64 characters."));
        }
    }

    private void validateDynamicUserId(String dynamicUserId, ConfigValidationResult result) {
        if (!this.validateLength(dynamicUserId, 1, 128)) {
            result.setInvalid(ErrorBuilder.buildInvalidKeyValueError("dynamicUserId", "SupersonicAds", "dynamicUserId is invalid, should be between 1-128 chars in length."));
        }
    }

    private boolean validateLength(String key, int minLength, int maxLength) {
        return key != null && key.length() >= minLength && key.length() <= maxLength;
    }

    private boolean validateAlphanumeric(String key) {
        if (key == null) {
            return false;
        }
        String pattern = "^[a-zA-Z0-9]*$";
        return key.matches(pattern);
    }

    @Override
    public InterstitialPlacement getInterstitialPlacementInfo(String placementName) {
        InterstitialPlacement placement = null;
        try {
            placement = this.getInterstitialPlacement(placementName);
            if (placement == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Placement is not valid, please make sure you are using the right placements, using the default placement.", 2);
                placement = this.getDefaultInterstitialPlacement();
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "getPlacementInfo(placement: " + placementName + "):" + placement, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return placement;
    }

    @Override
    public Placement getRewardedVideoPlacementInfo(String placementName) {
        Placement placement = null;
        try {
            placement = this.getRewardedVideoPlacement(placementName);
            if (placement == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Placement is not valid, please make sure you are using the right placements, using the default placement.", 2);
                placement = this.getDefaultRewardedVideoPlacement();
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "getPlacementInfo(placement: " + placementName + "):" + placement, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return placement;
    }

    @Override
    public String getAdvertiserId(Context context) {
        try {
            String[] deviceInfo = DeviceStatus.getAdvertisingIdInfo(context);
            if (deviceInfo.length > 0 && deviceInfo[0] != null) {
                return deviceInfo[0];
            }
        }
        catch (Exception e2) {
            return "";
        }
        return "";
    }

    @Override
    public void shouldTrackNetworkState(Context context, boolean track) {
        this.mTrackNetworkStateContext = context;
        this.mShouldTrackNetworkState = track;
        if (this.mIsIsProgrammatic) {
            if (this.mProgIsManager != null) {
                this.mProgIsManager.shouldTrackNetworkState(context, track);
            }
        } else if (this.mInterstitialManager != null) {
            this.mInterstitialManager.shouldTrackNetworkState(context, track);
        }
        if (this.mIsRvProgrammatic) {
            if (this.mProgRvManager != null) {
                this.mProgRvManager.shouldTrackNetworkState(context, track);
            }
        } else if (this.mRewardedVideoManager != null) {
            this.mRewardedVideoManager.shouldTrackNetworkState(context, track);
        }
    }

    boolean isInterstitialPlacementCapped(String placementName) {
        boolean isCapped;
        if (this.mIsDemandOnlyIs) {
            return false;
        }
        boolean bl = isCapped = this.getInterstitialCappingStatus(placementName) != CappingManager.ECappingStatus.NOT_CAPPED;
        if (isCapped) {
            JSONObject data = IronSourceUtils.getMediationAdditionalData(this.mIsDemandOnlyIs, this.mIsIsProgrammatic, 1);
            try {
                data.put("placement", (Object)placementName);
                if (this.mIsIsProgrammatic) {
                    data.put("programmatic", 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventData event = new EventData(2103, data);
            InterstitialEventsManager.getInstance().log(event);
        }
        return isCapped;
    }

    boolean isRewardedVideoPlacementCapped(String placementName) {
        boolean isCapped = false;
        CappingManager.ECappingStatus cappingStatus = this.getRewardedVideoCappingStatus(placementName);
        if (cappingStatus != null) {
            switch (cappingStatus) {
                case CAPPED_PER_DELIVERY: 
                case CAPPED_PER_COUNT: 
                case CAPPED_PER_PACE: {
                    isCapped = true;
                    break;
                }
            }
        }
        this.sendIsCappedEvent(isCapped, placementName);
        return isCapped;
    }

    boolean isBannerPlacementCapped(String placementName) {
        if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getBannerConfigurations() == null) {
            return false;
        }
        BannerPlacement placement = null;
        try {
            placement = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations().getBannerPlacement(placementName);
            if (placement == null && (placement = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations().getDefaultBannerPlacement()) == null) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Banner default placement was not found", 3);
                return false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (placement == null) {
            return false;
        }
        return CappingManager.isBnPlacementCapped((Context)this.mActivity, placement.getPlacementName());
    }

    private CappingManager.ECappingStatus getInterstitialCappingStatus(String placementName) {
        if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getInterstitialConfigurations() == null) {
            return CappingManager.ECappingStatus.NOT_CAPPED;
        }
        InterstitialPlacement placement = null;
        try {
            placement = this.getInterstitialPlacement(placementName);
            if (placement == null && (placement = this.getDefaultInterstitialPlacement()) == null) {
                String noDefaultPlacement = "Default placement was not found";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noDefaultPlacement, 3);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (placement == null) {
            return CappingManager.ECappingStatus.NOT_CAPPED;
        }
        return CappingManager.isPlacementCapped((Context)this.mActivity, placement);
    }

    private CappingManager.ECappingStatus getRewardedVideoCappingStatus(String placementName) {
        if (this.mCurrentServerResponse == null || this.mCurrentServerResponse.getConfigurations() == null || this.mCurrentServerResponse.getConfigurations().getRewardedVideoConfigurations() == null) {
            return CappingManager.ECappingStatus.NOT_CAPPED;
        }
        Placement placement = null;
        try {
            placement = this.getRewardedVideoPlacement(placementName);
            if (placement == null && (placement = this.getDefaultRewardedVideoPlacement()) == null) {
                String noDefaultPlacement = "Default placement was not found";
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, noDefaultPlacement, 3);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (placement == null) {
            return CappingManager.ECappingStatus.NOT_CAPPED;
        }
        return CappingManager.isPlacementCapped((Context)this.mActivity, placement);
    }

    private void sentEventWithISEventManager(int eventId, JSONObject data) {
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sentEventWithRVEventManager(int eventId, JSONObject data) {
        EventData event = new EventData(eventId, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void sendIsCappedEvent(boolean isCapped, String placementName) {
        if (!isCapped) {
            return;
        }
        JSONObject data = IronSourceUtils.getMediationAdditionalData(this.mIsDemandOnlyRv, this.mIsRvProgrammatic, this.rvProgrammaticMode);
        if (placementName != null) {
            this.addToDictionary(data, new Object[][]{{"placement", placementName}});
        }
        this.sentEventWithRVEventManager(1110, data);
    }

    String getCappingMessage(String placementName, CappingManager.ECappingStatus cappingStatus) {
        if (cappingStatus == null) {
            return null;
        }
        switch (cappingStatus) {
            case CAPPED_PER_DELIVERY: 
            case CAPPED_PER_COUNT: 
            case CAPPED_PER_PACE: {
                return "placement " + placementName + " is capped";
            }
        }
        return null;
    }

    ServerResponseWrapper getCurrentServerResponse() {
        return this.mCurrentServerResponse;
    }

    void setSegmentListener(SegmentListener listener) {
        if (this.mListenersWrapper != null) {
            this.mListenersWrapper.setSegmentListener(listener);
            MediationInitializer.getInstance().setSegmentListener(this.mListenersWrapper);
        }
    }

    HashSet<String> getAllSettingsForProvider(String providerName, String fieldName) {
        if (this.mCurrentServerResponse == null) {
            return new HashSet<String>();
        }
        return this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettingsByReflectionName(providerName, fieldName);
    }

    private BannerPlacement getBannerPlacement(String placementName) {
        BannerConfigurations bannerConfigurations = this.mCurrentServerResponse.getConfigurations().getBannerConfigurations();
        if (bannerConfigurations == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)placementName)) {
            return bannerConfigurations.getDefaultBannerPlacement();
        }
        BannerPlacement placement = bannerConfigurations.getBannerPlacement(placementName);
        if (placement != null) {
            return placement;
        }
        return bannerConfigurations.getDefaultBannerPlacement();
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public void setConsent(boolean consent) {
        this.mConsent = consent;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "setConsent : " + consent, 1);
        AdapterRepository.getInstance().setConsent(consent);
        if (this.mOfferwallAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Offerwall | setConsent(consent:" + consent + ")", 1);
            this.mOfferwallAdapter.setConsent(consent);
        }
        int code = 40;
        if (!consent) {
            code = 41;
        }
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
        EventData instanceEvent = new EventData(code, data);
        RewardedVideoEventsManager.getInstance().log(instanceEvent);
    }

    Boolean getConsent() {
        return this.mConsent;
    }

    private void addToDictionary(JSONObject data, Object[][] keyVals) {
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IronSourceObject addToDictionary: " + Log.getStackTraceString((Throwable)e2), 3);
        }
    }

    public void setMetaData(String key, List<String> values) {
        if (MediationInitializer.getInstance().getCurrentInitStatus() == MediationInitializer.EInitStatus.INITIATED) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "setMetaData must be called prior to Init. Calling it after init will be ignored", 1);
            JSONObject data = IronSourceUtils.getJsonForMetaData(key, values, new ArrayList<String>());
            EventData metaDataEvent = new EventData(51, data);
            RewardedVideoEventsManager.getInstance().log(metaDataEvent);
            return;
        }
        IronLog.API.verbose("key = " + key + ", values = " + values.toString());
        String keyValidity = MetaDataUtils.checkMetaDataKeyValidity(key);
        String valueValidity = MetaDataUtils.checkMetaDataValueValidity(values);
        if (keyValidity.length() > 0) {
            IronLog.API.verbose(keyValidity);
            return;
        }
        if (valueValidity.length() > 0) {
            IronLog.API.verbose(valueValidity);
            return;
        }
        MetaData formattedMetaData = MetaDataUtils.formatMetaData(key, values);
        String formattedKey = formattedMetaData.getMetaDataKey();
        List<String> formattedValues = formattedMetaData.getMetaDataValue();
        if (MetaDataUtils.isMediationOnlyKey(formattedKey)) {
            IronsourceObjectPublisherDataHolder.getInstance().setMetaData(formattedKey, formattedValues);
        } else {
            AdapterRepository.getInstance().setMetaData(formattedKey, formattedValues);
        }
        JSONObject data = IronSourceUtils.getJsonForMetaData(key, values, formattedValues);
        EventData metaDataEvent = new EventData(50, data);
        RewardedVideoEventsManager.getInstance().log(metaDataEvent);
    }

    public String getISDemandOnlyBiddingData() {
        this.sentEventWithRVEventManager(83005, null);
        IronLog.API.info("");
        String biddingData = null;
        if (this.mCurrentServerResponse == null) {
            IronLog.ADAPTER_API.error("bidding data cannot be retrieved, SDK not initialized");
        } else {
            ProviderSettings providersSettings = this.mCurrentServerResponse.getProviderSettingsHolder().getProviderSettings("IronSource");
            if (providersSettings != null) {
                JSONObject playerToken = new JSONObject();
                AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(providersSettings, providersSettings.getApplicationSettings(), true);
                try {
                    if (adapter != null) {
                        playerToken = adapter.getPlayerBiddingData();
                    }
                    TokenSettings tokenSettings = this.mCurrentServerResponse.getConfigurations().getApplicationConfigurations().getTokenSettings();
                    JSONObject token = AuctionDataUtils.getInstance().createToken(playerToken, tokenSettings.getGenericParams(), tokenSettings.getOptInKeyParamsTokenArray());
                    biddingData = AuctionDataUtils.getInstance().encryptToken(token);
                }
                catch (Exception e2) {
                    this.sentEventWithRVEventManager(83007, null);
                    IronLog.ADAPTER_API.error("got error during creating the token: " + e2.getMessage());
                }
            }
        }
        if (biddingData == null) {
            this.sentEventWithRVEventManager(83006, null);
        }
        return biddingData;
    }

    @Override
    public void addImpressionDataListener(@NotNull ImpressionDataListener listener) {
        if (!IronSourcePreconditions.checkNotNull(listener, "addImpressionDataListener - listener is null")) {
            return;
        }
        IronsourceObjectPublisherDataHolder.getInstance().addImpressionDataListener(listener);
        if (this.mProgRvManager != null) {
            this.mProgRvManager.addImpressionDataListener(listener);
        }
        if (this.mProgIsManager != null) {
            this.mProgIsManager.addImpressionDataListener(listener);
        }
        if (this.mProgBannerManager != null) {
            this.mProgBannerManager.addImpressionDataListener(listener);
        }
        IronLog.API.info("add impression data listener to " + listener.getClass().getSimpleName());
    }

    @Override
    public void removeImpressionDataListener(@NotNull ImpressionDataListener listener) {
        if (!IronSourcePreconditions.checkNotNull(listener, "removeImpressionDataListener - listener is null")) {
            return;
        }
        IronsourceObjectPublisherDataHolder.getInstance().removeImpressionDataListener(listener);
        if (this.mProgRvManager != null) {
            this.mProgRvManager.removeImpressionDataListener(listener);
        }
        if (this.mProgIsManager != null) {
            this.mProgIsManager.removeImpressionDataListener(listener);
        }
        if (this.mProgBannerManager != null) {
            this.mProgBannerManager.removeImpressionDataListener(listener);
        }
        IronLog.API.info("remove impression data listener from " + listener.getClass().getSimpleName());
    }

    public void removeAllImpressionDataListeners() {
        IronLog.API.info("removing all impression data listeners");
        IronsourceObjectPublisherDataHolder.getInstance().removeAllImpressionDataListeners();
        if (this.mProgRvManager != null) {
            this.mProgRvManager.removeAllImpressionDataListeners();
        }
        if (this.mProgIsManager != null) {
            this.mProgIsManager.removeAllImpressionDataListeners();
        }
        if (this.mProgBannerManager != null) {
            this.mProgBannerManager.removeAllImpressionDataListeners();
        }
    }

    public static interface IResponseListener {
        public void onUnrecoverableError(String var1);
    }

    private static class IronSourceObjectLoader {
        static volatile IronSourceObject INSTANCE = new IronSourceObject();

        private IronSourceObjectLoader() {
        }
    }
}

