/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.impressionData.ImpressionData;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.logger.IronLog;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class BaseProgManager {
    private HashSet<ImpressionDataListener> impressionDataListeners = new HashSet();

    public BaseProgManager(HashSet<ImpressionDataListener> impressionDataListeners) {
        this.impressionDataListeners = impressionDataListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImpressionDataListener(@NotNull ImpressionDataListener impressionDataListener) {
        BaseProgManager baseProgManager = this;
        synchronized (baseProgManager) {
            this.impressionDataListeners.add(impressionDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImpressionDataListener(@NotNull ImpressionDataListener impressionDataListener) {
        BaseProgManager baseProgManager = this;
        synchronized (baseProgManager) {
            this.impressionDataListeners.remove(impressionDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllImpressionDataListeners() {
        BaseProgManager baseProgManager = this;
        synchronized (baseProgManager) {
            this.impressionDataListeners.clear();
        }
    }

    protected void reportImpressionDataToPublisher(AuctionResponseItem auctionResponseItem, String placementName) {
        if (auctionResponseItem != null) {
            ImpressionData impressionData = auctionResponseItem.getImpressionData(placementName);
            if (impressionData != null) {
                for (ImpressionDataListener listener : this.impressionDataListeners) {
                    IronLog.CALLBACK.info("onImpressionSuccess " + listener.getClass().getSimpleName() + ": " + impressionData);
                    listener.onImpressionSuccess(impressionData);
                }
            }
        } else {
            IronLog.INTERNAL.verbose("no auctionResponseItem or listener");
        }
    }

    protected String getAuctionFallbackId() {
        return "fallback_" + System.currentTimeMillis();
    }
}

