/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.environment;

import android.os.Build;
import com.ironsource.environment.CrashReporter;
import com.ironsource.environment.ExceptionLog;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler mBaseHandler;

    CrashHandler(Thread.UncaughtExceptionHandler baseHandler) {
        this.mBaseHandler = baseHandler;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e2) {
        if (Build.VERSION.SDK_INT >= 19) {
            StackTraceElement[] arr = e2.getStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append(e2.toString());
            builder.append(System.lineSeparator());
            boolean isIronsourceCrash = false;
            for (StackTraceElement elem : arr) {
                builder.append(elem.toString());
                builder.append(";" + System.lineSeparator());
                if (!elem.toString().contains(CrashReporter.getInstance().getKeyword())) continue;
                isIronsourceCrash = true;
            }
            Throwable cause = e2.getCause();
            if (cause != null) {
                builder.append("--CAUSE");
                builder.append(System.lineSeparator());
                builder.append(cause.toString());
                builder.append(System.lineSeparator());
                for (StackTraceElement elem : arr = cause.getStackTrace()) {
                    builder.append(elem.toString());
                    builder.append(";" + System.lineSeparator());
                    if (!elem.toString().contains(CrashReporter.getInstance().getKeyword())) continue;
                    isIronsourceCrash = true;
                }
            }
            if (isIronsourceCrash) {
                ExceptionLog ex = new ExceptionLog(builder.toString(), "" + System.currentTimeMillis());
                ex.Save();
            }
            this.mBaseHandler.uncaughtException(t, e2);
        }
    }
}

